/*
   File: rts_ints.c
   Provides int engine
*/

/* global includes */
#include <stdio.h>

/* local includes */
#include <rts_error.h>
#include <rts_ints.h>

int int_div_int (int a, int b)
	{ if (!b) rts_error ("division by 0");
	  return (a/b);
	};

int int_mod_int (int a, int b)
	{ if (!b) rts_error ("division by 0");
	  return (a%b);
	};

int int_pow_int (int a, int b)
	{ int z = 1;
	  if (b < 0) return (1/int_pow_int (a,-b));
	  while (b > 0)
	     { if (b & 1) z = z * a;
	       a = a * a;
	       b = b >> 1;
	     };
	  return (z);
	};
