/*
 * variables.c -- part of the C sources generated from the CDL3 sources,
 *              used to bootstrap CDL3
 * Copyright (C) 2000  C.H.A. Koster
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "cdl3rts.h"
#include "predef.h"


static char* module_name = "variables";

/*
** GLOBALS
*/

	static long undefined[] = {1023};
long G_variables_HASHEDNAMES_NR0B = 0;
value G_variables_HASHEDNAMES_NR0 = &G_variables_HASHEDNAMES_NR0B;
long G_variables_NAMES_NR1B = 0;
value G_variables_NAMES_NR1 = &G_variables_NAMES_NR1B;
long G_variables_V_OFFSET_NR2A = 1;
value G_variables_V_OFFSET_NR2 = &G_variables_V_OFFSET_NR2A;
long G_variables_NR_OF_NAMES_NR3 = 0;
long G_variables_NORULE_NR4 = 0;
long G_variables_NR_GLOBALS_NR5 = 0;
long G_variables_TEXT_NR2896[] = {Tag(1,T_TEXT),20,(long)"The global variable "};
long G_variables_TEXT_NR2897[] = {Tag(1,T_TEXT),4,(long)" in "};
long G_variables_TEXT_NR2898[] = {Tag(1,T_TEXT),29,(long)" has already been defined...\n"};
long G_variables_TEXT_NR2899[] = {Tag(1,T_TEXT),14,(long)"The parameter "};
long G_variables_TEXT_NR2900[] = {Tag(1,T_TEXT),4,(long)" of "};
long G_variables_TEXT_NR2901[] = {Tag(1,T_TEXT),4,(long)" in "};
long G_variables_TEXT_NR2902[] = {Tag(1,T_TEXT),29,(long)" has already been defined...\n"};
long G_variables_INSTANCE_NR2903[] = {Tag(1,1)};
long G_variables_INSTANCE_NR2904[] = {Tag(1,1)};
long G_variables_SIZE_NR2905[] = {Tag(1,1)};
long G_variables_SIZE_NR2906[] = {Tag(1,1)};
long G_variables_SIZE_NR2907[] = {Tag(1,2)};
long G_variables_TEXT_NR2908[] = {Tag(1,T_TEXT),0,(long)""};
long G_variables_VARIABLENRLIST_NR2909[] = {Tag(1,1)};

/*
** ATTACH/DETACH/EQUAL
*/
/****NAMES(variables)****/

int EQ_Mvariables_T2(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return (Part(x,1) == Part(y,1))&&(Part(x,2) == Part(y,2))&&(Part(x,3) == Part(y,3))&&EQ_Mvariables_T8(Part(x,4),Part(y,4));
       case 1:
         return (Part(x,1) == Part(y,1))&&(Part(x,2) == Part(y,2))&&(Part(x,3) == Part(y,3))&&EQ_Mvariables_T8(Part(x,4),Part(y,4));
       case 2:
         return (Part(x,1) == Part(y,1))&&(Part(x,2) == Part(y,2))&&EQ_Mvariables_T12(Part(x,3),Part(y,3));
       case 3:
         return (Part(x,1) == Part(y,1))&&(Part(x,2) == Part(y,2))&&EQ_Mvariables_T8(Part(x,3),Part(y,3))&&EQ_Mvariables_T9(Part(x,4),Part(y,4))&&(Part(x,5) == Part(y,5));
    };
  return 0;
}

int W_Mvariables_T2(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
WRITE("local ");
W_INT(Part(x,1));
WRITE(" ");
W_INT(Part(x,2));
WRITE(" ");
W_INT(Part(x,3));
WRITE(" ");
W_Mvariables_T8(Part(x,4));
WRITE(" ");
       case 1:
WRITE("pass ");
WRITE("two ");
WRITE("local ");
W_INT(Part(x,1));
WRITE(" ");
W_INT(Part(x,2));
WRITE(" ");
W_INT(Part(x,3));
WRITE(" ");
W_Mvariables_T8(Part(x,4));
WRITE(" ");
       case 2:
WRITE("constant ");
W_INT(Part(x,1));
WRITE(" ");
W_INT(Part(x,2));
WRITE(" ");
W_Mvariables_T12(Part(x,3));
WRITE(" ");
       case 3:
WRITE("global ");
W_INT(Part(x,1));
WRITE(" ");
W_INT(Part(x,2));
WRITE(" ");
W_Mvariables_T8(Part(x,3));
WRITE(" ");
W_Mvariables_T9(Part(x,4));
WRITE(" ");
W_INT(Part(x,5));
WRITE(" ");
    };
  return 0;
}

int XD_Mvariables_T2(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
D_Mvariables_T8(Part(x,4));
            Free(x,5);
            break;
          case 1:
D_Mvariables_T8(Part(x,4));
            Free(x,5);
            break;
          case 2:
D_Mvariables_T12(Part(x,3));
            Free(x,4);
            break;
          case 3:
D_Mvariables_T8(Part(x,3));
D_Mvariables_T9(Part(x,4));
            Free(x,6);
            break;
    };
}

int D_Mvariables_T2(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Mvariables_T2(x);
}

/****INSTANCE(variables)****/

int EQ_Mvariables_T8(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return (Part(x,1) == Part(y,1));
       case 1:
         return 1;
    };
  return 0;
}

int W_Mvariables_T8(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
W_INT(Part(x,1));
WRITE(" ");
       case 1:
WRITE("none ");
    };
  return 0;
}

int XD_Mvariables_T8(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
            Free(x,2);
            break;
          case 1:
            Free(x,1);
            break;
    };
}

int D_Mvariables_T8(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Mvariables_T8(x);
}

/****SIZE(variables)****/

int EQ_Mvariables_T9(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return (Part(x,1) == Part(y,1));
       case 1:
         return 1;
       case 2:
         return 1;
       case 3:
         return 1;
    };
  return 0;
}

int W_Mvariables_T9(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
W_INT(Part(x,1));
WRITE(" ");
       case 1:
WRITE("local ");
       case 2:
WRITE("pass ");
WRITE("two ");
WRITE("local ");
       case 3:
WRITE("unlimited ");
    };
  return 0;
}

int XD_Mvariables_T9(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
            Free(x,2);
            break;
          case 1:
            Free(x,1);
            break;
          case 2:
            Free(x,1);
            break;
          case 3:
            Free(x,1);
            break;
    };
}

int D_Mvariables_T9(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Mvariables_T9(x);
}

/****PASS(variables)****/

int EQ_Mvariables_T11(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return 1;
       case 1:
         return 1;
    };
  return 0;
}

int W_Mvariables_T11(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
WRITE("one ");
       case 1:
WRITE("two ");
    };
  return 0;
}

int XD_Mvariables_T11(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
            Free(x,1);
            break;
          case 1:
            Free(x,1);
            break;
    };
}

int D_Mvariables_T11(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Mvariables_T11(x);
}

/****VALUE(variables)****/

int EQ_Mvariables_T12(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return EQ_TEXT(Part(x,1),Part(y,1));
       case 1:
         return (Part(x,1) == Part(y,1));
    };
  return 0;
}

int W_Mvariables_T12(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
WRITE("\"");
W_TEXT(Part(x,1));
WRITE("\"");
WRITE(" ");
       case 1:
W_INT(Part(x,1));
WRITE(" ");
    };
  return 0;
}

int XD_Mvariables_T12(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
D_TEXT(Part(x,1));
            Free(x,2);
            break;
          case 1:
            Free(x,2);
            break;
    };
}

int D_Mvariables_T12(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Mvariables_T12(x);
}

/****VARIABLENRLIST(variables)****/

int EQ_Mvariables_T34(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return (Part(x,1) == Part(y,1))&&EQ_Mvariables_T34(Part(x,2),Part(y,2));
       case 1:
         return 1;
    };
  return 0;
}

int W_Mvariables_T34(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
W_INT(Part(x,1));
WRITE(" ");
W_Mvariables_T34(Part(x,2));
WRITE(" ");
       case 1:
WRITE("end ");
    };
  return 0;
}

int XD_Mvariables_T34(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
D_Mvariables_T34(Part(x,2));
            Free(x,3);
            break;
          case 1:
            Free(x,1);
            break;
    };
}

int D_Mvariables_T34(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Mvariables_T34(x);
}


/*
** PROTOTYPES
*/

_PROTOTYPE(int Mvariables_P_convert_PASS_MODULENR_RULENR_TYPENR_INSTANCE_VARIABLENR,(value P0,value P1,value P2,value P3,value P4,value *P5));
_PROTOTYPE(int Mvariables_P_store_global_MODULENR_TYPENR_INSTANCE_SIZE,(value P0,value P1,value P2,value P3));
_PROTOTYPE(int Mvariables_P_parameter_MODULENR_RULENR_TYPENR_INSTANCE_VARIABLENR,(value P0,value P1,value P2,value P3,value *P4));
_PROTOTYPE(int Mvariables_P_temporary_MODULENR_RULENR_TYPENR_VARIABLENR,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(int Mvariables_P_constant_MODULENR_TYPENR_VALUE_VARIABLENR,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(int Mvariables_P_get_VARIABLENR_MODULENR_TYPENR_INSTANCE_SIZE,(value P0,value *P1,value *P2,value *P3,value *P4));
_PROTOTYPE(int Mvariables_P_set_VARIABLENR_OFFSET,(value P0,value P1));
_PROTOTYPE(int Mvariables_P_get_VARIABLENR_OFFSET,(value P0,value *P1));
_PROTOTYPE(int Mvariables_P_is_not_local_VARIABLENR,(value P0));
_PROTOTYPE(int Mvariables_P_is_constant_VARIABLENR_VALUE,(value P0,value *P1));
_PROTOTYPE(int Mvariables_P_is_global_VARIABLENR_REFNO,(value P0,value *P1));
_PROTOTYPE(int Mvariables_P_first_global_VARIABLENR,(value *P0));
_PROTOTYPE(int Mvariables_P_next_global_VARIABLENR,(value *P0));
_PROTOTYPE(int Mvariables_P_error_INSTANCE,(value P0));
_PROTOTYPE(int Mvariables_P_build_instance_INSTANCE_TEXT,(value P0,value *P1));
_PROTOTYPE(int Mvariables_P_init_hash_table,());
_PROTOTYPE(int Mvariables_P_init_hash_table_INDEX,(value P0));
_PROTOTYPE(int Mvariables_P_exists_MODULENR_RULENR_TYPENR_INSTANCE_VARIABLENRLIST_VARIABLENR,(value P0,value P1,value P2,value P3,value P4,value *P5));


/*
**EXTERNAL PROTOTYPES**
*/

_PROTOTYPE(extern int E1_open_input_file_TEXT_FILE,(value P0,value *P1));
_PROTOTYPE(extern int E2_open_output_file_TEXT_FILE,(value P0,value *P1));
_PROTOTYPE(extern int E3_open_standard_output_FILE,(value *P0));
_PROTOTYPE(extern int E4_open_standard_error_FILE,(value *P0));
_PROTOTYPE(extern int E5_open_standard_input_FILE,(value *P0));
_PROTOTYPE(extern int E8_pipe_to_command_TEXT_FILE,(value P0,value *P1));
_PROTOTYPE(extern int E28_pipe_from_command_TEXT_FILE,(value P0,value *P1));
_PROTOTYPE(extern int E9_close_pipe_FILE,(value P0));
_PROTOTYPE(extern int E6_close_FILE,(value P0));
_PROTOTYPE(extern int E7_seek_FILE_INT,(value P0,value P1));
_PROTOTYPE(extern int E10_write_TEXT,(value P0));
_PROTOTYPE(extern int E11_write_INT,(value P0));
_PROTOTYPE(extern int E12_write_FILE_TEXT,(value P0,value P1));
_PROTOTYPE(extern int E13_write_FILE_INT,(value P0,value P1));
_PROTOTYPE(extern int E14_formatted_write_FILE_FORMAT,(value P0,value P1));
_PROTOTYPE(extern int E15_write_char_FILE_INT,(value P0,value P1));
_PROTOTYPE(extern int E16_write_char_INT,(value P0));
_PROTOTYPE(extern int E20_trace_TEXT,(value P0));
_PROTOTYPE(extern int E21_trace_INT,(value P0));
_PROTOTYPE(extern int E22_formatted_trace_FILE_FORMAT,(value P0,value P1));
_PROTOTYPE(extern int E30_read_line_TEXT,(value *P0));
_PROTOTYPE(extern int E31_read_line_FILE_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int E32_read_char_FILE_INT,(value P0,value *P1));
_PROTOTYPE(extern int E33_read_char_INT,(value *P0));
_PROTOTYPE(extern int E40_less_INT_INT,(value P0,value P1));
_PROTOTYPE(extern int E41_lesseq_INT_INT,(value P0,value P1));
_PROTOTYPE(extern int E42_greater_INT_INT,(value P0,value P1));
_PROTOTYPE(extern int E43_greatereq_INT_INT,(value P0,value P1));
_PROTOTYPE(extern int E58_length_TEXT_INT,(value P0,value *P1));
_PROTOTYPE(extern int E51_extract_TEXT_INT_INT_TEXT,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int E52_is_subtext_TEXT_INT_TEXT,(value P0,value *P1,value P2));
_PROTOTYPE(extern int E53_between_TEXT_INT_TEXT_TEXT,(value P0,value P1,value P2,value P3));
_PROTOTYPE(extern int E54_not_between_TEXT_INT_TEXT_TEXT,(value P0,value P1,value P2,value P3));
_PROTOTYPE(extern int E55_before_TEXT_TEXT,(value P0,value P1));
_PROTOTYPE(extern int E56_is_prefix_TEXT_TEXT_TEXT,(value P0,value P1,value *P2));
_PROTOTYPE(extern int E57_prefix_TEXT_INT_TEXT_TEXT,(value P0,value P1,value *P2,value *P3));
_PROTOTYPE(extern int E59_asciicode_TEXT_INT_INT,(value P0,value P1,value *P2));
_PROTOTYPE(extern int E60_bindec_INT_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int E61_decbin_TEXT_INT,(value P0,value *P1));
_PROTOTYPE(extern int E70_hash_TEXT_INT_INT,(value P0,value P1,value *P2));
_PROTOTYPE(extern int E80_command_arg_INT_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int E81_exit_INT,(value P0));
_PROTOTYPE(extern int E82_get_from_environment_TEXT_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int E83_time_INT,(value *P0));
_PROTOTYPE(extern int E85_file_date_TEXT_INT,(value P0,value *P1));
_PROTOTYPE(extern int E84_execute_TEXT,(value P0));
_PROTOTYPE(extern int E200_get_key_TEXT,(value *P0));
_PROTOTYPE(extern int Mscanner_P_syntax_error_MESSAGE,(value P0));
_PROTOTYPE(extern int Mscanner_P_current_line_LINENR,(value *P0));
_PROTOTYPE(extern int Mscanner_P_open_TEXT,(value P0));
_PROTOTYPE(extern int Mscanner_P_close,());
_PROTOTYPE(extern int Mscanner_P_end_of_file,());
_PROTOTYPE(extern int Mscanner_P_is_symbol_TEXT,(value P0));
_PROTOTYPE(extern int Mscanner_P_ahead_symbol_TEXT,(value P0));
_PROTOTYPE(extern int Mscanner_P_should_be_symbol_TEXT,(value P0));
_PROTOTYPE(extern int Mscanner_P_is_TYPENAME,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_TYPENAME_INSTANCE,(value *P0,value *P1));
_PROTOTYPE(extern int Mscanner_P_is_placeholder_TYPENAME,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_TERMINAL,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_MODULE,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_SIZE,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_EXTNR,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_NUMBER,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_STRING,(value *P0));
_PROTOTYPE(extern int Mrules_P_propagate_rules,());
_PROTOTYPE(extern int Mrules_P_convert_MODULENR_RULENAME_ARITY_RULEID,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mrules_P_add_syntax_rule_RULEID_RULETYPE_PARAMETERS_NODENR_RULENR,(value P0,value P1,value P2,value *P3,value *P4));
_PROTOTYPE(extern int Mrules_P_export_rule_RULEID_RULETYPE_PARAMETERS_RULENR,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mrules_P_add_external_rule_RULEID_RULETYPE_PARAMETERS_EXTNR_NODENR_RULENR,(value P0,value P1,value P2,value P3,value *P4,value *P5));
_PROTOTYPE(extern int Mrules_P_is_external_RULENR_EXTNR,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_in_interface_RULENR,(value P0));
_PROTOTYPE(extern int Mrules_P_is_fixed_RULENR_INT,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULEID_RULENRS,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULEID_RULENAME,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULEID_MODULENR,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULENR_MODULENR_RULETYPE_RULENAME_ARITY_PARAMETERS_NODENR,(value P0,value *P1,value *P2,value *P3,value *P4,value *P5,value *P6));
_PROTOTYPE(extern int Mrules_P_get_RULENR_FRAMESIZE_FRAMESIZE,(value P0,value *P1,value *P2));
_PROTOTYPE(extern int Mrules_P_get_RULENR_RULETYPE,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULENR_RULENAME,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULENR_MODULENR,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULENR_PARAMETERS,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULENR_MODULENR_ID,(value P0,value *P1,value *P2));
_PROTOTYPE(extern int Mrules_P_set_RULENR_FRAMESIZE_FRAMESIZE,(value P0,value P1,value P2));
_PROTOTYPE(extern int Mrules_P_get_preludes_RULENRS,(value *P0));
_PROTOTYPE(extern int Mrules_P_get_postludes_RULENRS,(value *P0));
_PROTOTYPE(extern int Mrules_P_get_interludes_RULENRS,(value *P0));
_PROTOTYPE(extern int Mrules_P_first_rule_RULENR,(value *P0));
_PROTOTYPE(extern int Mrules_P_next_rule_RULENR,(value *P0));
_PROTOTYPE(extern int Mrules_P_first_rulename_RULEID,(value *P0));
_PROTOTYPE(extern int Mrules_P_next_rulename_RULEID,(value *P0));
_PROTOTYPE(extern int Mrules_P_error_RULENR,(value P0));
_PROTOTYPE(extern int Mrules_P_error_RULENAME,(value P0));
_PROTOTYPE(extern int Mrules_P_build_rule_RULENR_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_build_rule_RULENAME_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_definition_errors,());
_PROTOTYPE(extern int Mrules_P_set_root_error_handler_HANDLER,(value P0));
_PROTOTYPE(extern int Mrules_P_get_root_error_handler_HANDLER,(value *P0));
_PROTOTYPE(extern int Mrules_P_set_root_rule_ROOT,(value P0));
_PROTOTYPE(extern int Mrules_P_get_root_rule_ROOT,(value *P0));
_PROTOTYPE(extern int Mmodules_P_init_modules,());
_PROTOTYPE(extern int Mmodules_P_is_root_module_MODULENR,(value P0));
_PROTOTYPE(extern int Mmodules_P_set_root_module_MODULENR,(value P0));
_PROTOTYPE(extern int Mmodules_P_new_id_MODULENR_ID,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_order_MODULENR_MODULEORDER,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_convert_MODULE_MODULENR,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_add_import_for_module_MODULENR_MODULENR,(value P0,value P1));
_PROTOTYPE(extern int Mmodules_P_store_versionid_MODULENR_VERSIONTEXT,(value P0,value P1));
_PROTOTYPE(extern int Mmodules_P_module_exports_rule_MODULENR_RULENR,(value P0,value P1));
_PROTOTYPE(extern int Mmodules_P_get_exported_rules_from_module_MODULENR_RULENRS,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_get_MODULENR_MODULE,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_get_module_name_MODULENR_MODULENAME,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_get_MODULENR_VERSIONTEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_get_MODULENR_EXPORTS,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_get_MODULENR_IMPORTS,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_first_MODULENR,(value *P0));
_PROTOTYPE(extern int Mmodules_P_next_MODULENR,(value *P0));
_PROTOTYPE(extern int Mmodules_P_error_MODULENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_propagate_types,());
_PROTOTYPE(extern int Mtypes_P_convert_MODULENR_TYPENAME_TYPENR,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mtypes_P_add_abstract_type_MODULENR_TYPENAME_TYPE_TYPENR,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mtypes_P_add_external_type_MODULENR_TYPENAME_TYPENR,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mtypes_P_add_type_MODULENR_TYPENAME_TYPE_TYPENR,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mtypes_P_add_synonym_MODULENR_TYPENAME_TYPENR_TYPENR,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mtypes_P_export_type_MODULENR_TYPENAME_TYPENR,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mtypes_P_is_imported_abstract_type_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_is_abstract_type_TYPENR_TYPE,(value P0,value *P1));
_PROTOTYPE(extern int Mtypes_P_is_special_type_TYPENR_STYPE,(value P0,value *P1));
_PROTOTYPE(extern int Mtypes_P_is_external_type_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_is_integer_type_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_is_undefined_type_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_is_exported_type_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_same_TYPE_TYPENR,(value P0,value *P1));
_PROTOTYPE(extern int Mtypes_P_same_TYPENR_TYPENR,(value P0,value *P1));
_PROTOTYPE(extern int Mtypes_P_integer_type_TYPENR,(value *P0));
_PROTOTYPE(extern int Mtypes_P_is_text_type_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_text_type_TYPENR,(value *P0));
_PROTOTYPE(extern int Mtypes_P_equal_types_TYPENR_TYPENR,(value P0,value P1));
_PROTOTYPE(extern int Mtypes_P_get_TYPENR_TYPE,(value P0,value *P1));
_PROTOTYPE(extern int Mtypes_P_get_TYPENR_TYPENAME_MODULENR,(value P0,value *P1,value *P2));
_PROTOTYPE(extern int Mtypes_P_get_TYPENR_MODULENR_ID,(value P0,value *P1,value *P2));
_PROTOTYPE(extern int Mtypes_P_first_TYPENR,(value *P0));
_PROTOTYPE(extern int Mtypes_P_next_TYPENR,(value *P0));
_PROTOTYPE(extern int Mtypes_P_error_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_build_type_TYPENR_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mtypes_P_type_errors,());
_PROTOTYPE(extern int Mcode_P_start_coding,());
_PROTOTYPE(extern int Mcode_P_new_LABEL,(value *P0));
_PROTOTYPE(extern int Mcode_P_error_OPERATOR,(value P0));
_PROTOTYPE(extern int Mcode_P_error_MONADIC_OPERATOR,(value P0));
_PROTOTYPE(extern int Mcode_P_store_INSTRUCTION,(value P0));
_PROTOTYPE(extern int Mcode_P_append_LOCATION_INSTRUCTION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_overwrite_LOCATION_INSTRUCTION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_prepend_LOCATION_INSTRUCTION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_prepend_INSTRUCTION,(value P0));
_PROTOTYPE(extern int Mcode_P_delete_LOCATION,(value P0));
_PROTOTYPE(extern int Mcode_P_delete_LOCATION_LOCATION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_move_LOCATION_LOCATION_LOCATION,(value P0,value P1,value P2));
_PROTOTYPE(extern int Mcode_P_current_LOCATION,(value *P0));
_PROTOTYPE(extern int Mcode_P_set_LOCATION,(value P0));
_PROTOTYPE(extern int Mcode_P_get_LOCATION_INSTRUCTION,(value P0,value *P1));
_PROTOTYPE(extern int Mcode_P_next_LOCATION_LOCATION,(value P0,value *P1));
_PROTOTYPE(extern int Mcode_P_prev_LOCATION_LOCATION,(value P0,value *P1));
_PROTOTYPE(extern int Mcode_P_is_end_LOCATION,(value P0));
_PROTOTYPE(extern int Mcode_P_first_LOCATION,(value *P0));
_PROTOTYPE(extern int Mcode_P_prev_LOCATION,(value *P0));
_PROTOTYPE(extern int Mcode_P_next_LOCATION,(value *P0));
_PROTOTYPE(extern int Mcode_P_is_associative_OPERATOR,(value P0));
_PROTOTYPE(extern int Mcode_P_register_label_LABEL_LOCATION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_register_label_LABEL,(value P0));
_PROTOTYPE(extern int Mcode_P_register_goto_LABEL_LOCATION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_register_goto_LABELS_LOCATION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_register_goto_LABEL,(value P0));
_PROTOTYPE(extern int Mcode_P_register_goto_LABELS,(value P0));
_PROTOTYPE(extern int Mcode_P_remove_goto_LABEL_LOCATION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_remove_goto_LABELS_LOCATION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_alias_LABEL_LABEL,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_absorb_goto_LABEL_INSTRUCTION_INT_INT,(value P0,value P1,value *P2,value *P3));
_PROTOTYPE(extern int Mcode_P_called_once_LABEL,(value P0));
_PROTOTYPE(extern int Mcode_P_get_label_LABEL_LOCATION,(value P0,value *P1));
_PROTOTYPE(extern int Mcode_P_no_effect_INSTRUCTION,(value P0));
_PROTOTYPE(extern int Mcode_P_write_ADDRESS,(value P0));
_PROTOTYPE(extern int Mcode_P_get_ADDRESS_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mcode_P_get_ADDRESSES_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mcode_P_dump_code_MODULENR_TEXT,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_dump_instruction_INSTRUCTION,(value P0));
_PROTOTYPE(extern int Mcode_P_dump_code_TEXT_LOCATION_LOCATION,(value P0,value P1,value P2));
_PROTOTYPE(extern int Mcode_P_make_dump_TEXT,(value P0));
_PROTOTYPE(extern int Mcode_P_request_dump_TEXT,(value P0));
_PROTOTYPE(extern int Merrors_P_status_message_TEXT,(value P0));
_PROTOTYPE(extern int Merrors_P_status_message_MODULENR,(value P0));
_PROTOTYPE(extern int Merrors_P_debug_MESSAGE,(value P0));
_PROTOTYPE(extern int Merrors_P_debug_text_TEXT,(value P0));
_PROTOTYPE(extern int Merrors_P_debug_int_INT,(value P0));
_PROTOTYPE(extern int Merrors_P_error_MESSAGE,(value P0));
_PROTOTYPE(extern int Merrors_P_error_text_TEXT,(value P0));
_PROTOTYPE(extern int Merrors_P_error_int_INT,(value P0));
_PROTOTYPE(extern int Mterminals_P_convert_TERMINAL_TERMINALNR,(value P0,value *P1));
_PROTOTYPE(extern int Mterminals_P_get_TERMINALNR_TERMINAL,(value P0,value *P1));
_PROTOTYPE(extern int Mterminals_P_error_terminal_TERMINALNR,(value P0));
_PROTOTYPE(extern int Mfiles_P_paths_PATHS,(value *P0));
_PROTOTYPE(extern int Mfiles_P_init_files,());
_PROTOTYPE(extern int Mfiles_P_strip_path_TEXT_TEXT_TEXT,(value P0,value *P1,value *P2));
_PROTOTYPE(extern int Mfiles_P_set_lib_path_TEXT,(value P0));
_PROTOTYPE(extern int Mfiles_P_date_TEXT_INT,(value P0,value *P1));
_PROTOTYPE(extern int Mfiles_P_open_TEXT_FILE,(value P0,value *P1));
_PROTOTYPE(extern int Minline_P_declare_rule_RULENR,(value P0));
_PROTOTYPE(extern int Minline_P_register_call_RULENR_NODENR,(value P0,value P1));
_PROTOTYPE(extern int Minline_P_inline_TEXT,(value P0));
_PROTOTYPE(extern int Minline_P_inline_MODULENR,(value P0));
_PROTOTYPE(extern int Minline_P_disable_inlining,());
_PROTOTYPE(extern int Minline_P_ignore_unreachable_code,());
_PROTOTYPE(extern int Minline_P_rule_changes_global_RULENR_VARIABLENR,(value P0,value P1));
_PROTOTYPE(extern int Minline_P_call_changes_global_RULENR_VARIABLENR,(value P0,value P1));
_PROTOTYPE(extern int Minline_P_resolve_call_graph_MODULENR,(value P0));
_PROTOTYPE(extern int Minline_P_is_recursive_RULENR,(value P0));
_PROTOTYPE(extern int Minline_P_rule_is_reachable_RULENR,(value P0));
_PROTOTYPE(extern int Mnodes_P_new_NODENR,(value *P0));
_PROTOTYPE(extern int Mnodes_P_store_NODENR_LINENR_NODE,(value P0,value P1,value P2));
_PROTOTYPE(extern int Mnodes_P_get_NODENR_LINENR_NODE,(value P0,value *P1,value *P2));
_PROTOTYPE(extern int Mnodes_P_append_succeed_NODENR_NODENR,(value P0,value *P1));
_PROTOTYPE(extern int Mnodes_P_append_fail_NODENR_NODENR,(value P0,value *P1));
_PROTOTYPE(extern int Mnodes_P_succeed_NODENR_NODENR,(value P0,value *P1));
_PROTOTYPE(extern int Mnodes_P_fail_NODENR_NODENR,(value P0,value *P1));
_PROTOTYPE(extern int Mnodes_P_pass_two_NODENR_NODENR,(value P0,value *P1));
_PROTOTYPE(extern int Mnodes_P_error_SUBEXPRESSION,(value P0));
_PROTOTYPE(extern int Mnodes_P_error_EXPRESSION,(value P0));
_PROTOTYPE(extern int Mcoder_P_no_code,());
_PROTOTYPE(extern int Mcoder_P_no_gc,());
_PROTOTYPE(extern int Mcoder_P_trace_on,());
_PROTOTYPE(extern int Mcoder_P_produce_statistics,());
_PROTOTYPE(extern int Mcoder_P_profile_on,());
_PROTOTYPE(extern int Mcoder_P_just_compile_and_no_object,());
_PROTOTYPE(extern int Mcoder_P_extension_TEXT,(value *P0));
_PROTOTYPE(extern int Mcoder_P_external_names_do_not_start_with_underscore,());
_PROTOTYPE(extern int Mcoder_P_optimize_array_references,());
_PROTOTYPE(extern int Mcoder_P_code_MODULENR,(value P0));
_PROTOTYPE(extern int Manalyzer_P_semantic_errors,());
_PROTOTYPE(extern int Manalyzer_P_analyse_main_MODULENR_ROOT,(value P0,value P1));
_PROTOTYPE(extern int Manalyzer_P_analyse_rules_MODULENR,(value P0));
_PROTOTYPE(extern int Manalyzer_P_resolve_call_ahead_NODENR_RULENR,(value P0,value *P1));
_PROTOTYPE(extern int Manalyzer_P_warnings_on,());
_PROTOTYPE(extern int Mbitmap_P_new_BITMAP,(value *P0));
_PROTOTYPE(extern int Mbitmap_P_new_INT_BITMAP,(value P0,value *P1));
_PROTOTYPE(extern int Mbitmap_P_new_INT_INT_BITMAP,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mbitmap_P_exclude_BITMAP_BITMAP_BITMAP,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mbitmap_P_or_BITMAP_BITMAP_BITMAP,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mbitmap_P_and_BITMAP_BITMAP_BITMAP,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mbitmap_P_equal_BITMAP_BITMAP,(value P0,value P1));
_PROTOTYPE(extern int Mbitmap_P_is_set_BITMAP_INT,(value P0,value P1));
_PROTOTYPE(extern int Mbitmap_P_is_empty_BITMAP,(value P0));
_PROTOTYPE(extern int Mbitmap_P_clear_bit_BITMAP_INT_BITMAP,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mbitmap_P_set_bit_BITMAP_INT_BITMAP,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mbitmap_P_write_BITMAP,(value P0));
_PROTOTYPE(extern int Mrecursion_P_remove_right_recursion,());
_PROTOTYPE(extern int Mrecursion_P_remove_right_recursion_RULENR_LOCATION,(value P0,value P1));

/*
** CODE
*/

int Mvariables_P_convert_PASS_MODULENR_RULENR_TYPENR_INSTANCE_VARIABLENR(P0,P1,P2,P3,P4,P5)
value P0;
value P1;
value P2;
value P3;
value P4;
value *P5;
{
  value L62;
  value L61;
  value L60;
  value L59;
  value L58;
  value L57;
  value L56;
  value L55;
  value L54;
  value L53;
  value L52;
  value L51;
  value L50;
  value L49;
  value L48;
  value L47;
  value L46;
  value L45;
  value L44;
  value L43;
  value L42;
  value L41;
  value L40;
  value L39;
  value L38;
  value L37;
  value L36;
  value L35;
  value L34;
  value L33;
  value L32;
  value L31;
  value L30;
  value L29;
  value L28;
  value L27;
  value L26;
  value L25;
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = P2;
  L3 = P3;
  L4 = P4;
  L29 = L1;
  L30 = L3;
  L31 = C_INT(Int(L30) * Int(L29));
  L32 = C_INT(1024);
  L33 = C_INT(Int(L31) % Int(L32));
  L5 = L33;
LAB105:
  L6 = (value) Addr((value*)&G_variables_HASHEDNAMES_NR0,Int(L5));
  L7 = *((value*)L6);
  ATTACH(L7);
  L34 = L1;
  L35 = L2;
  L36 = L3;
  L37 = L4;
  L38 = L7;
LAB108:
  switch (Alternative(L38)) {
  case 0: goto LAB109;
  default: goto LAB0;
  };
LAB109:
  L39 = (value)(L38[1]);
  L40 = (value)(L38[2]);
  L41 = (value) Addr((value*)&G_variables_NAMES_NR1,Int(L39));
  L42 = *((value*)L41);
  switch (Alternative(L42)) {
  case 3: goto LAB111;
  default: goto LAB117;
  };
LAB111:
  L43 = (value)(L42[1]);
  L44 = (value)(L42[2]);
  L45 = (value)(L42[3]);
  L46 = (value)(L42[4]);
  L47 = (value)(L42[5]);
  if (!(L34 == L43)) goto LAB118;
  if (!(L36 == L44)) goto LAB118;
  if (!EQ_Mvariables_T8(L37,L45)) goto LAB118;
  L8 = L39;
  goto LAB107;
LAB118:
  L38 = L40;
  goto LAB108;
LAB117:
  L49 = (value) Addr((value*)&G_variables_NAMES_NR1,Int(L39));
  L50 = *((value*)L49);
  switch (Alternative(L50)) {
  case 0: goto LAB123;
  default: goto LAB129;
  };
LAB123:
  L51 = (value)(L50[1]);
  L52 = (value)(L50[2]);
  L53 = (value)(L50[3]);
  L54 = (value)(L50[4]);
  if (!(L34 == L51)) goto LAB130;
  if (!(L35 == L52)) goto LAB130;
  if (!(L36 == L53)) goto LAB130;
  if (!EQ_Mvariables_T8(L37,L54)) goto LAB130;
  L8 = L39;
  goto LAB107;
LAB130:
  L38 = L40;
  goto LAB108;
LAB129:
  L56 = (value) Addr((value*)&G_variables_NAMES_NR1,Int(L39));
  L57 = *((value*)L56);
  switch (Alternative(L57)) {
  case 1: goto LAB136;
  default: goto LAB142;
  };
LAB136:
  L58 = (value)(L57[1]);
  L59 = (value)(L57[2]);
  L60 = (value)(L57[3]);
  L61 = (value)(L57[4]);
  if (!(L34 == L58)) goto LAB143;
  if (!(L35 == L59)) goto LAB143;
  if (!(L36 == L60)) goto LAB143;
  if (!EQ_Mvariables_T8(L37,L61)) goto LAB143;
  L8 = L39;
LAB107:
if(DecrRefs(L7)<0)
XD_Mvariables_T34(L7);
  switch (Alternative(L0)) {
  case 1: goto LAB2;
  default: goto LAB4;
  };
LAB143:
  L38 = L40;
  goto LAB108;
LAB142:
  Abort(85, module_name);
LAB2:
  L9 = (value) Addr((value*)&G_variables_NAMES_NR1,Int(L8));
  L10 = *((value*)L9);
  ATTACH(L10);
  switch (Alternative(L10)) {
  case 0: goto LAB5;
  default: goto LAB6;
  };
LAB5:
  L11 = (value)(L10[1]);
  L12 = (value)(L10[2]);
  L13 = (value)(L10[3]);
  L14 = (value)(L10[4]);
if(DecrRefs(L10)<0)
XD_Mvariables_T2(L10);
  Create(&L15,1,4);
  *(value *)(L15+1) = L1;
  *(value *)(L15+2) = L2;
  *(value *)(L15+3) = L3;
  *(value *)(L15+4) = L4;
  ATTACH(L4);
if(DecrRefs(*((value*)L9))<0)
XD_Mvariables_T2(*((value*)L9));
  *((value *)L9) = L15;
  *P5 = L8;
  return 1;
LAB0:
if(DecrRefs(L7)<0)
XD_Mvariables_T34(L7);
LAB1:
  L16 = (value)G_variables_NR_OF_NAMES_NR3;
  L17 = (value)G_variables_NR_OF_NAMES_NR3;
  L18 = C_INT(1);
  L19 = C_INT(Int(L17) + Int(L18));
  G_variables_NR_OF_NAMES_NR3 = (long)L19;
  L20 = C_INT(-1);
  L21 = (value) Addr((value*)&G_variables_V_OFFSET_NR2,Int(L16));
  *((value *)L21) = L20;
  Create(&L22,0,2);
  *(value *)(L22+1) = L16;
  L23 = (value) Addr((value*)&G_variables_HASHEDNAMES_NR0,Int(L5));
  L24 = *((value*)L23);
  ATTACH(L24);
  *(value *)(L22+2) = L24;
if(DecrRefs(*((value*)L23))<0)
XD_Mvariables_T34(*((value*)L23));
  *((value *)L23) = L22;
  switch (Alternative(L0)) {
  case 0: goto LAB8;
  case 1: goto LAB11;
  default: goto LAB13;
  };
LAB6:
if(DecrRefs(L10)<0)
XD_Mvariables_T2(L10);
LAB4:
  *P5 = L8;
  return 1;
LAB8:
  Create(&L25,0,4);
  *(value *)(L25+1) = L1;
  *(value *)(L25+2) = L2;
  *(value *)(L25+3) = L3;
  *(value *)(L25+4) = L4;
  ATTACH(L4);
  L26 = (value) Addr((value*)&G_variables_NAMES_NR1,Int(L16));
if(DecrRefs(*((value*)L26))<0)
XD_Mvariables_T2(*((value*)L26));
  *((value *)L26) = L25;
  *P5 = L16;
  return 1;
LAB11:
  Create(&L27,1,4);
  *(value *)(L27+1) = L1;
  *(value *)(L27+2) = L2;
  *(value *)(L27+3) = L3;
  *(value *)(L27+4) = L4;
  ATTACH(L4);
  L28 = (value) Addr((value*)&G_variables_NAMES_NR1,Int(L16));
if(DecrRefs(*((value*)L28))<0)
XD_Mvariables_T2(*((value*)L28));
  *((value *)L28) = L27;
  *P5 = L16;
  return 1;
LAB13:
  Abort(105, module_name);
}

int Mvariables_P_store_global_MODULENR_TYPENR_INSTANCE_SIZE(P0,P1,P2,P3)
value P0;
value P1;
value P2;
value P3;
{
  value L66;
  value L65;
  value L64;
  value L63;
  value L62;
  value L61;
  value L60;
  value L59;
  value L58;
  value L57;
  value L56;
  value L55;
  value L54;
  value L53;
  value L52;
  value L51;
  value L50;
  value L49;
  value L48;
  value L47;
  value L46;
  value L45;
  value L44;
  value L43;
  value L42;
  value L41;
  value L40;
  value L39;
  value L38;
  value L37;
  value L36;
  value L35;
  value L34;
  value L33;
  value L32;
  value L31;
  value L30;
  value L29;
  value L28;
  value L27;
  value L26;
  value L25;
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = P2;
  L3 = P3;
  L33 = L0;
  L34 = L1;
  L35 = C_INT(Int(L34) * Int(L33));
  L36 = C_INT(1024);
  L37 = C_INT(Int(L35) % Int(L36));
  L4 = L37;
LAB149:
  L5 = (value)G_variables_NORULE_NR4;
  L6 = (value) Addr((value*)&G_variables_HASHEDNAMES_NR0,Int(L4));
  L7 = *((value*)L6);
  ATTACH(L7);
  L38 = L0;
  L39 = L5;
  L40 = L1;
  L41 = L2;
  L42 = L7;
LAB151:
  switch (Alternative(L42)) {
  case 0: goto LAB152;
  default: goto LAB14;
  };
LAB152:
  L43 = (value)(L42[1]);
  L44 = (value)(L42[2]);
  L45 = (value) Addr((value*)&G_variables_NAMES_NR1,Int(L43));
  L46 = *((value*)L45);
  switch (Alternative(L46)) {
  case 3: goto LAB154;
  default: goto LAB160;
  };
LAB154:
  L47 = (value)(L46[1]);
  L48 = (value)(L46[2]);
  L49 = (value)(L46[3]);
  L50 = (value)(L46[4]);
  L51 = (value)(L46[5]);
  if (!(L38 == L47)) goto LAB161;
  if (!(L40 == L48)) goto LAB161;
  if (!EQ_Mvariables_T8(L41,L49)) goto LAB161;
  L8 = L43;
  goto LAB150;
LAB161:
  L42 = L44;
  goto LAB151;
LAB160:
  L53 = (value) Addr((value*)&G_variables_NAMES_NR1,Int(L43));
  L54 = *((value*)L53);
  switch (Alternative(L54)) {
  case 0: goto LAB166;
  default: goto LAB172;
  };
LAB166:
  L55 = (value)(L54[1]);
  L56 = (value)(L54[2]);
  L57 = (value)(L54[3]);
  L58 = (value)(L54[4]);
  if (!(L38 == L55)) goto LAB173;
  if (!(L39 == L56)) goto LAB173;
  if (!(L40 == L57)) goto LAB173;
  if (!EQ_Mvariables_T8(L41,L58)) goto LAB173;
  L8 = L43;
  goto LAB150;
LAB173:
  L42 = L44;
  goto LAB151;
LAB172:
  L60 = (value) Addr((value*)&G_variables_NAMES_NR1,Int(L43));
  L61 = *((value*)L60);
  switch (Alternative(L61)) {
  case 1: goto LAB179;
  default: goto LAB185;
  };
LAB179:
  L62 = (value)(L61[1]);
  L63 = (value)(L61[2]);
  L64 = (value)(L61[3]);
  L65 = (value)(L61[4]);
  if (!(L38 == L62)) goto LAB186;
  if (!(L39 == L63)) goto LAB186;
  if (!(L40 == L64)) goto LAB186;
  if (!EQ_Mvariables_T8(L41,L65)) goto LAB186;
  L8 = L43;
LAB150:
if(DecrRefs(L7)<0)
XD_Mvariables_T34(L7);
  Create(&L9,6,2);
  L10 = G_variables_TEXT_NR2896;
  *(value *)(L9+1) = L10;
  ATTACH(L10);
  Create(&L11,2,2);
  *(value *)(L11+1) = L1;
  Create(&L12,3,2);
  *(value *)(L12+1) = L2;
  ATTACH(L2);
  Create(&L13,6,2);
  L14 = G_variables_TEXT_NR2897;
  *(value *)(L13+1) = L14;
  ATTACH(L14);
  Create(&L15,4,2);
  *(value *)(L15+1) = L0;
  Create(&L16,11,1);
  L17 = G_variables_TEXT_NR2898;
  *(value *)(L16+1) = L17;
  ATTACH(L17);
  *(value *)(L15+2) = L16;
  *(value *)(L13+2) = L15;
  *(value *)(L12+2) = L13;
  *(value *)(L11+2) = L12;
  *(value *)(L9+2) = L11;
  Merrors_P_error_MESSAGE(L9);
if(DecrRefs(L9)<0)
XD_Merrors_T3(L9);
  return 1;
LAB186:
  L42 = L44;
  goto LAB151;
LAB185:
  Abort(85, module_name);
LAB14:
if(DecrRefs(L7)<0)
XD_Mvariables_T34(L7);
LAB15:
  L18 = (value)G_variables_NR_OF_NAMES_NR3;
  L19 = (value)G_variables_NR_OF_NAMES_NR3;
  L20 = C_INT(1);
  L21 = C_INT(Int(L19) + Int(L20));
  G_variables_NR_OF_NAMES_NR3 = (long)L21;
  Create(&L22,0,2);
  *(value *)(L22+1) = L18;
  L23 = (value) Addr((value*)&G_variables_HASHEDNAMES_NR0,Int(L4));
  L24 = *((value*)L23);
  ATTACH(L24);
  *(value *)(L22+2) = L24;
if(DecrRefs(*((value*)L23))<0)
XD_Mvariables_T34(*((value*)L23));
  *((value *)L23) = L22;
  L25 = C_INT(-1);
  L26 = (value) Addr((value*)&G_variables_V_OFFSET_NR2,Int(L18));
  *((value *)L26) = L25;
  L27 = (value)G_variables_NR_GLOBALS_NR5;
  L28 = (value)G_variables_NR_GLOBALS_NR5;
  L29 = C_INT(1);
  L30 = C_INT(Int(L28) + Int(L29));
  Create(&L31,3,5);
  *(value *)(L31+1) = L0;
  *(value *)(L31+2) = L1;
  *(value *)(L31+3) = L2;
  ATTACH(L2);
  *(value *)(L31+4) = L3;
  ATTACH(L3);
  *(value *)(L31+5) = L30;
  L32 = (value) Addr((value*)&G_variables_NAMES_NR1,Int(L18));
if(DecrRefs(*((value*)L32))<0)
XD_Mvariables_T2(*((value*)L32));
  *((value *)L32) = L31;
  return 1;
}

int Mvariables_P_parameter_MODULENR_RULENR_TYPENR_INSTANCE_VARIABLENR(P0,P1,P2,P3,P4)
value P0;
value P1;
value P2;
value P3;
value *P4;
{
  value L97;
  value L96;
  value L95;
  value L94;
  value L93;
  value L92;
  value L91;
  value L90;
  value L89;
  value L88;
  value L87;
  value L86;
  value L85;
  value L84;
  value L83;
  value L82;
  value L81;
  value L80;
  value L79;
  value L78;
  value L77;
  value L76;
  value L75;
  value L74;
  value L73;
  value L72;
  value L71;
  value L70;
  value L69;
  value L68;
  value L67;
  value L66;
  value L65;
  value L64;
  value L63;
  value L62;
  value L61;
  value L60;
  value L59;
  value L58;
  value L57;
  value L56;
  value L55;
  value L54;
  value L53;
  value L52;
  value L51;
  value L50;
  value L49;
  value L48;
  value L47;
  value L46;
  value L45;
  value L44;
  value L43;
  value L42;
  value L41;
  value L40;
  value L39;
  value L38;
  value L37;
  value L36;
  value L35;
  value L34;
  value L33;
  value L32;
  value L31;
  value L30;
  value L29;
  value L28;
  value L27;
  value L26;
  value L25;
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = P2;
  L3 = P3;
  L35 = L0;
  L36 = L2;
  L37 = C_INT(Int(L36) * Int(L35));
  L38 = C_INT(1024);
  L39 = C_INT(Int(L37) % Int(L38));
  L4 = L39;
LAB192:
  L5 = (value)G_variables_NORULE_NR4;
  L6 = (value) Addr((value*)&G_variables_HASHEDNAMES_NR0,Int(L4));
  L7 = *((value*)L6);
  ATTACH(L7);
  L40 = L0;
  L41 = L5;
  L42 = L2;
  L43 = L3;
  L44 = L7;
LAB194:
  switch (Alternative(L44)) {
  case 0: goto LAB195;
  default: goto LAB16;
  };
LAB195:
  L45 = (value)(L44[1]);
  L46 = (value)(L44[2]);
  L47 = (value) Addr((value*)&G_variables_NAMES_NR1,Int(L45));
  L48 = *((value*)L47);
  switch (Alternative(L48)) {
  case 3: goto LAB197;
  default: goto LAB203;
  };
LAB197:
  L49 = (value)(L48[1]);
  L50 = (value)(L48[2]);
  L51 = (value)(L48[3]);
  L52 = (value)(L48[4]);
  L53 = (value)(L48[5]);
  if (!(L40 == L49)) goto LAB204;
  if (!(L42 == L50)) goto LAB204;
  if (!EQ_Mvariables_T8(L43,L51)) goto LAB204;
  L8 = L45;
  goto LAB193;
LAB204:
  L44 = L46;
  goto LAB194;
LAB203:
  L55 = (value) Addr((value*)&G_variables_NAMES_NR1,Int(L45));
  L56 = *((value*)L55);
  switch (Alternative(L56)) {
  case 0: goto LAB209;
  default: goto LAB215;
  };
LAB209:
  L57 = (value)(L56[1]);
  L58 = (value)(L56[2]);
  L59 = (value)(L56[3]);
  L60 = (value)(L56[4]);
  if (!(L40 == L57)) goto LAB216;
  if (!(L41 == L58)) goto LAB216;
  if (!(L42 == L59)) goto LAB216;
  if (!EQ_Mvariables_T8(L43,L60)) goto LAB216;
  L8 = L45;
  goto LAB193;
LAB216:
  L44 = L46;
  goto LAB194;
LAB215:
  L62 = (value) Addr((value*)&G_variables_NAMES_NR1,Int(L45));
  L63 = *((value*)L62);
  switch (Alternative(L63)) {
  case 1: goto LAB222;
  default: goto LAB228;
  };
LAB222:
  L64 = (value)(L63[1]);
  L65 = (value)(L63[2]);
  L66 = (value)(L63[3]);
  L67 = (value)(L63[4]);
  if (!(L40 == L64)) goto LAB229;
  if (!(L41 == L65)) goto LAB229;
  if (!(L42 == L66)) goto LAB229;
  if (!EQ_Mvariables_T8(L43,L67)) goto LAB229;
  L8 = L45;
LAB193:
if(DecrRefs(L7)<0)
XD_Mvariables_T34(L7);
  Create(&L9,6,2);
  L10 = G_variables_TEXT_NR2899;
  *(value *)(L9+1) = L10;
  ATTACH(L10);
  Create(&L11,2,2);
  *(value *)(L11+1) = L2;
  Create(&L12,3,2);
  *(value *)(L12+1) = L3;
  ATTACH(L3);
  Create(&L13,6,2);
  L14 = G_variables_TEXT_NR2900;
  *(value *)(L13+1) = L14;
  ATTACH(L14);
  Create(&L15,0,2);
  *(value *)(L15+1) = L1;
  Create(&L16,6,2);
  L17 = G_variables_TEXT_NR2901;
  *(value *)(L16+1) = L17;
  ATTACH(L17);
  Create(&L18,4,2);
  *(value *)(L18+1) = L0;
  Create(&L19,11,1);
  L20 = G_variables_TEXT_NR2902;
  *(value *)(L19+1) = L20;
  ATTACH(L20);
  *(value *)(L18+2) = L19;
  *(value *)(L16+2) = L18;
  *(value *)(L15+2) = L16;
  *(value *)(L13+2) = L15;
  *(value *)(L12+2) = L13;
  *(value *)(L11+2) = L12;
  *(value *)(L9+2) = L11;
  Merrors_P_error_MESSAGE(L9);
if(DecrRefs(L9)<0)
XD_Merrors_T3(L9);
  *P4 = L8;
  return 1;
LAB229:
  L44 = L46;
  goto LAB194;
LAB228:
  Abort(85, module_name);
LAB16:
if(DecrRefs(L7)<0)
XD_Mvariables_T34(L7);
LAB17:
  L21 = (value) Addr((value*)&G_variables_HASHEDNAMES_NR0,Int(L4));
  L22 = *((value*)L21);
  ATTACH(L22);
  L69 = L0;
  L70 = L1;
  L71 = L2;
  L72 = L3;
  L73 = L22;
LAB236:
  switch (Alternative(L73)) {
  case 0: goto LAB237;
  default: goto LAB18;
  };
LAB237:
  L74 = (value)(L73[1]);
  L75 = (value)(L73[2]);
  L76 = (value) Addr((value*)&G_variables_NAMES_NR1,Int(L74));
  L77 = *((value*)L76);
  switch (Alternative(L77)) {
  case 3: goto LAB239;
  default: goto LAB245;
  };
LAB239:
  L78 = (value)(L77[1]);
  L79 = (value)(L77[2]);
  L80 = (value)(L77[3]);
  L81 = (value)(L77[4]);
  L82 = (value)(L77[5]);
  if (!(L69 == L78)) goto LAB246;
  if (!(L71 == L79)) goto LAB246;
  if (!EQ_Mvariables_T8(L72,L80)) goto LAB246;
  L23 = L74;
  goto LAB235;
LAB246:
  L73 = L75;
  goto LAB236;
LAB245:
  L84 = (value) Addr((value*)&G_variables_NAMES_NR1,Int(L74));
  L85 = *((value*)L84);
  switch (Alternative(L85)) {
  case 0: goto LAB251;
  default: goto LAB257;
  };
LAB251:
  L86 = (value)(L85[1]);
  L87 = (value)(L85[2]);
  L88 = (value)(L85[3]);
  L89 = (value)(L85[4]);
  if (!(L69 == L86)) goto LAB258;
  if (!(L70 == L87)) goto LAB258;
  if (!(L71 == L88)) goto LAB258;
  if (!EQ_Mvariables_T8(L72,L89)) goto LAB258;
  L23 = L74;
  goto LAB235;
LAB258:
  L73 = L75;
  goto LAB236;
LAB257:
  L91 = (value) Addr((value*)&G_variables_NAMES_NR1,Int(L74));
  L92 = *((value*)L91);
  switch (Alternative(L92)) {
  case 1: goto LAB264;
  default: goto LAB270;
  };
LAB264:
  L93 = (value)(L92[1]);
  L94 = (value)(L92[2]);
  L95 = (value)(L92[3]);
  L96 = (value)(L92[4]);
  if (!(L69 == L93)) goto LAB271;
  if (!(L70 == L94)) goto LAB271;
  if (!(L71 == L95)) goto LAB271;
  if (!EQ_Mvariables_T8(L72,L96)) goto LAB271;
  L23 = L74;
LAB235:
if(DecrRefs(L22)<0)
XD_Mvariables_T34(L22);
  *P4 = L23;
  return 1;
LAB271:
  L73 = L75;
  goto LAB236;
LAB270:
  Abort(85, module_name);
LAB18:
if(DecrRefs(L22)<0)
XD_Mvariables_T34(L22);
LAB19:
  L24 = (value)G_variables_NR_OF_NAMES_NR3;
  L25 = (value)G_variables_NR_OF_NAMES_NR3;
  L26 = C_INT(1);
  L27 = C_INT(Int(L25) + Int(L26));
  G_variables_NR_OF_NAMES_NR3 = (long)L27;
  Create(&L28,0,2);
  *(value *)(L28+1) = L24;
  L29 = (value) Addr((value*)&G_variables_HASHEDNAMES_NR0,Int(L4));
  L30 = *((value*)L29);
  ATTACH(L30);
  *(value *)(L28+2) = L30;
if(DecrRefs(*((value*)L29))<0)
XD_Mvariables_T34(*((value*)L29));
  *((value *)L29) = L28;
  L31 = C_INT(-1);
  L32 = (value) Addr((value*)&G_variables_V_OFFSET_NR2,Int(L24));
  *((value *)L32) = L31;
  Create(&L33,0,4);
  *(value *)(L33+1) = L0;
  *(value *)(L33+2) = L1;
  *(value *)(L33+3) = L2;
  *(value *)(L33+4) = L3;
  ATTACH(L3);
  L34 = (value) Addr((value*)&G_variables_NAMES_NR1,Int(L24));
if(DecrRefs(*((value*)L34))<0)
XD_Mvariables_T2(*((value*)L34));
  *((value *)L34) = L33;
  *P4 = L24;
  return 1;
}

int Mvariables_P_temporary_MODULENR_RULENR_TYPENR_VARIABLENR(P0,P1,P2,P3)
value P0;
value P1;
value P2;
value *P3;
{
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = P2;
  L3 = (value)G_variables_NR_OF_NAMES_NR3;
  L4 = (value)G_variables_NR_OF_NAMES_NR3;
  L5 = C_INT(1);
  L6 = C_INT(Int(L4) + Int(L5));
  G_variables_NR_OF_NAMES_NR3 = (long)L6;
  L7 = C_INT(-1);
  L8 = (value) Addr((value*)&G_variables_V_OFFSET_NR2,Int(L3));
  *((value *)L8) = L7;
  Create(&L9,0,4);
  *(value *)(L9+1) = L0;
  *(value *)(L9+2) = L1;
  *(value *)(L9+3) = L2;
  L10 = G_variables_INSTANCE_NR2903;
  *(value *)(L9+4) = L10;
  ATTACH(L10);
  L11 = (value) Addr((value*)&G_variables_NAMES_NR1,Int(L3));
if(DecrRefs(*((value*)L11))<0)
XD_Mvariables_T2(*((value*)L11));
  *((value *)L11) = L9;
  *P3 = L3;
  return 1;
}

int Mvariables_P_constant_MODULENR_TYPENR_VALUE_VARIABLENR(P0,P1,P2,P3)
value P0;
value P1;
value P2;
value *P3;
{
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = P2;
  L3 = (value)G_variables_NR_OF_NAMES_NR3;
  L4 = (value)G_variables_NR_OF_NAMES_NR3;
  L5 = C_INT(1);
  L6 = C_INT(Int(L4) + Int(L5));
  G_variables_NR_OF_NAMES_NR3 = (long)L6;
  L7 = C_INT(-1);
  L8 = (value) Addr((value*)&G_variables_V_OFFSET_NR2,Int(L3));
  *((value *)L8) = L7;
  Create(&L9,2,3);
  *(value *)(L9+1) = L0;
  *(value *)(L9+2) = L1;
  *(value *)(L9+3) = L2;
  ATTACH(L2);
  L10 = (value) Addr((value*)&G_variables_NAMES_NR1,Int(L3));
if(DecrRefs(*((value*)L10))<0)
XD_Mvariables_T2(*((value*)L10));
  *((value *)L10) = L9;
  *P3 = L3;
  return 1;
}

int Mvariables_P_get_VARIABLENR_MODULENR_TYPENR_INSTANCE_SIZE(P0,P1,P2,P3,P4)
value P0;
value *P1;
value *P2;
value *P3;
value *P4;
{
  value L28;
  value L27;
  value L26;
  value L25;
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = (value) Addr((value*)&G_variables_NAMES_NR1,Int(L0));
  L2 = *((value*)L1);
  switch (Alternative(L2)) {
  case 3: goto LAB20;
  default: goto LAB22;
  };
LAB20:
  L3 = (value)(L2[1]);
  L4 = (value)(L2[2]);
  L5 = (value)(L2[3]);
  L6 = (value)(L2[4]);
  L7 = (value)(L2[5]);
  *P4 = L6;
  ATTACH(L6);
  *P3 = L5;
  ATTACH(L5);
  *P2 = L4;
  *P1 = L3;
  return 1;
LAB22:
  L8 = (value) Addr((value*)&G_variables_NAMES_NR1,Int(L0));
  L9 = *((value*)L8);
  switch (Alternative(L9)) {
  case 2: goto LAB23;
  default: goto LAB25;
  };
LAB23:
  L10 = (value)(L9[1]);
  L11 = (value)(L9[2]);
  L12 = (value)(L9[3]);
  L13 = G_variables_INSTANCE_NR2904;
  L14 = G_variables_SIZE_NR2905;
  *P4 = L14;
  ATTACH(L14);
  *P3 = L13;
  ATTACH(L13);
  *P2 = L11;
  *P1 = L10;
  return 1;
LAB25:
  L15 = (value) Addr((value*)&G_variables_NAMES_NR1,Int(L0));
  L16 = *((value*)L15);
  switch (Alternative(L16)) {
  case 0: goto LAB26;
  default: goto LAB28;
  };
LAB26:
  L17 = (value)(L16[1]);
  L18 = (value)(L16[2]);
  L19 = (value)(L16[3]);
  L20 = (value)(L16[4]);
  L21 = G_variables_SIZE_NR2906;
  *P4 = L21;
  ATTACH(L21);
  *P3 = L20;
  ATTACH(L20);
  *P2 = L19;
  *P1 = L17;
  return 1;
LAB28:
  L22 = (value) Addr((value*)&G_variables_NAMES_NR1,Int(L0));
  L23 = *((value*)L22);
  switch (Alternative(L23)) {
  case 1: goto LAB29;
  default: goto LAB31;
  };
LAB29:
  L24 = (value)(L23[1]);
  L25 = (value)(L23[2]);
  L26 = (value)(L23[3]);
  L27 = (value)(L23[4]);
  L28 = G_variables_SIZE_NR2907;
  *P4 = L28;
  ATTACH(L28);
  *P3 = L27;
  ATTACH(L27);
  *P2 = L26;
  *P1 = L24;
  return 1;
LAB31:
  Abort(151, module_name);
}

int Mvariables_P_set_VARIABLENR_OFFSET(P0,P1)
value P0;
value P1;
{
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = (value) Addr((value*)&G_variables_V_OFFSET_NR2,Int(L0));
  *((value *)L2) = L1;
  return 1;
}

int Mvariables_P_get_VARIABLENR_OFFSET(P0,P1)
value P0;
value *P1;
{
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = (value) Addr((value*)&G_variables_V_OFFSET_NR2,Int(L0));
  L2 = *((value*)L1);
  *P1 = L2;
  return 1;
}

int Mvariables_P_is_not_local_VARIABLENR(P0)
value P0;
{
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = (value) Addr((value*)&G_variables_NAMES_NR1,Int(L0));
  L2 = *((value*)L1);
  switch (Alternative(L2)) {
  case 3: goto LAB32;
  default: goto LAB34;
  };
LAB32:
  L3 = (value)(L2[1]);
  L4 = (value)(L2[2]);
  L5 = (value)(L2[3]);
  L6 = (value)(L2[4]);
  L7 = (value)(L2[5]);
  return 1;
LAB34:
  L8 = (value) Addr((value*)&G_variables_NAMES_NR1,Int(L0));
  L9 = *((value*)L8);
  switch (Alternative(L9)) {
  case 2: goto LAB35;
  default: goto LAB37;
  };
LAB35:
  L10 = (value)(L9[1]);
  L11 = (value)(L9[2]);
  L12 = (value)(L9[3]);
  return 1;
LAB37:
  return 0;
}

int Mvariables_P_is_constant_VARIABLENR_VALUE(P0,P1)
value P0;
value *P1;
{
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = (value) Addr((value*)&G_variables_NAMES_NR1,Int(L0));
  L2 = *((value*)L1);
  switch (Alternative(L2)) {
  case 2: goto LAB38;
  default: goto LAB40;
  };
LAB38:
  L3 = (value)(L2[1]);
  L4 = (value)(L2[2]);
  L5 = (value)(L2[3]);
  *P1 = L5;
  ATTACH(L5);
  return 1;
LAB40:
  return 0;
}

int Mvariables_P_is_global_VARIABLENR_REFNO(P0,P1)
value P0;
value *P1;
{
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = (value) Addr((value*)&G_variables_NAMES_NR1,Int(L0));
  L2 = *((value*)L1);
  switch (Alternative(L2)) {
  case 3: goto LAB41;
  default: goto LAB43;
  };
LAB41:
  L3 = (value)(L2[1]);
  L4 = (value)(L2[2]);
  L5 = (value)(L2[3]);
  L6 = (value)(L2[4]);
  L7 = (value)(L2[5]);
  *P1 = L7;
  return 1;
LAB43:
  return 0;
}

int Mvariables_P_first_global_VARIABLENR(P0)
value *P0;
{
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = C_INT(0);
  L1 = C_INT(1);
  L2 = C_INT(Int(L0) - Int(L1));
  L3 = L2;
  if (!Mvariables_P_next_global_VARIABLENR(&L3)) goto LAB44;
  *P0 = L3;
  return 1;
LAB44:
  return 0;
  return 0;
}

int Mvariables_P_next_global_VARIABLENR(P0)
value *P0;
{
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = *P0;
  L1 = C_INT(1);
  L2 = C_INT(Int(L0) + Int(L1));
  L3 = (value)G_variables_NR_OF_NAMES_NR3;
  if (!(L2 == L3)) goto LAB47;
  return 0;
LAB47:
  L4 = (value) Addr((value*)&G_variables_NAMES_NR1,Int(L2));
  L5 = *((value*)L4);
  switch (Alternative(L5)) {
  case 3: goto LAB48;
  default: goto LAB50;
  };
LAB48:
  L6 = (value)(L5[1]);
  L7 = (value)(L5[2]);
  L8 = (value)(L5[3]);
  L9 = (value)(L5[4]);
  L10 = (value)(L5[5]);
  *P0 = L2;
  return 1;
LAB50:
  L11 = (value) Addr((value*)&G_variables_NAMES_NR1,Int(L2));
  L12 = *((value*)L11);
  switch (Alternative(L12)) {
  case 2: goto LAB51;
  default: goto LAB53;
  };
LAB51:
  L13 = (value)(L12[1]);
  L14 = (value)(L12[2]);
  L15 = (value)(L12[3]);
  *P0 = L2;
  return 1;
LAB53:
  L16 = L2;
  if (!Mvariables_P_next_global_VARIABLENR(&L16)) goto LAB54;
  *P0 = L16;
  return 1;
LAB54:
  return 0;
  return 0;
}

int Mvariables_P_error_INSTANCE(P0)
value P0;
{
  value L1;
  value L0;
  L0 = P0;
  Mvariables_P_build_instance_INSTANCE_TEXT(L0,&L1);
  Merrors_P_error_text_TEXT(L1);
D_TEXT(L1);
  return 1;
}

int Mvariables_P_build_instance_INSTANCE_TEXT(P0,P1)
value P0;
value *P1;
{
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  switch (Alternative(L0)) {
  case 1: goto LAB56;
  case 0: goto LAB59;
  default: goto LAB61;
  };
LAB56:
  L1 = G_variables_TEXT_NR2908;
  *P1 = L1;
  ATTACH(L1);
  return 1;
LAB59:
  L2 = (value)(L0[1]);
  E60_bindec_INT_TEXT(L2,&L3);
  *P1 = L3;
  return 1;
LAB61:
  Abort(190, module_name);
}

int Mvariables_P_init_hash_table()
{
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = C_INT(0);
  G_variables_NR_OF_NAMES_NR3 = (long)L0;
  L1 = C_INT(0);
  G_variables_NR_GLOBALS_NR5 = (long)L1;
  L2 = C_INT(-1);
  G_variables_NORULE_NR4 = (long)L2;
  L3 = C_INT(1024);
  L4 = L3;
LAB279:
  switch (Int(L4)) {
  case 0: goto LAB278;
  default: goto LAB282;
  };
LAB282:
  L5 = C_INT(1);
  L6 = C_INT(Int(L4) - Int(L5));
  L7 = G_variables_VARIABLENRLIST_NR2909;
  L8 = (value) Addr((value*)&G_variables_HASHEDNAMES_NR0,Int(L6));
  ATTACH(L7);
if(DecrRefs(*((value*)L8))<0)
XD_Mvariables_T34(*((value*)L8));
  *((value *)L8) = L7;
  L4 = L6;
  goto LAB279;
LAB278:
  return 1;
}

int Mvariables_P_init_hash_table_INDEX(P0)
value P0;
{
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
LAB277:
  switch (Int(L0)) {
  case 0: goto LAB62;
  default: goto LAB64;
  };
LAB62:
  return 1;
LAB64:
  L1 = C_INT(1);
  L2 = C_INT(Int(L0) - Int(L1));
  L3 = G_variables_VARIABLENRLIST_NR2909;
  L4 = (value) Addr((value*)&G_variables_HASHEDNAMES_NR0,Int(L2));
  ATTACH(L3);
if(DecrRefs(*((value*)L4))<0)
XD_Mvariables_T34(*((value*)L4));
  *((value *)L4) = L3;
  L0 = L2;
  goto LAB277;
}

int Mvariables_P_exists_MODULENR_RULENR_TYPENR_INSTANCE_VARIABLENRLIST_VARIABLENR(P0,P1,P2,P3,P4,P5)
value P0;
value P1;
value P2;
value P3;
value P4;
value *P5;
{
  value L28;
  value L27;
  value L26;
  value L25;
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = P2;
  L3 = P3;
  L4 = P4;
LAB106:
  switch (Alternative(L4)) {
  case 0: goto LAB65;
  default: goto LAB67;
  };
LAB65:
  L5 = (value)(L4[1]);
  L6 = (value)(L4[2]);
  L7 = (value) Addr((value*)&G_variables_NAMES_NR1,Int(L5));
  L8 = *((value*)L7);
  switch (Alternative(L8)) {
  case 3: goto LAB68;
  default: goto LAB70;
  };
LAB68:
  L9 = (value)(L8[1]);
  L10 = (value)(L8[2]);
  L11 = (value)(L8[3]);
  L12 = (value)(L8[4]);
  L13 = (value)(L8[5]);
  if (!(L0 == L9)) goto LAB72;
  if (!(L2 == L10)) goto LAB72;
  if (!EQ_Mvariables_T8(L3,L11)) goto LAB72;
  *P5 = L5;
  return 1;
LAB72:
  L4 = L6;
  goto LAB106;
  return 0;
LAB70:
  L15 = (value) Addr((value*)&G_variables_NAMES_NR1,Int(L5));
  L16 = *((value*)L15);
  switch (Alternative(L16)) {
  case 0: goto LAB79;
  default: goto LAB81;
  };
LAB79:
  L17 = (value)(L16[1]);
  L18 = (value)(L16[2]);
  L19 = (value)(L16[3]);
  L20 = (value)(L16[4]);
  if (!(L0 == L17)) goto LAB83;
  if (!(L1 == L18)) goto LAB83;
  if (!(L2 == L19)) goto LAB83;
  if (!EQ_Mvariables_T8(L3,L20)) goto LAB83;
  *P5 = L5;
  return 1;
LAB83:
  L4 = L6;
  goto LAB106;
  return 0;
LAB81:
  L22 = (value) Addr((value*)&G_variables_NAMES_NR1,Int(L5));
  L23 = *((value*)L22);
  switch (Alternative(L23)) {
  case 1: goto LAB92;
  default: goto LAB94;
  };
LAB92:
  L24 = (value)(L23[1]);
  L25 = (value)(L23[2]);
  L26 = (value)(L23[3]);
  L27 = (value)(L23[4]);
  if (!(L0 == L24)) goto LAB96;
  if (!(L1 == L25)) goto LAB96;
  if (!(L2 == L26)) goto LAB96;
  if (!EQ_Mvariables_T8(L3,L27)) goto LAB96;
  *P5 = L5;
  return 1;
LAB96:
  L4 = L6;
  goto LAB106;
  return 0;
LAB94:
  Abort(85, module_name);
LAB67:
  return 0;
}

