/*
 * types.c -- part of the C sources generated from the CDL3 sources,
 *              used to bootstrap CDL3
 * Copyright (C) 2000  C.H.A. Koster
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "cdl3rts.h"
#include "predef.h"


static char* module_name = "types";

/*
** GLOBALS
*/

	static long undefined[] = {2047};
long G_types_HASHEDTYPENAMES_NR0B = 0;
value G_types_HASHEDTYPENAMES_NR0 = &G_types_HASHEDTYPENAMES_NR0B;
long G_types_TYPENAMES_NR1B = 0;
value G_types_TYPENAMES_NR1 = &G_types_TYPENAMES_NR1B;
long G_types_TYPES_NR2B = 0;
value G_types_TYPES_NR2 = &G_types_TYPES_NR2B;
long G_types_FROM_NR3A = 1;
value G_types_FROM_NR3 = &G_types_FROM_NR3A;
long G_types_IDS_NR4A = 1;
value G_types_IDS_NR4 = &G_types_IDS_NR4A;
long G_types_NR_OF_TYPES_NR5 = 0;
long G_types_INT_TYPENR_NR6 = 0;
long G_types_TEXT_TYPENR_NR7 = 0;
long G_types_REAL_TYPENR_NR8 = 0;
value G_types_ERRORS_NR9 = undefined;
long G_types_TYPES_NR2896[] = {Tag(1,6)};
long G_types_TEXT_NR2897[] = {Tag(1,T_TEXT),1,(long)":"};
long G_types_TEXT_NR2898[] = {Tag(1,T_TEXT),22,(long)" duplicate definition\n"};
long G_types_TYPE_NR2899[] = {Tag(1,2)};
long G_types_TYPE_NR2900[] = {Tag(1,2)};
long G_types_TEXT_NR2901[] = {Tag(1,T_TEXT),1,(long)":"};
long G_types_TEXT_NR2902[] = {Tag(1,T_TEXT),22,(long)" duplicate definition\n"};
long G_types_TYPE_NR2903[] = {Tag(1,2)};
long G_types_TEXT_NR2904[] = {Tag(1,T_TEXT),1,(long)":"};
long G_types_TEXT_NR2905[] = {Tag(1,T_TEXT),22,(long)" duplicate definition\n"};
long G_types_TEXT_NR2906[] = {Tag(1,T_TEXT),1,(long)":"};
long G_types_TEXT_NR2907[] = {Tag(1,T_TEXT),22,(long)" duplicate definition\n"};
long G_types_TYPES_NR2908[] = {Tag(1,3)};
long G_types_TEXT_NR2909[] = {Tag(1,T_TEXT),1,(long)":"};
long G_types_TEXT_NR2910[] = {Tag(1,T_TEXT),18,(long)" already exported\n"};
long G_types_TYPES_NR2911[] = {Tag(1,3)};
long G_types_STYPE_NR2912[] = {Tag(1,0)};
long G_types_STYPE_NR2913[] = {Tag(1,1)};
long G_types_STYPE_NR2914[] = {Tag(1,2)};
long G_types_STYPE_NR2915[] = {Tag(1,3)};
long G_types_ERRORS_NR2916[] = {Tag(1,1)};
long G_types_TEXT_NR2917[] = {Tag(1,T_TEXT),3,(long)"INT"};
long G_types_TEXT_NR2918[] = {Tag(1,T_TEXT),4,(long)"TEXT"};
long G_types_ERRORS_NR2919[] = {Tag(1,0)};
long G_types_TYPENRLIST_NR2920[] = {Tag(1,1)};
long G_types_TYPE_NR2921[] = {Tag(1,2)};
long G_types_TYPE_NR2922[] = {Tag(1,2)};
long G_types_TYPE_NR2923[] = {Tag(1,2)};
long G_types_TYPE_NR2924[] = {Tag(1,2)};
long G_types_TYPE_NR2925[] = {Tag(1,2)};
long G_types_TEXT_NR2926[] = {Tag(1,T_TEXT),1,(long)":"};
long G_types_TEXT_NR2927[] = {Tag(1,T_TEXT),33,(long)" imports conflicting definitions\n"};
long G_types_TEXT_NR2928[] = {Tag(1,T_TEXT),1,(long)":"};
long G_types_TEXT_NR2929[] = {Tag(1,T_TEXT),14,(long)" is undefined\n"};
long G_types_TYPE_NR2930[] = {Tag(1,2)};
long G_types_TYPE_NR2931[] = {Tag(1,2)};
long G_types_TEXT_NR2932[] = {Tag(1,T_TEXT),1,(long)":"};
long G_types_TEXT_NR2933[] = {Tag(1,T_TEXT),27,(long)" is exported but undefined\n"};
long G_types_TEXT_NR2934[] = {Tag(1,T_TEXT),4,(long)" or "};
long G_types_TEXT_NR2935[] = {Tag(1,T_TEXT),4,(long)"syn "};
long G_types_TEXT_NR2936[] = {Tag(1,T_TEXT),5,(long)"undef"};
long G_types_TEXT_NR2937[] = {Tag(1,T_TEXT),1,(long)" "};
long G_types_TEXT_NR2938[] = {Tag(1,T_TEXT),1,(long)" "};
long G_types_TEXT_NR2939[] = {Tag(1,T_TEXT),0,(long)""};

/*
** ATTACH/DETACH/EQUAL
*/
/****TYPENAMES(types)****/

int EQ_Mtypes_T2(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return EQ_TEXT(Part(x,1),Part(y,1))&&(Part(x,2) == Part(y,2));
    };
  return 0;
}

int W_Mtypes_T2(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
WRITE("\"");
W_TEXT(Part(x,1));
WRITE("\"");
WRITE(" ");
W_INT(Part(x,2));
WRITE(" ");
    };
  return 0;
}

int XD_Mtypes_T2(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
D_TEXT(Part(x,1));
            Free(x,3);
            break;
    };
}

int D_Mtypes_T2(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Mtypes_T2(x);
}

/****TYPES(types)****/

int EQ_Mtypes_T3(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return EQ_Mtypes_T3(Part(x,1),Part(y,1));
       case 1:
         return EQ_Mtypes_T3(Part(x,1),Part(y,1));
       case 2:
         return EQ_Mtypes_T3(Part(x,1),Part(y,1));
       case 3:
         return 1;
       case 4:
         return EQ_Mtypes_T11(Part(x,1),Part(y,1));
       case 5:
         return EQ_Mtypes_T11(Part(x,1),Part(y,1));
       case 6:
         return 1;
    };
  return 0;
}

int W_Mtypes_T3(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
WRITE("imported ");
W_Mtypes_T3(Part(x,1));
WRITE(" ");
       case 1:
WRITE("reexported ");
W_Mtypes_T3(Part(x,1));
WRITE(" ");
       case 2:
WRITE("exported ");
W_Mtypes_T3(Part(x,1));
WRITE(" ");
       case 3:
WRITE("exported ");
       case 4:
WRITE("abstract ");
W_Mtypes_T11(Part(x,1));
WRITE(" ");
       case 5:
W_Mtypes_T11(Part(x,1));
WRITE(" ");
       case 6:
WRITE("unknown ");
    };
  return 0;
}

int XD_Mtypes_T3(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
D_Mtypes_T3(Part(x,1));
            Free(x,2);
            break;
          case 1:
D_Mtypes_T3(Part(x,1));
            Free(x,2);
            break;
          case 2:
D_Mtypes_T3(Part(x,1));
            Free(x,2);
            break;
          case 3:
            Free(x,1);
            break;
          case 4:
D_Mtypes_T11(Part(x,1));
            Free(x,2);
            break;
          case 5:
D_Mtypes_T11(Part(x,1));
            Free(x,2);
            break;
          case 6:
            Free(x,1);
            break;
    };
}

int D_Mtypes_T3(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Mtypes_T3(x);
}

/****ERRORS(types)****/

int EQ_Mtypes_T10(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return 1;
       case 1:
         return 1;
    };
  return 0;
}

int W_Mtypes_T10(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
WRITE("true ");
       case 1:
WRITE("false ");
    };
  return 0;
}

int XD_Mtypes_T10(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
            Free(x,1);
            break;
          case 1:
            Free(x,1);
            break;
    };
}

int D_Mtypes_T10(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Mtypes_T10(x);
}

/****TYPE(types)****/

int EQ_Mtypes_T11(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return EQ_Mtypes_T15(Part(x,1),Part(y,1))&&EQ_Mtypes_T11(Part(x,2),Part(y,2));
       case 1:
         return (Part(x,1) == Part(y,1));
       case 2:
         return 1;
    };
  return 0;
}

int W_Mtypes_T11(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
W_Mtypes_T15(Part(x,1));
WRITE(" ");
WRITE("or ");
W_Mtypes_T11(Part(x,2));
WRITE(" ");
       case 1:
WRITE("synonym ");
W_INT(Part(x,1));
WRITE(" ");
       case 2:
WRITE("undefined ");
    };
  return 0;
}

int XD_Mtypes_T11(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
D_Mtypes_T15(Part(x,1));
D_Mtypes_T11(Part(x,2));
            Free(x,3);
            break;
          case 1:
            Free(x,2);
            break;
          case 2:
            Free(x,1);
            break;
    };
}

int D_Mtypes_T11(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Mtypes_T11(x);
}

/****STYPE(types)****/

int EQ_Mtypes_T12(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return 1;
       case 1:
         return 1;
       case 2:
         return 1;
       case 3:
         return 1;
    };
  return 0;
}

int W_Mtypes_T12(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
WRITE("int ");
       case 1:
WRITE("text ");
       case 2:
WRITE("real ");
       case 3:
WRITE("external ");
    };
  return 0;
}

int XD_Mtypes_T12(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
            Free(x,1);
            break;
          case 1:
            Free(x,1);
            break;
          case 2:
            Free(x,1);
            break;
          case 3:
            Free(x,1);
            break;
    };
}

int D_Mtypes_T12(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Mtypes_T12(x);
}

/****TYPEALTERNATIVE(types)****/

int EQ_Mtypes_T15(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return (Part(x,1) == Part(y,1))&&EQ_Mtypes_T15(Part(x,2),Part(y,2));
       case 1:
         return (Part(x,1) == Part(y,1))&&EQ_Mtypes_T15(Part(x,2),Part(y,2));
       case 2:
         return 1;
    };
  return 0;
}

int W_Mtypes_T15(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
W_INT(Part(x,1));
WRITE(" ");
W_Mtypes_T15(Part(x,2));
WRITE(" ");
       case 1:
W_INT(Part(x,1));
WRITE(" ");
W_Mtypes_T15(Part(x,2));
WRITE(" ");
       case 2:
WRITE("end ");
    };
  return 0;
}

int XD_Mtypes_T15(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
D_Mtypes_T15(Part(x,2));
            Free(x,3);
            break;
          case 1:
D_Mtypes_T15(Part(x,2));
            Free(x,3);
            break;
          case 2:
            Free(x,1);
            break;
    };
}

int D_Mtypes_T15(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Mtypes_T15(x);
}

/****TYPENRLIST(types)****/

int EQ_Mtypes_T49(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return (Part(x,1) == Part(y,1))&&EQ_Mtypes_T49(Part(x,2),Part(y,2));
       case 1:
         return 1;
    };
  return 0;
}

int W_Mtypes_T49(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
W_INT(Part(x,1));
WRITE(" ");
W_Mtypes_T49(Part(x,2));
WRITE(" ");
       case 1:
WRITE("end ");
    };
  return 0;
}

int XD_Mtypes_T49(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
D_Mtypes_T49(Part(x,2));
            Free(x,3);
            break;
          case 1:
            Free(x,1);
            break;
    };
}

int D_Mtypes_T49(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Mtypes_T49(x);
}


/*
** PROTOTYPES
*/

_PROTOTYPE(int Mtypes_P_propagate_types,());
_PROTOTYPE(int Mtypes_P_convert_MODULENR_TYPENAME_TYPENR,(value P0,value P1,value *P2));
_PROTOTYPE(int Mtypes_P_add_abstract_type_MODULENR_TYPENAME_TYPE_TYPENR,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(int Mtypes_P_add_external_type_MODULENR_TYPENAME_TYPENR,(value P0,value P1,value *P2));
_PROTOTYPE(int Mtypes_P_add_type_MODULENR_TYPENAME_TYPE_TYPENR,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(int Mtypes_P_add_synonym_MODULENR_TYPENAME_TYPENR_TYPENR,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(int Mtypes_P_export_type_MODULENR_TYPENAME_TYPENR,(value P0,value P1,value *P2));
_PROTOTYPE(int Mtypes_P_is_imported_abstract_type_TYPENR,(value P0));
_PROTOTYPE(int Mtypes_P_is_abstract_type_TYPENR_TYPE,(value P0,value *P1));
_PROTOTYPE(int Mtypes_P_is_special_type_TYPENR_STYPE,(value P0,value *P1));
_PROTOTYPE(int Mtypes_P_is_external_type_TYPENR,(value P0));
_PROTOTYPE(int Mtypes_P_is_integer_type_TYPENR,(value P0));
_PROTOTYPE(int Mtypes_P_is_undefined_type_TYPENR,(value P0));
_PROTOTYPE(int Mtypes_P_is_exported_type_TYPENR,(value P0));
_PROTOTYPE(int Mtypes_P_same_TYPE_TYPENR,(value P0,value *P1));
_PROTOTYPE(int Mtypes_P_same_TYPENR_TYPENR,(value P0,value *P1));
_PROTOTYPE(int Mtypes_P_integer_type_TYPENR,(value *P0));
_PROTOTYPE(int Mtypes_P_is_text_type_TYPENR,(value P0));
_PROTOTYPE(int Mtypes_P_text_type_TYPENR,(value *P0));
_PROTOTYPE(int Mtypes_P_equal_types_TYPENR_TYPENR,(value P0,value P1));
_PROTOTYPE(int Mtypes_P_get_TYPENR_TYPE,(value P0,value *P1));
_PROTOTYPE(int Mtypes_P_get_TYPENR_TYPENAME_MODULENR,(value P0,value *P1,value *P2));
_PROTOTYPE(int Mtypes_P_get_TYPENR_MODULENR_ID,(value P0,value *P1,value *P2));
_PROTOTYPE(int Mtypes_P_first_TYPENR,(value *P0));
_PROTOTYPE(int Mtypes_P_next_TYPENR,(value *P0));
_PROTOTYPE(int Mtypes_P_error_TYPENR,(value P0));
_PROTOTYPE(int Mtypes_P_build_type_TYPENR_TEXT,(value P0,value *P1));
_PROTOTYPE(int Mtypes_P_type_errors,());
_PROTOTYPE(int Mtypes_P_init_type_table,());
_PROTOTYPE(int Mtypes_P_type_error_MESSAGE,(value P0));
_PROTOTYPE(int Mtypes_P_hash_TYPENAME_INDEX,(value P0,value *P1));
_PROTOTYPE(int Mtypes_P_init_hash_table_INDEX,(value P0));
_PROTOTYPE(int Mtypes_P_create_MODULENR_TYPENAME_TYPENR,(value P0,value P1,value *P2));
_PROTOTYPE(int Mtypes_P_in_MODULENR_TYPENAME_TYPENRLIST_TYPENR,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(int Mtypes_P_exists_MODULENR_TYPENAME_TYPENR,(value P0,value P1,value *P2));
_PROTOTYPE(int Mtypes_P_is_abstract_type_TYPES_TYPE,(value P0,value *P1));
_PROTOTYPE(int Mtypes_P_is_undefined_type_TYPES,(value P0));
_PROTOTYPE(int Mtypes_P_is_external_type_TYPES_TYPE,(value P0,value *P1));
_PROTOTYPE(int Mtypes_P_get_TYPES_TYPE,(value P0,value *P1));
_PROTOTYPE(int Mtypes_P_propagate_type_TYPENR_TYPENR,(value P0,value P1));
_PROTOTYPE(int Mtypes_P_propagate_types_TYPENR_TYPENAME_EXPORTS,(value P0,value P1,value P2));
_PROTOTYPE(int Mtypes_P_propagate_synonym_TYPENR,(value P0));
_PROTOTYPE(int Mtypes_P_propagate_synonyms_TYPENR,(value P0));
_PROTOTYPE(int Mtypes_P_propagate_types_TYPENR,(value P0));
_PROTOTYPE(int Mtypes_P_check_all_types_TYPENR,(value P0));
_PROTOTYPE(int Mtypes_P_is_real_type_TYPENR,(value P0));
_PROTOTYPE(int Mtypes_P_real_type_TYPENR,(value *P0));
_PROTOTYPE(int Mtypes_P_build_type_TYPE_TEXT,(value P0,value *P1));
_PROTOTYPE(int Mtypes_P_build_type_TYPEALTERNATIVE_TEXT,(value P0,value *P1));


/*
**EXTERNAL PROTOTYPES**
*/

_PROTOTYPE(extern int E1_open_input_file_TEXT_FILE,(value P0,value *P1));
_PROTOTYPE(extern int E2_open_output_file_TEXT_FILE,(value P0,value *P1));
_PROTOTYPE(extern int E3_open_standard_output_FILE,(value *P0));
_PROTOTYPE(extern int E4_open_standard_error_FILE,(value *P0));
_PROTOTYPE(extern int E5_open_standard_input_FILE,(value *P0));
_PROTOTYPE(extern int E8_pipe_to_command_TEXT_FILE,(value P0,value *P1));
_PROTOTYPE(extern int E28_pipe_from_command_TEXT_FILE,(value P0,value *P1));
_PROTOTYPE(extern int E9_close_pipe_FILE,(value P0));
_PROTOTYPE(extern int E6_close_FILE,(value P0));
_PROTOTYPE(extern int E7_seek_FILE_INT,(value P0,value P1));
_PROTOTYPE(extern int E10_write_TEXT,(value P0));
_PROTOTYPE(extern int E11_write_INT,(value P0));
_PROTOTYPE(extern int E12_write_FILE_TEXT,(value P0,value P1));
_PROTOTYPE(extern int E13_write_FILE_INT,(value P0,value P1));
_PROTOTYPE(extern int E14_formatted_write_FILE_FORMAT,(value P0,value P1));
_PROTOTYPE(extern int E15_write_char_FILE_INT,(value P0,value P1));
_PROTOTYPE(extern int E16_write_char_INT,(value P0));
_PROTOTYPE(extern int E20_trace_TEXT,(value P0));
_PROTOTYPE(extern int E21_trace_INT,(value P0));
_PROTOTYPE(extern int E22_formatted_trace_FILE_FORMAT,(value P0,value P1));
_PROTOTYPE(extern int E30_read_line_TEXT,(value *P0));
_PROTOTYPE(extern int E31_read_line_FILE_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int E32_read_char_FILE_INT,(value P0,value *P1));
_PROTOTYPE(extern int E33_read_char_INT,(value *P0));
_PROTOTYPE(extern int E40_less_INT_INT,(value P0,value P1));
_PROTOTYPE(extern int E41_lesseq_INT_INT,(value P0,value P1));
_PROTOTYPE(extern int E42_greater_INT_INT,(value P0,value P1));
_PROTOTYPE(extern int E43_greatereq_INT_INT,(value P0,value P1));
_PROTOTYPE(extern int E58_length_TEXT_INT,(value P0,value *P1));
_PROTOTYPE(extern int E51_extract_TEXT_INT_INT_TEXT,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int E52_is_subtext_TEXT_INT_TEXT,(value P0,value *P1,value P2));
_PROTOTYPE(extern int E53_between_TEXT_INT_TEXT_TEXT,(value P0,value P1,value P2,value P3));
_PROTOTYPE(extern int E54_not_between_TEXT_INT_TEXT_TEXT,(value P0,value P1,value P2,value P3));
_PROTOTYPE(extern int E55_before_TEXT_TEXT,(value P0,value P1));
_PROTOTYPE(extern int E56_is_prefix_TEXT_TEXT_TEXT,(value P0,value P1,value *P2));
_PROTOTYPE(extern int E57_prefix_TEXT_INT_TEXT_TEXT,(value P0,value P1,value *P2,value *P3));
_PROTOTYPE(extern int E59_asciicode_TEXT_INT_INT,(value P0,value P1,value *P2));
_PROTOTYPE(extern int E60_bindec_INT_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int E61_decbin_TEXT_INT,(value P0,value *P1));
_PROTOTYPE(extern int E70_hash_TEXT_INT_INT,(value P0,value P1,value *P2));
_PROTOTYPE(extern int E80_command_arg_INT_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int E81_exit_INT,(value P0));
_PROTOTYPE(extern int E82_get_from_environment_TEXT_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int E83_time_INT,(value *P0));
_PROTOTYPE(extern int E85_file_date_TEXT_INT,(value P0,value *P1));
_PROTOTYPE(extern int E84_execute_TEXT,(value P0));
_PROTOTYPE(extern int E200_get_key_TEXT,(value *P0));
_PROTOTYPE(extern int Mterminals_P_convert_TERMINAL_TERMINALNR,(value P0,value *P1));
_PROTOTYPE(extern int Mterminals_P_get_TERMINALNR_TERMINAL,(value P0,value *P1));
_PROTOTYPE(extern int Mterminals_P_error_terminal_TERMINALNR,(value P0));
_PROTOTYPE(extern int Mmodules_P_init_modules,());
_PROTOTYPE(extern int Mmodules_P_is_root_module_MODULENR,(value P0));
_PROTOTYPE(extern int Mmodules_P_set_root_module_MODULENR,(value P0));
_PROTOTYPE(extern int Mmodules_P_new_id_MODULENR_ID,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_order_MODULENR_MODULEORDER,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_convert_MODULE_MODULENR,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_add_import_for_module_MODULENR_MODULENR,(value P0,value P1));
_PROTOTYPE(extern int Mmodules_P_store_versionid_MODULENR_VERSIONTEXT,(value P0,value P1));
_PROTOTYPE(extern int Mmodules_P_module_exports_rule_MODULENR_RULENR,(value P0,value P1));
_PROTOTYPE(extern int Mmodules_P_get_exported_rules_from_module_MODULENR_RULENRS,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_get_MODULENR_MODULE,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_get_module_name_MODULENR_MODULENAME,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_get_MODULENR_VERSIONTEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_get_MODULENR_EXPORTS,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_get_MODULENR_IMPORTS,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_first_MODULENR,(value *P0));
_PROTOTYPE(extern int Mmodules_P_next_MODULENR,(value *P0));
_PROTOTYPE(extern int Mmodules_P_error_MODULENR,(value P0));
_PROTOTYPE(extern int Merrors_P_status_message_TEXT,(value P0));
_PROTOTYPE(extern int Merrors_P_status_message_MODULENR,(value P0));
_PROTOTYPE(extern int Merrors_P_debug_MESSAGE,(value P0));
_PROTOTYPE(extern int Merrors_P_debug_text_TEXT,(value P0));
_PROTOTYPE(extern int Merrors_P_debug_int_INT,(value P0));
_PROTOTYPE(extern int Merrors_P_error_MESSAGE,(value P0));
_PROTOTYPE(extern int Merrors_P_error_text_TEXT,(value P0));
_PROTOTYPE(extern int Merrors_P_error_int_INT,(value P0));
_PROTOTYPE(extern int Mrules_P_propagate_rules,());
_PROTOTYPE(extern int Mrules_P_convert_MODULENR_RULENAME_ARITY_RULEID,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mrules_P_add_syntax_rule_RULEID_RULETYPE_PARAMETERS_NODENR_RULENR,(value P0,value P1,value P2,value *P3,value *P4));
_PROTOTYPE(extern int Mrules_P_export_rule_RULEID_RULETYPE_PARAMETERS_RULENR,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mrules_P_add_external_rule_RULEID_RULETYPE_PARAMETERS_EXTNR_NODENR_RULENR,(value P0,value P1,value P2,value P3,value *P4,value *P5));
_PROTOTYPE(extern int Mrules_P_is_external_RULENR_EXTNR,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_in_interface_RULENR,(value P0));
_PROTOTYPE(extern int Mrules_P_is_fixed_RULENR_INT,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULEID_RULENRS,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULEID_RULENAME,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULEID_MODULENR,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULENR_MODULENR_RULETYPE_RULENAME_ARITY_PARAMETERS_NODENR,(value P0,value *P1,value *P2,value *P3,value *P4,value *P5,value *P6));
_PROTOTYPE(extern int Mrules_P_get_RULENR_FRAMESIZE_FRAMESIZE,(value P0,value *P1,value *P2));
_PROTOTYPE(extern int Mrules_P_get_RULENR_RULETYPE,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULENR_RULENAME,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULENR_MODULENR,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULENR_PARAMETERS,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULENR_MODULENR_ID,(value P0,value *P1,value *P2));
_PROTOTYPE(extern int Mrules_P_set_RULENR_FRAMESIZE_FRAMESIZE,(value P0,value P1,value P2));
_PROTOTYPE(extern int Mrules_P_get_preludes_RULENRS,(value *P0));
_PROTOTYPE(extern int Mrules_P_get_postludes_RULENRS,(value *P0));
_PROTOTYPE(extern int Mrules_P_get_interludes_RULENRS,(value *P0));
_PROTOTYPE(extern int Mrules_P_first_rule_RULENR,(value *P0));
_PROTOTYPE(extern int Mrules_P_next_rule_RULENR,(value *P0));
_PROTOTYPE(extern int Mrules_P_first_rulename_RULEID,(value *P0));
_PROTOTYPE(extern int Mrules_P_next_rulename_RULEID,(value *P0));
_PROTOTYPE(extern int Mrules_P_error_RULENR,(value P0));
_PROTOTYPE(extern int Mrules_P_error_RULENAME,(value P0));
_PROTOTYPE(extern int Mrules_P_build_rule_RULENR_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_build_rule_RULENAME_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_definition_errors,());
_PROTOTYPE(extern int Mrules_P_set_root_error_handler_HANDLER,(value P0));
_PROTOTYPE(extern int Mrules_P_get_root_error_handler_HANDLER,(value *P0));
_PROTOTYPE(extern int Mrules_P_set_root_rule_ROOT,(value P0));
_PROTOTYPE(extern int Mrules_P_get_root_rule_ROOT,(value *P0));
_PROTOTYPE(extern int Mcoder_P_no_code,());
_PROTOTYPE(extern int Mcoder_P_no_gc,());
_PROTOTYPE(extern int Mcoder_P_trace_on,());
_PROTOTYPE(extern int Mcoder_P_produce_statistics,());
_PROTOTYPE(extern int Mcoder_P_profile_on,());
_PROTOTYPE(extern int Mcoder_P_just_compile_and_no_object,());
_PROTOTYPE(extern int Mcoder_P_extension_TEXT,(value *P0));
_PROTOTYPE(extern int Mcoder_P_external_names_do_not_start_with_underscore,());
_PROTOTYPE(extern int Mcoder_P_optimize_array_references,());
_PROTOTYPE(extern int Mcoder_P_code_MODULENR,(value P0));
_PROTOTYPE(extern int Mfiles_P_paths_PATHS,(value *P0));
_PROTOTYPE(extern int Mfiles_P_init_files,());
_PROTOTYPE(extern int Mfiles_P_strip_path_TEXT_TEXT_TEXT,(value P0,value *P1,value *P2));
_PROTOTYPE(extern int Mfiles_P_set_lib_path_TEXT,(value P0));
_PROTOTYPE(extern int Mfiles_P_date_TEXT_INT,(value P0,value *P1));
_PROTOTYPE(extern int Mfiles_P_open_TEXT_FILE,(value P0,value *P1));
_PROTOTYPE(extern int Mnodes_P_new_NODENR,(value *P0));
_PROTOTYPE(extern int Mnodes_P_store_NODENR_LINENR_NODE,(value P0,value P1,value P2));
_PROTOTYPE(extern int Mnodes_P_get_NODENR_LINENR_NODE,(value P0,value *P1,value *P2));
_PROTOTYPE(extern int Mnodes_P_append_succeed_NODENR_NODENR,(value P0,value *P1));
_PROTOTYPE(extern int Mnodes_P_append_fail_NODENR_NODENR,(value P0,value *P1));
_PROTOTYPE(extern int Mnodes_P_succeed_NODENR_NODENR,(value P0,value *P1));
_PROTOTYPE(extern int Mnodes_P_fail_NODENR_NODENR,(value P0,value *P1));
_PROTOTYPE(extern int Mnodes_P_pass_two_NODENR_NODENR,(value P0,value *P1));
_PROTOTYPE(extern int Mnodes_P_error_SUBEXPRESSION,(value P0));
_PROTOTYPE(extern int Mnodes_P_error_EXPRESSION,(value P0));
_PROTOTYPE(extern int Mcode_P_start_coding,());
_PROTOTYPE(extern int Mcode_P_new_LABEL,(value *P0));
_PROTOTYPE(extern int Mcode_P_error_OPERATOR,(value P0));
_PROTOTYPE(extern int Mcode_P_error_MONADIC_OPERATOR,(value P0));
_PROTOTYPE(extern int Mcode_P_store_INSTRUCTION,(value P0));
_PROTOTYPE(extern int Mcode_P_append_LOCATION_INSTRUCTION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_overwrite_LOCATION_INSTRUCTION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_prepend_LOCATION_INSTRUCTION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_prepend_INSTRUCTION,(value P0));
_PROTOTYPE(extern int Mcode_P_delete_LOCATION,(value P0));
_PROTOTYPE(extern int Mcode_P_delete_LOCATION_LOCATION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_move_LOCATION_LOCATION_LOCATION,(value P0,value P1,value P2));
_PROTOTYPE(extern int Mcode_P_current_LOCATION,(value *P0));
_PROTOTYPE(extern int Mcode_P_set_LOCATION,(value P0));
_PROTOTYPE(extern int Mcode_P_get_LOCATION_INSTRUCTION,(value P0,value *P1));
_PROTOTYPE(extern int Mcode_P_next_LOCATION_LOCATION,(value P0,value *P1));
_PROTOTYPE(extern int Mcode_P_prev_LOCATION_LOCATION,(value P0,value *P1));
_PROTOTYPE(extern int Mcode_P_is_end_LOCATION,(value P0));
_PROTOTYPE(extern int Mcode_P_first_LOCATION,(value *P0));
_PROTOTYPE(extern int Mcode_P_prev_LOCATION,(value *P0));
_PROTOTYPE(extern int Mcode_P_next_LOCATION,(value *P0));
_PROTOTYPE(extern int Mcode_P_is_associative_OPERATOR,(value P0));
_PROTOTYPE(extern int Mcode_P_register_label_LABEL_LOCATION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_register_label_LABEL,(value P0));
_PROTOTYPE(extern int Mcode_P_register_goto_LABEL_LOCATION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_register_goto_LABELS_LOCATION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_register_goto_LABEL,(value P0));
_PROTOTYPE(extern int Mcode_P_register_goto_LABELS,(value P0));
_PROTOTYPE(extern int Mcode_P_remove_goto_LABEL_LOCATION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_remove_goto_LABELS_LOCATION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_alias_LABEL_LABEL,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_absorb_goto_LABEL_INSTRUCTION_INT_INT,(value P0,value P1,value *P2,value *P3));
_PROTOTYPE(extern int Mcode_P_called_once_LABEL,(value P0));
_PROTOTYPE(extern int Mcode_P_get_label_LABEL_LOCATION,(value P0,value *P1));
_PROTOTYPE(extern int Mcode_P_no_effect_INSTRUCTION,(value P0));
_PROTOTYPE(extern int Mcode_P_write_ADDRESS,(value P0));
_PROTOTYPE(extern int Mcode_P_get_ADDRESS_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mcode_P_get_ADDRESSES_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mcode_P_dump_code_MODULENR_TEXT,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_dump_instruction_INSTRUCTION,(value P0));
_PROTOTYPE(extern int Mcode_P_dump_code_TEXT_LOCATION_LOCATION,(value P0,value P1,value P2));
_PROTOTYPE(extern int Mcode_P_make_dump_TEXT,(value P0));
_PROTOTYPE(extern int Mcode_P_request_dump_TEXT,(value P0));
_PROTOTYPE(extern int Mvariables_P_convert_PASS_MODULENR_RULENR_TYPENR_INSTANCE_VARIABLENR,(value P0,value P1,value P2,value P3,value P4,value *P5));
_PROTOTYPE(extern int Mvariables_P_store_global_MODULENR_TYPENR_INSTANCE_SIZE,(value P0,value P1,value P2,value P3));
_PROTOTYPE(extern int Mvariables_P_parameter_MODULENR_RULENR_TYPENR_INSTANCE_VARIABLENR,(value P0,value P1,value P2,value P3,value *P4));
_PROTOTYPE(extern int Mvariables_P_temporary_MODULENR_RULENR_TYPENR_VARIABLENR,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mvariables_P_constant_MODULENR_TYPENR_VALUE_VARIABLENR,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mvariables_P_get_VARIABLENR_MODULENR_TYPENR_INSTANCE_SIZE,(value P0,value *P1,value *P2,value *P3,value *P4));
_PROTOTYPE(extern int Mvariables_P_set_VARIABLENR_OFFSET,(value P0,value P1));
_PROTOTYPE(extern int Mvariables_P_get_VARIABLENR_OFFSET,(value P0,value *P1));
_PROTOTYPE(extern int Mvariables_P_is_not_local_VARIABLENR,(value P0));
_PROTOTYPE(extern int Mvariables_P_is_constant_VARIABLENR_VALUE,(value P0,value *P1));
_PROTOTYPE(extern int Mvariables_P_is_global_VARIABLENR_REFNO,(value P0,value *P1));
_PROTOTYPE(extern int Mvariables_P_first_global_VARIABLENR,(value *P0));
_PROTOTYPE(extern int Mvariables_P_next_global_VARIABLENR,(value *P0));
_PROTOTYPE(extern int Mvariables_P_error_INSTANCE,(value P0));
_PROTOTYPE(extern int Mvariables_P_build_instance_INSTANCE_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int Minline_P_declare_rule_RULENR,(value P0));
_PROTOTYPE(extern int Minline_P_register_call_RULENR_NODENR,(value P0,value P1));
_PROTOTYPE(extern int Minline_P_inline_TEXT,(value P0));
_PROTOTYPE(extern int Minline_P_inline_MODULENR,(value P0));
_PROTOTYPE(extern int Minline_P_disable_inlining,());
_PROTOTYPE(extern int Minline_P_ignore_unreachable_code,());
_PROTOTYPE(extern int Minline_P_rule_changes_global_RULENR_VARIABLENR,(value P0,value P1));
_PROTOTYPE(extern int Minline_P_call_changes_global_RULENR_VARIABLENR,(value P0,value P1));
_PROTOTYPE(extern int Minline_P_resolve_call_graph_MODULENR,(value P0));
_PROTOTYPE(extern int Minline_P_is_recursive_RULENR,(value P0));
_PROTOTYPE(extern int Minline_P_rule_is_reachable_RULENR,(value P0));
_PROTOTYPE(extern int Mscanner_P_syntax_error_MESSAGE,(value P0));
_PROTOTYPE(extern int Mscanner_P_current_line_LINENR,(value *P0));
_PROTOTYPE(extern int Mscanner_P_open_TEXT,(value P0));
_PROTOTYPE(extern int Mscanner_P_close,());
_PROTOTYPE(extern int Mscanner_P_end_of_file,());
_PROTOTYPE(extern int Mscanner_P_is_symbol_TEXT,(value P0));
_PROTOTYPE(extern int Mscanner_P_ahead_symbol_TEXT,(value P0));
_PROTOTYPE(extern int Mscanner_P_should_be_symbol_TEXT,(value P0));
_PROTOTYPE(extern int Mscanner_P_is_TYPENAME,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_TYPENAME_INSTANCE,(value *P0,value *P1));
_PROTOTYPE(extern int Mscanner_P_is_placeholder_TYPENAME,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_TERMINAL,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_MODULE,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_SIZE,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_EXTNR,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_NUMBER,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_STRING,(value *P0));
_PROTOTYPE(extern int Manalyzer_P_semantic_errors,());
_PROTOTYPE(extern int Manalyzer_P_analyse_main_MODULENR_ROOT,(value P0,value P1));
_PROTOTYPE(extern int Manalyzer_P_analyse_rules_MODULENR,(value P0));
_PROTOTYPE(extern int Manalyzer_P_resolve_call_ahead_NODENR_RULENR,(value P0,value *P1));
_PROTOTYPE(extern int Manalyzer_P_warnings_on,());
_PROTOTYPE(extern int Mbitmap_P_new_BITMAP,(value *P0));
_PROTOTYPE(extern int Mbitmap_P_new_INT_BITMAP,(value P0,value *P1));
_PROTOTYPE(extern int Mbitmap_P_new_INT_INT_BITMAP,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mbitmap_P_exclude_BITMAP_BITMAP_BITMAP,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mbitmap_P_or_BITMAP_BITMAP_BITMAP,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mbitmap_P_and_BITMAP_BITMAP_BITMAP,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mbitmap_P_equal_BITMAP_BITMAP,(value P0,value P1));
_PROTOTYPE(extern int Mbitmap_P_is_set_BITMAP_INT,(value P0,value P1));
_PROTOTYPE(extern int Mbitmap_P_is_empty_BITMAP,(value P0));
_PROTOTYPE(extern int Mbitmap_P_clear_bit_BITMAP_INT_BITMAP,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mbitmap_P_set_bit_BITMAP_INT_BITMAP,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mbitmap_P_write_BITMAP,(value P0));
_PROTOTYPE(extern int Mrecursion_P_remove_right_recursion,());
_PROTOTYPE(extern int Mrecursion_P_remove_right_recursion_RULENR_LOCATION,(value P0,value P1));

/*
** CODE
*/

int Mtypes_P_propagate_types()
{
  value L2;
  value L1;
  value L0;
  L0 = C_INT(0);
  Mtypes_P_propagate_types_TYPENR(L0);
  L1 = C_INT(0);
  Mtypes_P_propagate_synonyms_TYPENR(L1);
  L2 = C_INT(0);
  Mtypes_P_check_all_types_TYPENR(L2);
  return 1;
}

int Mtypes_P_convert_MODULENR_TYPENAME_TYPENR(P0,P1,P2)
value P0;
value P1;
value *P2;
{
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  if (!Mtypes_P_exists_MODULENR_TYPENAME_TYPENR(L0,L1,&L2)) goto LAB1;
  *P2 = L2;
  return 1;
LAB1:
  Mtypes_P_create_MODULENR_TYPENAME_TYPENR(L0,L1,&L3);
  L4 = (value) Addr((value*)&G_types_FROM_NR3,Int(L3));
  *((value *)L4) = L3;
  L5 = G_types_TYPES_NR2896;
  L6 = (value) Addr((value*)&G_types_TYPES_NR2,Int(L3));
  ATTACH(L5);
if(DecrRefs(*((value*)L6))<0)
XD_Mtypes_T3(*((value*)L6));
  *((value *)L6) = L5;
  *P2 = L3;
  return 1;
}

int Mtypes_P_add_abstract_type_MODULENR_TYPENAME_TYPE_TYPENR(P0,P1,P2,P3)
value P0;
value P1;
value P2;
value *P3;
{
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = P2;
  if (!Mtypes_P_exists_MODULENR_TYPENAME_TYPENR(L0,L1,&L3)) goto LAB3;
  L4 = (value) Addr((value*)&G_types_TYPES_NR2,Int(L3));
  L5 = *((value*)L4);
  ATTACH(L5);
  switch (Alternative(L5)) {
  case 6: goto LAB4;
  default: goto LAB5;
  };
LAB4:
if(DecrRefs(L5)<0)
XD_Mtypes_T3(L5);
  Create(&L6,4,1);
  *(value *)(L6+1) = L2;
  ATTACH(L2);
if(DecrRefs(*((value*)L4))<0)
XD_Mtypes_T3(*((value*)L4));
  *((value *)L4) = L6;
  L7 = (value) Addr((value*)&G_types_FROM_NR3,Int(L3));
  *((value *)L7) = L3;
  *P3 = L3;
  return 1;
LAB5:
if(DecrRefs(L5)<0)
XD_Mtypes_T3(L5);
LAB6:
  L8 = (value) Addr((value*)&G_types_TYPES_NR2,Int(L3));
  L9 = *((value*)L8);
  ATTACH(L9);
  switch (Alternative(L9)) {
  case 3: goto LAB7;
  default: goto LAB8;
  };
LAB7:
if(DecrRefs(L9)<0)
XD_Mtypes_T3(L9);
  Create(&L10,2,1);
  Create(&L11,4,1);
  *(value *)(L11+1) = L2;
  ATTACH(L2);
  *(value *)(L10+1) = L11;
if(DecrRefs(*((value*)L8))<0)
XD_Mtypes_T3(*((value*)L8));
  *((value *)L8) = L10;
  L12 = (value) Addr((value*)&G_types_FROM_NR3,Int(L3));
  *((value *)L12) = L3;
  *P3 = L3;
  return 1;
LAB8:
if(DecrRefs(L9)<0)
XD_Mtypes_T3(L9);
LAB9:
  Create(&L13,4,2);
  *(value *)(L13+1) = L0;
  Create(&L14,6,2);
  L15 = G_types_TEXT_NR2897;
  *(value *)(L14+1) = L15;
  ATTACH(L15);
  Create(&L16,2,2);
  *(value *)(L16+1) = L3;
  Create(&L17,11,1);
  L18 = G_types_TEXT_NR2898;
  *(value *)(L17+1) = L18;
  ATTACH(L18);
  *(value *)(L16+2) = L17;
  *(value *)(L14+2) = L16;
  *(value *)(L13+2) = L14;
  Mtypes_P_type_error_MESSAGE(L13);
if(DecrRefs(L13)<0)
XD_Merrors_T3(L13);
  *P3 = L3;
  return 1;
LAB3:
  Mtypes_P_create_MODULENR_TYPENAME_TYPENR(L0,L1,&L19);
  Create(&L20,4,1);
  *(value *)(L20+1) = L2;
  ATTACH(L2);
  L21 = (value) Addr((value*)&G_types_TYPES_NR2,Int(L19));
if(DecrRefs(*((value*)L21))<0)
XD_Mtypes_T3(*((value*)L21));
  *((value *)L21) = L20;
  L22 = (value) Addr((value*)&G_types_FROM_NR3,Int(L19));
  *((value *)L22) = L19;
  *P3 = L19;
  return 1;
}

int Mtypes_P_add_external_type_MODULENR_TYPENAME_TYPENR(P0,P1,P2)
value P0;
value P1;
value *P2;
{
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  if (!Mtypes_P_exists_MODULENR_TYPENAME_TYPENR(L0,L1,&L2)) goto LAB11;
  L3 = (value) Addr((value*)&G_types_TYPES_NR2,Int(L2));
  L4 = *((value*)L3);
  ATTACH(L4);
  switch (Alternative(L4)) {
  case 6: goto LAB12;
  default: goto LAB13;
  };
LAB12:
if(DecrRefs(L4)<0)
XD_Mtypes_T3(L4);
  Create(&L5,5,1);
  L6 = G_types_TYPE_NR2899;
  *(value *)(L5+1) = L6;
  ATTACH(L6);
if(DecrRefs(*((value*)L3))<0)
XD_Mtypes_T3(*((value*)L3));
  *((value *)L3) = L5;
  L7 = (value) Addr((value*)&G_types_FROM_NR3,Int(L2));
  *((value *)L7) = L2;
  *P2 = L2;
  return 1;
LAB13:
if(DecrRefs(L4)<0)
XD_Mtypes_T3(L4);
LAB14:
  L8 = (value) Addr((value*)&G_types_TYPES_NR2,Int(L2));
  L9 = *((value*)L8);
  ATTACH(L9);
  switch (Alternative(L9)) {
  case 3: goto LAB15;
  default: goto LAB16;
  };
LAB15:
if(DecrRefs(L9)<0)
XD_Mtypes_T3(L9);
  Create(&L10,2,1);
  Create(&L11,5,1);
  L12 = G_types_TYPE_NR2900;
  *(value *)(L11+1) = L12;
  ATTACH(L12);
  *(value *)(L10+1) = L11;
if(DecrRefs(*((value*)L8))<0)
XD_Mtypes_T3(*((value*)L8));
  *((value *)L8) = L10;
  L13 = (value) Addr((value*)&G_types_FROM_NR3,Int(L2));
  *((value *)L13) = L2;
  *P2 = L2;
  return 1;
LAB16:
if(DecrRefs(L9)<0)
XD_Mtypes_T3(L9);
LAB17:
  Create(&L14,4,2);
  *(value *)(L14+1) = L0;
  Create(&L15,6,2);
  L16 = G_types_TEXT_NR2901;
  *(value *)(L15+1) = L16;
  ATTACH(L16);
  Create(&L17,2,2);
  *(value *)(L17+1) = L2;
  Create(&L18,11,1);
  L19 = G_types_TEXT_NR2902;
  *(value *)(L18+1) = L19;
  ATTACH(L19);
  *(value *)(L17+2) = L18;
  *(value *)(L15+2) = L17;
  *(value *)(L14+2) = L15;
  Mtypes_P_type_error_MESSAGE(L14);
if(DecrRefs(L14)<0)
XD_Merrors_T3(L14);
  *P2 = L2;
  return 1;
LAB11:
  Mtypes_P_create_MODULENR_TYPENAME_TYPENR(L0,L1,&L20);
  Create(&L21,5,1);
  L22 = G_types_TYPE_NR2903;
  *(value *)(L21+1) = L22;
  ATTACH(L22);
  L23 = (value) Addr((value*)&G_types_TYPES_NR2,Int(L20));
if(DecrRefs(*((value*)L23))<0)
XD_Mtypes_T3(*((value*)L23));
  *((value *)L23) = L21;
  L24 = (value) Addr((value*)&G_types_FROM_NR3,Int(L20));
  *((value *)L24) = L20;
  *P2 = L20;
  return 1;
}

int Mtypes_P_add_type_MODULENR_TYPENAME_TYPE_TYPENR(P0,P1,P2,P3)
value P0;
value P1;
value P2;
value *P3;
{
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = P2;
  if (!Mtypes_P_exists_MODULENR_TYPENAME_TYPENR(L0,L1,&L3)) goto LAB19;
  L4 = (value) Addr((value*)&G_types_TYPES_NR2,Int(L3));
  L5 = *((value*)L4);
  ATTACH(L5);
  switch (Alternative(L5)) {
  case 6: goto LAB20;
  default: goto LAB21;
  };
LAB20:
if(DecrRefs(L5)<0)
XD_Mtypes_T3(L5);
  Create(&L6,5,1);
  *(value *)(L6+1) = L2;
  ATTACH(L2);
if(DecrRefs(*((value*)L4))<0)
XD_Mtypes_T3(*((value*)L4));
  *((value *)L4) = L6;
  L7 = (value) Addr((value*)&G_types_FROM_NR3,Int(L3));
  *((value *)L7) = L3;
  *P3 = L3;
  return 1;
LAB21:
if(DecrRefs(L5)<0)
XD_Mtypes_T3(L5);
LAB22:
  L8 = (value) Addr((value*)&G_types_TYPES_NR2,Int(L3));
  L9 = *((value*)L8);
  ATTACH(L9);
  switch (Alternative(L9)) {
  case 3: goto LAB23;
  default: goto LAB24;
  };
LAB23:
if(DecrRefs(L9)<0)
XD_Mtypes_T3(L9);
  Create(&L10,2,1);
  Create(&L11,5,1);
  *(value *)(L11+1) = L2;
  ATTACH(L2);
  *(value *)(L10+1) = L11;
if(DecrRefs(*((value*)L8))<0)
XD_Mtypes_T3(*((value*)L8));
  *((value *)L8) = L10;
  L12 = (value) Addr((value*)&G_types_FROM_NR3,Int(L3));
  *((value *)L12) = L3;
  *P3 = L3;
  return 1;
LAB24:
if(DecrRefs(L9)<0)
XD_Mtypes_T3(L9);
LAB25:
  Create(&L13,4,2);
  *(value *)(L13+1) = L0;
  Create(&L14,6,2);
  L15 = G_types_TEXT_NR2904;
  *(value *)(L14+1) = L15;
  ATTACH(L15);
  Create(&L16,2,2);
  *(value *)(L16+1) = L3;
  Create(&L17,11,1);
  L18 = G_types_TEXT_NR2905;
  *(value *)(L17+1) = L18;
  ATTACH(L18);
  *(value *)(L16+2) = L17;
  *(value *)(L14+2) = L16;
  *(value *)(L13+2) = L14;
  Mtypes_P_type_error_MESSAGE(L13);
if(DecrRefs(L13)<0)
XD_Merrors_T3(L13);
  *P3 = L3;
  return 1;
LAB19:
  Mtypes_P_create_MODULENR_TYPENAME_TYPENR(L0,L1,&L19);
  Create(&L20,5,1);
  *(value *)(L20+1) = L2;
  ATTACH(L2);
  L21 = (value) Addr((value*)&G_types_TYPES_NR2,Int(L19));
if(DecrRefs(*((value*)L21))<0)
XD_Mtypes_T3(*((value*)L21));
  *((value *)L21) = L20;
  L22 = (value) Addr((value*)&G_types_FROM_NR3,Int(L19));
  *((value *)L22) = L19;
  *P3 = L19;
  return 1;
}

int Mtypes_P_add_synonym_MODULENR_TYPENAME_TYPENR_TYPENR(P0,P1,P2,P3)
value P0;
value P1;
value P2;
value *P3;
{
  value L25;
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = P2;
  if (!Mtypes_P_exists_MODULENR_TYPENAME_TYPENR(L0,L1,&L3)) goto LAB27;
  L4 = (value) Addr((value*)&G_types_TYPES_NR2,Int(L3));
  L5 = *((value*)L4);
  ATTACH(L5);
  switch (Alternative(L5)) {
  case 6: goto LAB28;
  default: goto LAB29;
  };
LAB28:
if(DecrRefs(L5)<0)
XD_Mtypes_T3(L5);
  Create(&L6,5,1);
  Create(&L7,1,1);
  *(value *)(L7+1) = L2;
  *(value *)(L6+1) = L7;
if(DecrRefs(*((value*)L4))<0)
XD_Mtypes_T3(*((value*)L4));
  *((value *)L4) = L6;
  L8 = (value) Addr((value*)&G_types_FROM_NR3,Int(L3));
  *((value *)L8) = L3;
  *P3 = L3;
  return 1;
LAB29:
if(DecrRefs(L5)<0)
XD_Mtypes_T3(L5);
LAB30:
  L9 = (value) Addr((value*)&G_types_TYPES_NR2,Int(L3));
  L10 = *((value*)L9);
  ATTACH(L10);
  switch (Alternative(L10)) {
  case 3: goto LAB31;
  default: goto LAB32;
  };
LAB31:
if(DecrRefs(L10)<0)
XD_Mtypes_T3(L10);
  Create(&L11,2,1);
  Create(&L12,5,1);
  Create(&L13,1,1);
  *(value *)(L13+1) = L2;
  *(value *)(L12+1) = L13;
  *(value *)(L11+1) = L12;
if(DecrRefs(*((value*)L9))<0)
XD_Mtypes_T3(*((value*)L9));
  *((value *)L9) = L11;
  L14 = (value) Addr((value*)&G_types_FROM_NR3,Int(L3));
  *((value *)L14) = L3;
  *P3 = L3;
  return 1;
LAB32:
if(DecrRefs(L10)<0)
XD_Mtypes_T3(L10);
LAB33:
  Create(&L15,4,2);
  *(value *)(L15+1) = L0;
  Create(&L16,6,2);
  L17 = G_types_TEXT_NR2906;
  *(value *)(L16+1) = L17;
  ATTACH(L17);
  Create(&L18,2,2);
  *(value *)(L18+1) = L3;
  Create(&L19,11,1);
  L20 = G_types_TEXT_NR2907;
  *(value *)(L19+1) = L20;
  ATTACH(L20);
  *(value *)(L18+2) = L19;
  *(value *)(L16+2) = L18;
  *(value *)(L15+2) = L16;
  Mtypes_P_type_error_MESSAGE(L15);
if(DecrRefs(L15)<0)
XD_Merrors_T3(L15);
  *P3 = L3;
  return 1;
LAB27:
  Mtypes_P_create_MODULENR_TYPENAME_TYPENR(L0,L1,&L21);
  Create(&L22,5,1);
  Create(&L23,1,1);
  *(value *)(L23+1) = L2;
  *(value *)(L22+1) = L23;
  L24 = (value) Addr((value*)&G_types_TYPES_NR2,Int(L21));
if(DecrRefs(*((value*)L24))<0)
XD_Mtypes_T3(*((value*)L24));
  *((value *)L24) = L22;
  L25 = (value) Addr((value*)&G_types_FROM_NR3,Int(L21));
  *((value *)L25) = L21;
  *P3 = L21;
  return 1;
}

int Mtypes_P_export_type_MODULENR_TYPENAME_TYPENR(P0,P1,P2)
value P0;
value P1;
value *P2;
{
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  if (!Mtypes_P_exists_MODULENR_TYPENAME_TYPENR(L0,L1,&L2)) goto LAB35;
  L3 = (value) Addr((value*)&G_types_TYPES_NR2,Int(L2));
  L4 = *((value*)L3);
  ATTACH(L4);
  switch (Alternative(L4)) {
  case 6: goto LAB36;
  default: goto LAB37;
  };
LAB36:
if(DecrRefs(L4)<0)
XD_Mtypes_T3(L4);
  L5 = G_types_TYPES_NR2908;
  ATTACH(L5);
if(DecrRefs(*((value*)L3))<0)
XD_Mtypes_T3(*((value*)L3));
  *((value *)L3) = L5;
  *P2 = L2;
  return 1;
LAB37:
if(DecrRefs(L4)<0)
XD_Mtypes_T3(L4);
LAB38:
  L6 = (value) Addr((value*)&G_types_TYPES_NR2,Int(L2));
  L7 = *((value*)L6);
  ATTACH(L7);
  switch (Alternative(L7)) {
  case 2: goto LAB39;
  default: goto LAB40;
  };
LAB39:
  L8 = (value)(L7[1]);
if(DecrRefs(L7)<0)
XD_Mtypes_T3(L7);
  Create(&L9,4,2);
  *(value *)(L9+1) = L0;
  Create(&L10,6,2);
  L11 = G_types_TEXT_NR2909;
  *(value *)(L10+1) = L11;
  ATTACH(L11);
  Create(&L12,2,2);
  *(value *)(L12+1) = L2;
  Create(&L13,11,1);
  L14 = G_types_TEXT_NR2910;
  *(value *)(L13+1) = L14;
  ATTACH(L14);
  *(value *)(L12+2) = L13;
  *(value *)(L10+2) = L12;
  *(value *)(L9+2) = L10;
  Mtypes_P_type_error_MESSAGE(L9);
if(DecrRefs(L9)<0)
XD_Merrors_T3(L9);
  *P2 = L2;
  return 1;
LAB40:
if(DecrRefs(L7)<0)
XD_Mtypes_T3(L7);
  Abort(178, module_name);
  Abort(178, module_name);
LAB35:
  Mtypes_P_create_MODULENR_TYPENAME_TYPENR(L0,L1,&L15);
  L16 = G_types_TYPES_NR2911;
  L17 = (value) Addr((value*)&G_types_TYPES_NR2,Int(L15));
  ATTACH(L16);
if(DecrRefs(*((value*)L17))<0)
XD_Mtypes_T3(*((value*)L17));
  *((value *)L17) = L16;
  L18 = (value) Addr((value*)&G_types_FROM_NR3,Int(L15));
  *((value *)L18) = L15;
  *P2 = L15;
  return 1;
}

int Mtypes_P_is_imported_abstract_type_TYPENR(P0)
value P0;
{
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = (value) Addr((value*)&G_types_TYPES_NR2,Int(L0));
  L2 = *((value*)L1);
  switch (Alternative(L2)) {
  case 0: goto LAB42;
  default: goto LAB44;
  };
LAB42:
  L3 = (value)(L2[1]);
  switch (Alternative(L3)) {
  case 4: goto LAB45;
  default: goto LAB44;
  };
LAB45:
  L4 = (value)(L3[1]);
  return 1;
LAB44:
  return 0;
}

int Mtypes_P_is_abstract_type_TYPENR_TYPE(P0,P1)
value P0;
value *P1;
{
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = (value) Addr((value*)&G_types_TYPES_NR2,Int(L0));
  L2 = *((value*)L1);
  L4 = L2;
LAB351:
  switch (Alternative(L4)) {
  case 0: goto LAB352;
  case 2: goto LAB357;
  case 1: goto LAB362;
  case 4: goto LAB367;
  default: goto LAB49;
  };
LAB352:
  L5 = (value)(L4[1]);
  L4 = L5;
  goto LAB351;
LAB357:
  L7 = (value)(L4[1]);
  L4 = L7;
  goto LAB351;
LAB362:
  L9 = (value)(L4[1]);
  L4 = L9;
  goto LAB351;
LAB367:
  L11 = (value)(L4[1]);
  L3 = L11;
  ATTACH(L11);
LAB350:
  *P1 = L3;
  return 1;
LAB49:
  return 0;
}

int Mtypes_P_is_special_type_TYPENR_STYPE(P0,P1)
value P0;
value *P1;
{
  value L26;
  value L25;
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = (value) Addr((value*)&G_types_FROM_NR3,Int(L0));
  L2 = *((value*)L1);
  L3 = (value)G_types_INT_TYPENR_NR6;
  if (!(L2 == L3)) goto LAB51;
  L4 = G_types_STYPE_NR2912;
  *P1 = L4;
  ATTACH(L4);
  return 1;
LAB51:
  L5 = (value) Addr((value*)&G_types_FROM_NR3,Int(L0));
  L6 = *((value*)L5);
  L7 = (value)G_types_TEXT_TYPENR_NR7;
  if (!(L6 == L7)) goto LAB53;
  L8 = G_types_STYPE_NR2913;
  *P1 = L8;
  ATTACH(L8);
  return 1;
LAB53:
  L9 = (value) Addr((value*)&G_types_FROM_NR3,Int(L0));
  L10 = *((value*)L9);
  L11 = (value)G_types_REAL_TYPENR_NR8;
  if (!(L10 == L11)) goto LAB55;
  L12 = G_types_STYPE_NR2914;
  *P1 = L12;
  ATTACH(L12);
  return 1;
LAB55:
  L14 = L0;
  L15 = (value) Addr((value*)&G_types_TYPES_NR2,Int(L14));
  L16 = *((value*)L15);
  L18 = L16;
LAB396:
  switch (Alternative(L18)) {
  case 6: goto LAB397;
  case 5: goto LAB401;
  case 2: goto LAB407;
  case 1: goto LAB413;
  case 3: goto LAB418;
  default: goto LAB57;
  };
LAB397:
  L19 = G_types_TYPE_NR2921;
  L17 = L19;
  ATTACH(L19);
  goto LAB399;
LAB401:
  L20 = (value)(L18[1]);
  switch (Alternative(L20)) {
  case 2: goto LAB403;
  default: goto LAB57;
  };
LAB403:
  L21 = G_types_TYPE_NR2922;
  L17 = L21;
  ATTACH(L21);
  goto LAB399;
LAB407:
  L22 = (value)(L18[1]);
  L18 = L22;
  goto LAB396;
LAB413:
  L24 = (value)(L18[1]);
  L18 = L24;
  goto LAB396;
LAB418:
  L26 = G_types_TYPE_NR2923;
  L17 = L26;
  ATTACH(L26);
LAB399:
if(DecrRefs(L17)<0)
XD_Mtypes_T11(L17);
LAB395:
  L13 = G_types_STYPE_NR2915;
  *P1 = L13;
  ATTACH(L13);
  return 1;
LAB57:
  return 0;
}

int Mtypes_P_is_external_type_TYPENR(P0)
value P0;
{
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = (value) Addr((value*)&G_types_TYPES_NR2,Int(L0));
  L2 = *((value*)L1);
  L4 = L2;
LAB372:
  switch (Alternative(L4)) {
  case 6: goto LAB373;
  case 5: goto LAB376;
  case 2: goto LAB382;
  case 1: goto LAB387;
  case 3: goto LAB392;
  default: goto LAB59;
  };
LAB373:
  L5 = G_types_TYPE_NR2921;
  L3 = L5;
  ATTACH(L5);
  goto LAB371;
LAB376:
  L6 = (value)(L4[1]);
  switch (Alternative(L6)) {
  case 2: goto LAB378;
  default: goto LAB59;
  };
LAB378:
  L7 = G_types_TYPE_NR2922;
  L3 = L7;
  ATTACH(L7);
  goto LAB371;
LAB382:
  L8 = (value)(L4[1]);
  L4 = L8;
  goto LAB372;
LAB387:
  L10 = (value)(L4[1]);
  L4 = L10;
  goto LAB372;
LAB392:
  L12 = G_types_TYPE_NR2923;
  L3 = L12;
  ATTACH(L12);
LAB371:
if(DecrRefs(L3)<0)
XD_Mtypes_T11(L3);
  return 1;
LAB59:
  return 0;
}

int Mtypes_P_is_integer_type_TYPENR(P0)
value P0;
{
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = (value)G_types_INT_TYPENR_NR6;
  L2 = L0;
  L3 = L1;
  L4 = (value) Addr((value*)&G_types_FROM_NR3,Int(L2));
  L5 = *((value*)L4);
  L6 = (value) Addr((value*)&G_types_FROM_NR3,Int(L3));
  L7 = *((value*)L6);
  if (!(L5 == L7)) goto LAB61;
  return 1;
  return 1;
LAB61:
  return 0;
}

int Mtypes_P_is_undefined_type_TYPENR(P0)
value P0;
{
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = (value) Addr((value*)&G_types_TYPES_NR2,Int(L0));
  L2 = *((value*)L1);
  L3 = L2;
LAB427:
  switch (Alternative(L3)) {
  case 6: goto LAB426;
  case 5: goto LAB431;
  case 3: goto LAB426;
  case 0: goto LAB440;
  case 2: goto LAB445;
  case 1: goto LAB450;
  default: goto LAB63;
  };
LAB431:
  L4 = (value)(L3[1]);
  switch (Alternative(L4)) {
  case 2: goto LAB426;
  default: goto LAB63;
  };
LAB440:
  L5 = (value)(L3[1]);
  L3 = L5;
  goto LAB427;
LAB445:
  L6 = (value)(L3[1]);
  L3 = L6;
  goto LAB427;
LAB450:
  L7 = (value)(L3[1]);
  L3 = L7;
  goto LAB427;
LAB426:
  return 1;
LAB63:
  return 0;
}

int Mtypes_P_is_exported_type_TYPENR(P0)
value P0;
{
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = (value) Addr((value*)&G_types_TYPES_NR2,Int(L0));
  L2 = *((value*)L1);
  switch (Alternative(L2)) {
  case 2: goto LAB64;
  default: goto LAB66;
  };
LAB64:
  L3 = (value)(L2[1]);
  return 1;
LAB66:
  return 0;
}

int Mtypes_P_same_TYPE_TYPENR(P0,P1)
value P0;
value *P1;
{
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  switch (Alternative(L0)) {
  case 0: goto LAB67;
  case 1: goto LAB79;
  default: goto LAB81;
  };
LAB67:
  L1 = (value)(L0[1]);
  switch (Alternative(L1)) {
  case 1: goto LAB70;
  default: goto LAB81;
  };
LAB70:
  L2 = (value)(L1[1]);
  L3 = (value)(L1[2]);
  switch (Alternative(L3)) {
  case 2: goto LAB73;
  default: goto LAB81;
  };
LAB73:
  L4 = (value)(L0[2]);
  switch (Alternative(L4)) {
  case 2: goto LAB76;
  default: goto LAB81;
  };
LAB76:
  *P1 = L2;
  return 1;
LAB79:
  L5 = (value)(L0[1]);
  *P1 = L5;
  return 1;
LAB81:
  return 0;
}

int Mtypes_P_same_TYPENR_TYPENR(P0,P1)
value P0;
value *P1;
{
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
LAB479:
  L1 = (value) Addr((value*)&G_types_FROM_NR3,Int(L0));
  L2 = *((value*)L1);
  if (!(L2 == L0)) goto LAB83;
  L7 = L0;
  L8 = (value) Addr((value*)&G_types_FROM_NR3,Int(L7));
  L9 = *((value*)L8);
  L10 = (value) Addr((value*)&G_types_TYPES_NR2,Int(L9));
  L11 = *((value*)L10);
  L13 = L11;
LAB456:
  switch (Alternative(L13)) {
  case 5: goto LAB457;
  case 0: goto LAB461;
  case 2: goto LAB464;
  case 1: goto LAB467;
  case 4: goto LAB470;
  case 6: goto LAB473;
  case 3: goto LAB476;
  default: goto LAB478;
  };
LAB457:
  L14 = (value)(L13[1]);
  L12 = L14;
  ATTACH(L14);
  goto LAB459;
LAB461:
  L15 = (value)(L13[1]);
  L13 = L15;
  goto LAB456;
LAB464:
  L17 = (value)(L13[1]);
  L13 = L17;
  goto LAB456;
LAB467:
  L19 = (value)(L13[1]);
  L13 = L19;
  goto LAB456;
LAB470:
  L21 = (value)(L13[1]);
  L12 = L21;
  ATTACH(L21);
  goto LAB459;
LAB473:
  L22 = G_types_TYPE_NR2924;
  L12 = L22;
  ATTACH(L22);
  goto LAB459;
LAB476:
  L23 = G_types_TYPE_NR2925;
  L12 = L23;
  ATTACH(L23);
LAB459:
  L3 = L12;
LAB455:
  if (!Mtypes_P_same_TYPE_TYPENR(L3,&L4)) goto LAB85;
if(DecrRefs(L3)<0)
XD_Mtypes_T11(L3);
  L0 = L4;
  goto LAB479;
LAB478:
  Abort(269, module_name);
LAB85:
if(DecrRefs(L3)<0)
XD_Mtypes_T11(L3);
  *P1 = L2;
  return 1;
LAB83:
  L0 = L2;
  goto LAB479;
}

int Mtypes_P_integer_type_TYPENR(P0)
value *P0;
{
  value L0;
  L0 = (value)G_types_INT_TYPENR_NR6;
  *P0 = L0;
  return 1;
}

int Mtypes_P_is_text_type_TYPENR(P0)
value P0;
{
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = (value)G_types_TEXT_TYPENR_NR7;
  L2 = L0;
  L3 = L1;
  L4 = (value) Addr((value*)&G_types_FROM_NR3,Int(L2));
  L5 = *((value*)L4);
  L6 = (value) Addr((value*)&G_types_FROM_NR3,Int(L3));
  L7 = *((value*)L6);
  if (!(L5 == L7)) goto LAB87;
  return 1;
  return 1;
LAB87:
  return 0;
}

int Mtypes_P_text_type_TYPENR(P0)
value *P0;
{
  value L0;
  L0 = (value)G_types_TEXT_TYPENR_NR7;
  *P0 = L0;
  return 1;
}

int Mtypes_P_equal_types_TYPENR_TYPENR(P0,P1)
value P0;
value P1;
{
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = (value) Addr((value*)&G_types_FROM_NR3,Int(L0));
  L3 = *((value*)L2);
  L4 = (value) Addr((value*)&G_types_FROM_NR3,Int(L1));
  L5 = *((value*)L4);
  if (!(L3 == L5)) goto LAB89;
  return 1;
LAB89:
  return 0;
}

int Mtypes_P_get_TYPENR_TYPE(P0,P1)
value P0;
value *P1;
{
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = (value) Addr((value*)&G_types_FROM_NR3,Int(L0));
  L2 = *((value*)L1);
  L3 = (value) Addr((value*)&G_types_TYPES_NR2,Int(L2));
  L4 = *((value*)L3);
  L6 = L4;
LAB254:
  switch (Alternative(L6)) {
  case 5: goto LAB255;
  case 0: goto LAB258;
  case 2: goto LAB261;
  case 1: goto LAB264;
  case 4: goto LAB267;
  case 6: goto LAB270;
  case 3: goto LAB273;
  default: goto LAB275;
  };
LAB255:
  L7 = (value)(L6[1]);
  L5 = L7;
  ATTACH(L7);
  goto LAB253;
LAB258:
  L8 = (value)(L6[1]);
  L6 = L8;
  goto LAB254;
LAB261:
  L10 = (value)(L6[1]);
  L6 = L10;
  goto LAB254;
LAB264:
  L12 = (value)(L6[1]);
  L6 = L12;
  goto LAB254;
LAB267:
  L14 = (value)(L6[1]);
  L5 = L14;
  ATTACH(L14);
  goto LAB253;
LAB270:
  L15 = G_types_TYPE_NR2924;
  L5 = L15;
  ATTACH(L15);
  goto LAB253;
LAB273:
  L16 = G_types_TYPE_NR2925;
  L5 = L16;
  ATTACH(L16);
LAB253:
  *P1 = L5;
  return 1;
LAB275:
  Abort(269, module_name);
}

int Mtypes_P_get_TYPENR_TYPENAME_MODULENR(P0,P1,P2)
value P0;
value *P1;
value *P2;
{
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = (value) Addr((value*)&G_types_TYPENAMES_NR1,Int(L0));
  L2 = *((value*)L1);
  L3 = (value)(L2[1]);
  L4 = (value)(L2[2]);
  *P2 = L4;
  *P1 = L3;
  ATTACH(L3);
  return 1;
}

int Mtypes_P_get_TYPENR_MODULENR_ID(P0,P1,P2)
value P0;
value *P1;
value *P2;
{
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = (value) Addr((value*)&G_types_FROM_NR3,Int(L0));
  L2 = *((value*)L1);
  L3 = (value) Addr((value*)&G_types_TYPENAMES_NR1,Int(L2));
  L4 = *((value*)L3);
  L5 = (value)(L4[1]);
  L6 = (value)(L4[2]);
  L7 = *((value*)L1);
  L8 = (value) Addr((value*)&G_types_IDS_NR4,Int(L7));
  L9 = *((value*)L8);
  *P2 = L9;
  *P1 = L6;
  return 1;
}

int Mtypes_P_first_TYPENR(P0)
value *P0;
{
  value L1;
  value L0;
  L0 = (value)G_types_NR_OF_TYPES_NR5;
  switch (Int(L0)) {
  case 0: goto LAB90;
  default: goto LAB92;
  };
LAB90:
  return 0;
LAB92:
  L1 = C_INT(0);
  *P0 = L1;
  return 1;
}

int Mtypes_P_next_TYPENR(P0)
value *P0;
{
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = *P0;
  L1 = C_INT(1);
  L2 = C_INT(Int(L0) + Int(L1));
  L3 = (value)G_types_NR_OF_TYPES_NR5;
  if (!(L2 == L3)) goto LAB94;
  return 0;
LAB94:
  *P0 = L2;
  return 1;
}

int Mtypes_P_error_TYPENR(P0)
value P0;
{
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = (value) Addr((value*)&G_types_TYPENAMES_NR1,Int(L0));
  L2 = *((value*)L1);
  L3 = (value)(L2[1]);
  L4 = (value)(L2[2]);
  Merrors_P_error_text_TEXT(L3);
  return 1;
}

int Mtypes_P_build_type_TYPENR_TEXT(P0,P1)
value P0;
value *P1;
{
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L3 = L0;
  L4 = (value) Addr((value*)&G_types_FROM_NR3,Int(L3));
  L5 = *((value*)L4);
  L6 = (value) Addr((value*)&G_types_TYPES_NR2,Int(L5));
  L7 = *((value*)L6);
  L9 = L7;
LAB484:
  switch (Alternative(L9)) {
  case 5: goto LAB485;
  case 0: goto LAB489;
  case 2: goto LAB492;
  case 1: goto LAB495;
  case 4: goto LAB498;
  case 6: goto LAB501;
  case 3: goto LAB504;
  default: goto LAB506;
  };
LAB485:
  L10 = (value)(L9[1]);
  L8 = L10;
  ATTACH(L10);
  goto LAB487;
LAB489:
  L11 = (value)(L9[1]);
  L9 = L11;
  goto LAB484;
LAB492:
  L13 = (value)(L9[1]);
  L9 = L13;
  goto LAB484;
LAB495:
  L15 = (value)(L9[1]);
  L9 = L15;
  goto LAB484;
LAB498:
  L17 = (value)(L9[1]);
  L8 = L17;
  ATTACH(L17);
  goto LAB487;
LAB501:
  L18 = G_types_TYPE_NR2924;
  L8 = L18;
  ATTACH(L18);
  goto LAB487;
LAB504:
  L19 = G_types_TYPE_NR2925;
  L8 = L19;
  ATTACH(L19);
LAB487:
  L1 = L8;
LAB483:
  Mtypes_P_build_type_TYPE_TEXT(L1,&L2);
if(DecrRefs(L1)<0)
XD_Mtypes_T11(L1);
  *P1 = L2;
  return 1;
LAB506:
  Abort(269, module_name);
}

int Mtypes_P_type_errors()
{
  value L0;
  L0 = G_types_ERRORS_NR9;
  switch (Alternative(L0)) {
  case 0: goto LAB95;
  default: goto LAB97;
  };
LAB95:
  return 1;
LAB97:
  return 0;
}

int Mtypes_P_init_type_table()
{
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  Mmodules_P_init_modules();
  L0 = C_INT(0);
  G_types_NR_OF_TYPES_NR5 = (long)L0;
  L1 = G_types_ERRORS_NR2916;
  ATTACH(L1);
if(DecrRefs(G_types_ERRORS_NR9)<0)
XD_Mtypes_T10(G_types_ERRORS_NR9);
  G_types_ERRORS_NR9 = L1;
  L2 = C_INT(1024);
  L9 = L2;
LAB509:
  switch (Int(L9)) {
  case 0: goto LAB508;
  default: goto LAB512;
  };
LAB512:
  L10 = C_INT(1);
  L11 = C_INT(Int(L9) - Int(L10));
  L12 = G_types_TYPENRLIST_NR2920;
  L13 = (value) Addr((value*)&G_types_HASHEDTYPENAMES_NR0,Int(L11));
  ATTACH(L12);
if(DecrRefs(*((value*)L13))<0)
XD_Mtypes_T49(*((value*)L13));
  *((value *)L13) = L12;
  L9 = L11;
  goto LAB509;
LAB508:
  L3 = C_INT(0);
  L4 = G_types_TEXT_NR2917;
  Mtypes_P_convert_MODULENR_TYPENAME_TYPENR(L3,L4,&L5);
  G_types_INT_TYPENR_NR6 = (long)L5;
  L6 = C_INT(0);
  L7 = G_types_TEXT_NR2918;
  Mtypes_P_convert_MODULENR_TYPENAME_TYPENR(L6,L7,&L8);
  G_types_TEXT_TYPENR_NR7 = (long)L8;
  return 1;
}

int Mtypes_P_type_error_MESSAGE(P0)
value P0;
{
  value L1;
  value L0;
  L0 = P0;
  L1 = G_types_ERRORS_NR2919;
  ATTACH(L1);
if(DecrRefs(G_types_ERRORS_NR9)<0)
XD_Mtypes_T10(G_types_ERRORS_NR9);
  G_types_ERRORS_NR9 = L1;
  Merrors_P_error_MESSAGE(L0);
  return 1;
}

int Mtypes_P_hash_TYPENAME_INDEX(P0,P1)
value P0;
value *P1;
{
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = C_INT(1024);
  E70_hash_TEXT_INT_INT(L0,L1,&L2);
  *P1 = L2;
  return 1;
}

int Mtypes_P_init_hash_table_INDEX(P0)
value P0;
{
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
LAB507:
  switch (Int(L0)) {
  case 0: goto LAB98;
  default: goto LAB100;
  };
LAB98:
  return 1;
LAB100:
  L1 = C_INT(1);
  L2 = C_INT(Int(L0) - Int(L1));
  L3 = G_types_TYPENRLIST_NR2920;
  L4 = (value) Addr((value*)&G_types_HASHEDTYPENAMES_NR0,Int(L2));
  ATTACH(L3);
if(DecrRefs(*((value*)L4))<0)
XD_Mtypes_T49(*((value*)L4));
  *((value *)L4) = L3;
  L0 = L2;
  goto LAB507;
}

int Mtypes_P_create_MODULENR_TYPENAME_TYPENR(P0,P1,P2)
value P0;
value P1;
value *P2;
{
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  Mtypes_P_hash_TYPENAME_INDEX(L1,&L2);
  L3 = (value)G_types_NR_OF_TYPES_NR5;
  L4 = (value)G_types_NR_OF_TYPES_NR5;
  L5 = C_INT(1);
  L6 = C_INT(Int(L4) + Int(L5));
  G_types_NR_OF_TYPES_NR5 = (long)L6;
  Mmodules_P_new_id_MODULENR_ID(L0,&L7);
  L8 = (value) Addr((value*)&G_types_IDS_NR4,Int(L3));
  *((value *)L8) = L7;
  Create(&L9,0,2);
  *(value *)(L9+1) = L1;
  ATTACH(L1);
  *(value *)(L9+2) = L0;
  L10 = (value) Addr((value*)&G_types_TYPENAMES_NR1,Int(L3));
if(DecrRefs(*((value*)L10))<0)
XD_Mtypes_T2(*((value*)L10));
  *((value *)L10) = L9;
  Create(&L11,0,2);
  *(value *)(L11+1) = L3;
  L12 = (value) Addr((value*)&G_types_HASHEDTYPENAMES_NR0,Int(L2));
  L13 = *((value*)L12);
  ATTACH(L13);
  *(value *)(L11+2) = L13;
if(DecrRefs(*((value*)L12))<0)
XD_Mtypes_T49(*((value*)L12));
  *((value *)L12) = L11;
  *P2 = L3;
  return 1;
}

int Mtypes_P_in_MODULENR_TYPENAME_TYPENRLIST_TYPENR(P0,P1,P2,P3)
value P0;
value P1;
value P2;
value *P3;
{
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = P2;
LAB304:
  switch (Alternative(L2)) {
  case 0: goto LAB101;
  default: goto LAB103;
  };
LAB101:
  L3 = (value)(L2[1]);
  L4 = (value)(L2[2]);
  L5 = (value) Addr((value*)&G_types_TYPENAMES_NR1,Int(L3));
  L6 = *((value*)L5);
  L7 = (value)(L6[1]);
  L8 = (value)(L6[2]);
  if (!EQ_TEXT(L1,L7)) goto LAB105;
  if (!(L0 == L8)) goto LAB105;
  *P3 = L3;
  return 1;
LAB105:
  L2 = L4;
  goto LAB304;
  return 0;
LAB103:
  return 0;
}

int Mtypes_P_exists_MODULENR_TYPENAME_TYPENR(P0,P1,P2)
value P0;
value P1;
value *P2;
{
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  Mtypes_P_hash_TYPENAME_INDEX(L1,&L2);
  L3 = (value) Addr((value*)&G_types_HASHEDTYPENAMES_NR0,Int(L2));
  L4 = *((value*)L3);
  L6 = L0;
  L7 = L1;
  L8 = L4;
LAB306:
  switch (Alternative(L8)) {
  case 0: goto LAB307;
  default: goto LAB111;
  };
LAB307:
  L9 = (value)(L8[1]);
  L10 = (value)(L8[2]);
  L11 = (value) Addr((value*)&G_types_TYPENAMES_NR1,Int(L9));
  L12 = *((value*)L11);
  L13 = (value)(L12[1]);
  L14 = (value)(L12[2]);
  if (!EQ_TEXT(L7,L13)) goto LAB312;
  if (!(L6 == L14)) goto LAB312;
  L5 = L9;
LAB305:
  *P2 = L5;
  return 1;
LAB312:
  L8 = L10;
  goto LAB306;
LAB111:
  return 0;
}

int Mtypes_P_is_abstract_type_TYPES_TYPE(P0,P1)
value P0;
value *P1;
{
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
LAB349:
  switch (Alternative(L0)) {
  case 0: goto LAB112;
  case 2: goto LAB117;
  case 1: goto LAB122;
  case 4: goto LAB127;
  default: goto LAB129;
  };
LAB112:
  L1 = (value)(L0[1]);
  L0 = L1;
  goto LAB349;
  return 0;
LAB117:
  L3 = (value)(L0[1]);
  L0 = L3;
  goto LAB349;
  return 0;
LAB122:
  L5 = (value)(L0[1]);
  L0 = L5;
  goto LAB349;
  return 0;
LAB127:
  L7 = (value)(L0[1]);
  *P1 = L7;
  ATTACH(L7);
  return 1;
LAB129:
  return 0;
}

int Mtypes_P_is_undefined_type_TYPES(P0)
value P0;
{
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
LAB425:
  switch (Alternative(L0)) {
  case 6: goto LAB130;
  case 5: goto LAB133;
  case 3: goto LAB139;
  case 0: goto LAB142;
  case 2: goto LAB147;
  case 1: goto LAB152;
  default: goto LAB154;
  };
LAB130:
  return 1;
LAB133:
  L1 = (value)(L0[1]);
  switch (Alternative(L1)) {
  case 2: goto LAB136;
  default: goto LAB154;
  };
LAB136:
  return 1;
LAB139:
  return 1;
LAB142:
  L2 = (value)(L0[1]);
  L0 = L2;
  goto LAB425;
  return 0;
LAB147:
  L3 = (value)(L0[1]);
  L0 = L3;
  goto LAB425;
  return 0;
LAB152:
  L4 = (value)(L0[1]);
  L0 = L4;
  goto LAB425;
  return 0;
LAB154:
  return 0;
}

int Mtypes_P_is_external_type_TYPES_TYPE(P0,P1)
value P0;
value *P1;
{
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
LAB370:
  switch (Alternative(L0)) {
  case 6: goto LAB157;
  case 5: goto LAB160;
  case 2: goto LAB166;
  case 1: goto LAB171;
  case 3: goto LAB176;
  default: goto LAB178;
  };
LAB157:
  L1 = G_types_TYPE_NR2921;
  *P1 = L1;
  ATTACH(L1);
  return 1;
LAB160:
  L2 = (value)(L0[1]);
  switch (Alternative(L2)) {
  case 2: goto LAB163;
  default: goto LAB178;
  };
LAB163:
  L3 = G_types_TYPE_NR2922;
  *P1 = L3;
  ATTACH(L3);
  return 1;
LAB166:
  L4 = (value)(L0[1]);
  L0 = L4;
  goto LAB370;
  return 0;
LAB171:
  L6 = (value)(L0[1]);
  L0 = L6;
  goto LAB370;
  return 0;
LAB176:
  L8 = G_types_TYPE_NR2923;
  *P1 = L8;
  ATTACH(L8);
  return 1;
LAB178:
  return 0;
}

int Mtypes_P_get_TYPES_TYPE(P0,P1)
value P0;
value *P1;
{
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
LAB252:
  switch (Alternative(L0)) {
  case 5: goto LAB179;
  case 0: goto LAB182;
  case 2: goto LAB185;
  case 1: goto LAB188;
  case 4: goto LAB191;
  case 6: goto LAB194;
  case 3: goto LAB197;
  default: goto LAB199;
  };
LAB179:
  L1 = (value)(L0[1]);
  *P1 = L1;
  ATTACH(L1);
  return 1;
LAB182:
  L2 = (value)(L0[1]);
  L0 = L2;
  goto LAB252;
LAB185:
  L4 = (value)(L0[1]);
  L0 = L4;
  goto LAB252;
LAB188:
  L6 = (value)(L0[1]);
  L0 = L6;
  goto LAB252;
LAB191:
  L8 = (value)(L0[1]);
  *P1 = L8;
  ATTACH(L8);
  return 1;
LAB194:
  L9 = G_types_TYPE_NR2924;
  *P1 = L9;
  ATTACH(L9);
  return 1;
LAB197:
  L10 = G_types_TYPE_NR2925;
  *P1 = L10;
  ATTACH(L10);
  return 1;
LAB199:
  Abort(269, module_name);
}

int Mtypes_P_propagate_type_TYPENR_TYPENR(P0,P1)
value P0;
value P1;
{
  value L49;
  value L48;
  value L47;
  value L46;
  value L45;
  value L44;
  value L43;
  value L42;
  value L41;
  value L40;
  value L39;
  value L38;
  value L37;
  value L36;
  value L35;
  value L34;
  value L33;
  value L32;
  value L31;
  value L30;
  value L29;
  value L28;
  value L27;
  value L26;
  value L25;
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = (value) Addr((value*)&G_types_TYPES_NR2,Int(L1));
  L3 = *((value*)L2);
  ATTACH(L3);
  switch (Alternative(L3)) {
  case 6: goto LAB200;
  default: goto LAB201;
  };
LAB200:
if(DecrRefs(L3)<0)
XD_Mtypes_T3(L3);
  Create(&L4,0,1);
  L5 = (value) Addr((value*)&G_types_FROM_NR3,Int(L0));
  L6 = *((value*)L5);
  L7 = (value) Addr((value*)&G_types_TYPES_NR2,Int(L6));
  L8 = *((value*)L7);
  ATTACH(L8);
  *(value *)(L4+1) = L8;
if(DecrRefs(*((value*)L2))<0)
XD_Mtypes_T3(*((value*)L2));
  *((value *)L2) = L4;
  L9 = *((value*)L5);
  L10 = (value) Addr((value*)&G_types_FROM_NR3,Int(L1));
  *((value *)L10) = L9;
  return 1;
LAB201:
if(DecrRefs(L3)<0)
XD_Mtypes_T3(L3);
LAB202:
  L11 = (value) Addr((value*)&G_types_TYPES_NR2,Int(L1));
  L12 = *((value*)L11);
  ATTACH(L12);
  switch (Alternative(L12)) {
  case 3: goto LAB203;
  default: goto LAB204;
  };
LAB203:
if(DecrRefs(L12)<0)
XD_Mtypes_T3(L12);
  Create(&L13,1,1);
  L14 = (value) Addr((value*)&G_types_FROM_NR3,Int(L0));
  L15 = *((value*)L14);
  L16 = (value) Addr((value*)&G_types_TYPES_NR2,Int(L15));
  L17 = *((value*)L16);
  ATTACH(L17);
  *(value *)(L13+1) = L17;
if(DecrRefs(*((value*)L11))<0)
XD_Mtypes_T3(*((value*)L11));
  *((value *)L11) = L13;
  L18 = *((value*)L14);
  L19 = (value) Addr((value*)&G_types_FROM_NR3,Int(L1));
  *((value *)L19) = L18;
  L20 = *((value*)L14);
  L21 = (value) Addr((value*)&G_types_TYPENAMES_NR1,Int(L20));
  L22 = *((value*)L21);
  ATTACH(L22);
  L23 = (value)(L22[1]);
  L24 = (value)(L22[2]);
if(DecrRefs(L22)<0)
XD_Mtypes_T2(L22);
  L25 = (value) Addr((value*)&G_types_TYPENAMES_NR1,Int(L1));
  L26 = *((value*)L25);
  ATTACH(L26);
  L27 = (value)(L26[1]);
  L28 = (value)(L26[2]);
  Mmodules_P_get_MODULENR_EXPORTS(L28,&L29);
  Mtypes_P_propagate_types_TYPENR_TYPENAME_EXPORTS(L1,L27,L29);
if(DecrRefs(L29)<0)
XD_Mmodules_T5(L29);
if(DecrRefs(L26)<0)
XD_Mtypes_T2(L26);
  return 1;
LAB204:
if(DecrRefs(L12)<0)
XD_Mtypes_T3(L12);
LAB205:
  L44 = L0;
  L45 = L1;
  L46 = (value) Addr((value*)&G_types_FROM_NR3,Int(L44));
  L47 = *((value*)L46);
  L48 = (value) Addr((value*)&G_types_FROM_NR3,Int(L45));
  L49 = *((value*)L48);
  if (!(L47 == L49)) goto LAB207;
  return 1;
  return 1;
LAB207:
  L30 = (value) Addr((value*)&G_types_TYPENAMES_NR1,Int(L0));
  L31 = *((value*)L30);
  ATTACH(L31);
  L32 = (value)(L31[1]);
  L33 = (value)(L31[2]);
if(DecrRefs(L31)<0)
XD_Mtypes_T2(L31);
  L34 = (value) Addr((value*)&G_types_TYPENAMES_NR1,Int(L1));
  L35 = *((value*)L34);
  ATTACH(L35);
  L36 = (value)(L35[1]);
  L37 = (value)(L35[2]);
  Create(&L38,4,2);
  *(value *)(L38+1) = L37;
if(DecrRefs(L35)<0)
XD_Mtypes_T2(L35);
  Create(&L39,6,2);
  L40 = G_types_TEXT_NR2926;
  *(value *)(L39+1) = L40;
  ATTACH(L40);
  Create(&L41,2,2);
  *(value *)(L41+1) = L1;
  Create(&L42,11,1);
  L43 = G_types_TEXT_NR2927;
  *(value *)(L42+1) = L43;
  ATTACH(L43);
  *(value *)(L41+2) = L42;
  *(value *)(L39+2) = L41;
  *(value *)(L38+2) = L39;
  Mtypes_P_type_error_MESSAGE(L38);
if(DecrRefs(L38)<0)
XD_Merrors_T3(L38);
  return 1;
}

int Mtypes_P_propagate_types_TYPENR_TYPENAME_EXPORTS(P0,P1,P2)
value P0;
value P1;
value P2;
{
  value L55;
  value L54;
  value L53;
  value L52;
  value L51;
  value L50;
  value L49;
  value L48;
  value L47;
  value L46;
  value L45;
  value L44;
  value L43;
  value L42;
  value L41;
  value L40;
  value L39;
  value L38;
  value L37;
  value L36;
  value L35;
  value L34;
  value L33;
  value L32;
  value L31;
  value L30;
  value L29;
  value L28;
  value L27;
  value L26;
  value L25;
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = P2;
LAB331:
  switch (Alternative(L2)) {
  case 0: goto LAB208;
  default: goto LAB210;
  };
LAB208:
  L3 = (value)(L2[1]);
  L4 = (value)(L2[2]);
  if (!Mtypes_P_exists_MODULENR_TYPENAME_TYPENR(L3,L1,&L5)) goto LAB212;
  L6 = L0;
  L7 = L5;
  L8 = (value) Addr((value*)&G_types_TYPES_NR2,Int(L7));
  L9 = *((value*)L8);
  ATTACH(L9);
  switch (Alternative(L9)) {
  case 6: goto LAB320;
  default: goto LAB321;
  };
LAB320:
if(DecrRefs(L9)<0)
XD_Mtypes_T3(L9);
  Create(&L10,0,1);
  L11 = (value) Addr((value*)&G_types_FROM_NR3,Int(L6));
  L12 = *((value*)L11);
  L13 = (value) Addr((value*)&G_types_TYPES_NR2,Int(L12));
  L14 = *((value*)L13);
  ATTACH(L14);
  *(value *)(L10+1) = L14;
if(DecrRefs(*((value*)L8))<0)
XD_Mtypes_T3(*((value*)L8));
  *((value *)L8) = L10;
  L15 = *((value*)L11);
  L16 = (value) Addr((value*)&G_types_FROM_NR3,Int(L7));
  *((value *)L16) = L15;
  goto LAB319;
LAB321:
if(DecrRefs(L9)<0)
XD_Mtypes_T3(L9);
LAB322:
  L17 = (value) Addr((value*)&G_types_TYPES_NR2,Int(L7));
  L18 = *((value*)L17);
  ATTACH(L18);
  switch (Alternative(L18)) {
  case 3: goto LAB323;
  default: goto LAB324;
  };
LAB323:
if(DecrRefs(L18)<0)
XD_Mtypes_T3(L18);
  Create(&L19,1,1);
  L20 = (value) Addr((value*)&G_types_FROM_NR3,Int(L6));
  L21 = *((value*)L20);
  L22 = (value) Addr((value*)&G_types_TYPES_NR2,Int(L21));
  L23 = *((value*)L22);
  ATTACH(L23);
  *(value *)(L19+1) = L23;
if(DecrRefs(*((value*)L17))<0)
XD_Mtypes_T3(*((value*)L17));
  *((value *)L17) = L19;
  L24 = *((value*)L20);
  L25 = (value) Addr((value*)&G_types_FROM_NR3,Int(L7));
  *((value *)L25) = L24;
  L26 = *((value*)L20);
  L27 = (value) Addr((value*)&G_types_TYPENAMES_NR1,Int(L26));
  L28 = *((value*)L27);
  ATTACH(L28);
  L29 = (value)(L28[1]);
  L30 = (value)(L28[2]);
if(DecrRefs(L28)<0)
XD_Mtypes_T2(L28);
  L31 = (value) Addr((value*)&G_types_TYPENAMES_NR1,Int(L7));
  L32 = *((value*)L31);
  ATTACH(L32);
  L33 = (value)(L32[1]);
  L34 = (value)(L32[2]);
  Mmodules_P_get_MODULENR_EXPORTS(L34,&L35);
  Mtypes_P_propagate_types_TYPENR_TYPENAME_EXPORTS(L7,L33,L35);
if(DecrRefs(L35)<0)
XD_Mmodules_T5(L35);
if(DecrRefs(L32)<0)
XD_Mtypes_T2(L32);
  goto LAB319;
LAB324:
if(DecrRefs(L18)<0)
XD_Mtypes_T3(L18);
LAB325:
  L50 = L6;
  L51 = L7;
  L52 = (value) Addr((value*)&G_types_FROM_NR3,Int(L50));
  L53 = *((value*)L52);
  L54 = (value) Addr((value*)&G_types_FROM_NR3,Int(L51));
  L55 = *((value*)L54);
  if (!(L53 == L55)) goto LAB330;
  goto LAB319;
LAB330:
  L36 = (value) Addr((value*)&G_types_TYPENAMES_NR1,Int(L6));
  L37 = *((value*)L36);
  ATTACH(L37);
  L38 = (value)(L37[1]);
  L39 = (value)(L37[2]);
if(DecrRefs(L37)<0)
XD_Mtypes_T2(L37);
  L40 = (value) Addr((value*)&G_types_TYPENAMES_NR1,Int(L7));
  L41 = *((value*)L40);
  ATTACH(L41);
  L42 = (value)(L41[1]);
  L43 = (value)(L41[2]);
  Create(&L44,4,2);
  *(value *)(L44+1) = L43;
if(DecrRefs(L41)<0)
XD_Mtypes_T2(L41);
  Create(&L45,6,2);
  L46 = G_types_TEXT_NR2926;
  *(value *)(L45+1) = L46;
  ATTACH(L46);
  Create(&L47,2,2);
  *(value *)(L47+1) = L7;
  Create(&L48,11,1);
  L49 = G_types_TEXT_NR2927;
  *(value *)(L48+1) = L49;
  ATTACH(L49);
  *(value *)(L47+2) = L48;
  *(value *)(L45+2) = L47;
  *(value *)(L44+2) = L45;
  Mtypes_P_type_error_MESSAGE(L44);
if(DecrRefs(L44)<0)
XD_Merrors_T3(L44);
LAB319:
  L2 = L4;
  goto LAB331;
LAB212:
  L2 = L4;
  goto LAB331;
LAB210:
  return 1;
}

int Mtypes_P_propagate_synonym_TYPENR(P0)
value P0;
{
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L7 = L0;
  L8 = (value) Addr((value*)&G_types_FROM_NR3,Int(L7));
  L9 = *((value*)L8);
  L10 = (value) Addr((value*)&G_types_TYPES_NR2,Int(L9));
  L11 = *((value*)L10);
  L13 = L11;
LAB277:
  switch (Alternative(L13)) {
  case 5: goto LAB278;
  case 0: goto LAB282;
  case 2: goto LAB285;
  case 1: goto LAB288;
  case 4: goto LAB291;
  case 6: goto LAB294;
  case 3: goto LAB297;
  default: goto LAB299;
  };
LAB278:
  L14 = (value)(L13[1]);
  L12 = L14;
  ATTACH(L14);
  goto LAB280;
LAB282:
  L15 = (value)(L13[1]);
  L13 = L15;
  goto LAB277;
LAB285:
  L17 = (value)(L13[1]);
  L13 = L17;
  goto LAB277;
LAB288:
  L19 = (value)(L13[1]);
  L13 = L19;
  goto LAB277;
LAB291:
  L21 = (value)(L13[1]);
  L12 = L21;
  ATTACH(L21);
  goto LAB280;
LAB294:
  L22 = G_types_TYPE_NR2924;
  L12 = L22;
  ATTACH(L22);
  goto LAB280;
LAB297:
  L23 = G_types_TYPE_NR2925;
  L12 = L23;
  ATTACH(L23);
LAB280:
  L1 = L12;
LAB276:
  switch (Alternative(L1)) {
  case 1: goto LAB213;
  default: goto LAB214;
  };
LAB299:
  Abort(269, module_name);
LAB213:
  L2 = (value)(L1[1]);
  L3 = (value) Addr((value*)&G_types_FROM_NR3,Int(L0));
  L4 = *((value*)L3);
  if (!(L4 == L0)) goto LAB217;
  Mtypes_P_propagate_synonym_TYPENR(L2);
  L5 = (value) Addr((value*)&G_types_FROM_NR3,Int(L2));
if(DecrRefs(L1)<0)
XD_Mtypes_T11(L1);
  L6 = *((value*)L5);
  *((value *)L3) = L6;
  return 1;
LAB214:
if(DecrRefs(L1)<0)
XD_Mtypes_T11(L1);
  return 1;
LAB217:
if(DecrRefs(L1)<0)
XD_Mtypes_T11(L1);
  return 1;
  return 1;
}

int Mtypes_P_propagate_synonyms_TYPENR(P0)
value P0;
{
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
LAB340:
  L1 = (value)G_types_NR_OF_TYPES_NR5;
  if (!(L0 == L1)) goto LAB219;
  return 1;
LAB219:
  Mtypes_P_propagate_synonym_TYPENR(L0);
  L2 = C_INT(1);
  L3 = C_INT(Int(L0) + Int(L2));
  L0 = L3;
  goto LAB340;
}

int Mtypes_P_propagate_types_TYPENR(P0)
value P0;
{
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
LAB339:
  L1 = (value)G_types_NR_OF_TYPES_NR5;
  if (!(L0 == L1)) goto LAB223;
  return 1;
LAB223:
  Mtypes_P_propagate_synonym_TYPENR(L0);
  L4 = L0;
  L10 = L4;
  L11 = (value) Addr((value*)&G_types_TYPES_NR2,Int(L10));
  L12 = *((value*)L11);
  switch (Alternative(L12)) {
  case 2: goto LAB333;
  default: goto LAB332;
  };
LAB333:
  L13 = (value)(L12[1]);
LAB335:
  L5 = (value) Addr((value*)&G_types_TYPENAMES_NR1,Int(L4));
  L6 = *((value*)L5);
  ATTACH(L6);
  L7 = (value)(L6[1]);
  L8 = (value)(L6[2]);
  Mmodules_P_get_MODULENR_EXPORTS(L8,&L9);
  Mtypes_P_propagate_types_TYPENR_TYPENAME_EXPORTS(L4,L7,L9);
if(DecrRefs(L9)<0)
XD_Mmodules_T5(L9);
if(DecrRefs(L6)<0)
XD_Mtypes_T2(L6);
LAB332:
  L2 = C_INT(1);
  L3 = C_INT(Int(L0) + Int(L2));
  L0 = L3;
  goto LAB339;
}

int Mtypes_P_check_all_types_TYPENR(P0)
value P0;
{
  value L33;
  value L32;
  value L31;
  value L30;
  value L29;
  value L28;
  value L27;
  value L26;
  value L25;
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
LAB348:
  L1 = (value)G_types_NR_OF_TYPES_NR5;
  if (!(L0 == L1)) goto LAB231;
  return 1;
LAB231:
  L2 = (value) Addr((value*)&G_types_FROM_NR3,Int(L0));
  L3 = *((value*)L2);
  L4 = (value) Addr((value*)&G_types_FROM_NR3,Int(L3));
  L5 = *((value*)L4);
  *((value *)L2) = L5;
  L8 = L0;
  L9 = (value) Addr((value*)&G_types_TYPENAMES_NR1,Int(L8));
  L10 = *((value*)L9);
  ATTACH(L10);
  L11 = (value)(L10[1]);
  L12 = (value)(L10[2]);
  L13 = (value) Addr((value*)&G_types_TYPES_NR2,Int(L8));
  L14 = *((value*)L13);
  ATTACH(L14);
  switch (Alternative(L14)) {
  case 6: goto LAB342;
  default: goto LAB343;
  };
LAB342:
if(DecrRefs(L14)<0)
XD_Mtypes_T3(L14);
  Create(&L15,4,2);
  *(value *)(L15+1) = L12;
if(DecrRefs(L10)<0)
XD_Mtypes_T2(L10);
  Create(&L16,6,2);
  L17 = G_types_TEXT_NR2928;
  *(value *)(L16+1) = L17;
  ATTACH(L17);
  Create(&L18,2,2);
  *(value *)(L18+1) = L8;
  Create(&L19,11,1);
  L20 = G_types_TEXT_NR2929;
  *(value *)(L19+1) = L20;
  ATTACH(L20);
  *(value *)(L18+2) = L19;
  *(value *)(L16+2) = L18;
  *(value *)(L15+2) = L16;
  Mtypes_P_type_error_MESSAGE(L15);
if(DecrRefs(L15)<0)
XD_Merrors_T3(L15);
  Create(&L21,5,1);
  L22 = G_types_TYPE_NR2930;
  *(value *)(L21+1) = L22;
  ATTACH(L22);
if(DecrRefs(*((value*)L13))<0)
XD_Mtypes_T3(*((value*)L13));
  *((value *)L13) = L21;
  goto LAB341;
LAB343:
if(DecrRefs(L14)<0)
XD_Mtypes_T3(L14);
LAB344:
  L23 = (value) Addr((value*)&G_types_TYPES_NR2,Int(L8));
  L24 = *((value*)L23);
  ATTACH(L24);
  switch (Alternative(L24)) {
  case 3: goto LAB345;
  default: goto LAB346;
  };
LAB345:
if(DecrRefs(L24)<0)
XD_Mtypes_T3(L24);
  Create(&L25,2,1);
  Create(&L26,5,1);
  L27 = G_types_TYPE_NR2931;
  *(value *)(L26+1) = L27;
  ATTACH(L27);
  *(value *)(L25+1) = L26;
if(DecrRefs(*((value*)L23))<0)
XD_Mtypes_T3(*((value*)L23));
  *((value *)L23) = L25;
  Create(&L28,4,2);
  *(value *)(L28+1) = L12;
if(DecrRefs(L10)<0)
XD_Mtypes_T2(L10);
  Create(&L29,6,2);
  L30 = G_types_TEXT_NR2932;
  *(value *)(L29+1) = L30;
  ATTACH(L30);
  Create(&L31,2,2);
  *(value *)(L31+1) = L8;
  Create(&L32,11,1);
  L33 = G_types_TEXT_NR2933;
  *(value *)(L32+1) = L33;
  ATTACH(L33);
  *(value *)(L31+2) = L32;
  *(value *)(L29+2) = L31;
  *(value *)(L28+2) = L29;
  Mtypes_P_type_error_MESSAGE(L28);
if(DecrRefs(L28)<0)
XD_Merrors_T3(L28);
  goto LAB341;
LAB346:
if(DecrRefs(L24)<0)
XD_Mtypes_T3(L24);
LAB347:
if(DecrRefs(L10)<0)
XD_Mtypes_T2(L10);
LAB341:
  L6 = C_INT(1);
  L7 = C_INT(Int(L0) + Int(L6));
  L0 = L7;
  goto LAB348;
}

int Mtypes_P_is_real_type_TYPENR(P0)
value P0;
{
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = (value)G_types_REAL_TYPENR_NR8;
  L2 = L0;
  L3 = L1;
  L4 = (value) Addr((value*)&G_types_FROM_NR3,Int(L2));
  L5 = *((value*)L4);
  L6 = (value) Addr((value*)&G_types_FROM_NR3,Int(L3));
  L7 = *((value*)L6);
  if (!(L5 == L7)) goto LAB233;
  return 1;
  return 1;
LAB233:
  return 0;
}

int Mtypes_P_real_type_TYPENR(P0)
value *P0;
{
  value L0;
  L0 = (value)G_types_REAL_TYPENR_NR8;
  *P0 = L0;
  return 1;
}

int Mtypes_P_build_type_TYPE_TEXT(P0,P1)
value P0;
value *P1;
{
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  switch (Alternative(L0)) {
  case 0: goto LAB234;
  case 1: goto LAB237;
  case 2: goto LAB240;
  default: goto LAB242;
  };
LAB234:
  L1 = (value)(L0[1]);
  L2 = (value)(L0[2]);
  Mtypes_P_build_type_TYPEALTERNATIVE_TEXT(L1,&L3);
  Mtypes_P_build_type_TYPE_TEXT(L2,&L4);
  L7 = G_types_TEXT_NR2934;
  L6 = Concat(L3,L7);
D_TEXT(L3);
  L5 = Concat(L6,L4);
D_TEXT(L6);
D_TEXT(L4);
  *P1 = L5;
  return 1;
LAB237:
  L8 = (value)(L0[1]);
  Mtypes_P_get_TYPENR_TYPENAME_MODULENR(L8,&L9,&L10);
  L12 = G_types_TEXT_NR2935;
  L11 = Concat(L12,L9);
D_TEXT(L9);
  *P1 = L11;
  return 1;
LAB240:
  L13 = G_types_TEXT_NR2936;
  *P1 = L13;
  ATTACH(L13);
  return 1;
LAB242:
  Abort(427, module_name);
}

int Mtypes_P_build_type_TYPEALTERNATIVE_TEXT(P0,P1)
value P0;
value *P1;
{
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  switch (Alternative(L0)) {
  case 0: goto LAB243;
  case 1: goto LAB246;
  case 2: goto LAB249;
  default: goto LAB251;
  };
LAB243:
  L1 = (value)(L0[1]);
  L2 = (value)(L0[2]);
  Mterminals_P_get_TERMINALNR_TERMINAL(L1,&L3);
  Mtypes_P_build_type_TYPEALTERNATIVE_TEXT(L2,&L4);
  L7 = G_types_TEXT_NR2937;
  L6 = Concat(L3,L7);
D_TEXT(L3);
  L5 = Concat(L6,L4);
D_TEXT(L6);
D_TEXT(L4);
  *P1 = L5;
  return 1;
LAB246:
  L8 = (value)(L0[1]);
  L9 = (value)(L0[2]);
  Mtypes_P_get_TYPENR_TYPENAME_MODULENR(L8,&L10,&L11);
  Mtypes_P_build_type_TYPEALTERNATIVE_TEXT(L9,&L12);
  L15 = G_types_TEXT_NR2938;
  L14 = Concat(L10,L15);
D_TEXT(L10);
  L13 = Concat(L14,L12);
D_TEXT(L14);
D_TEXT(L12);
  *P1 = L13;
  return 1;
LAB249:
  L16 = G_types_TEXT_NR2939;
  *P1 = L16;
  ATTACH(L16);
  return 1;
LAB251:
  Abort(440, module_name);
}

