// Memory pool stuff.
//
// Copyright 2001, KUN
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

// $Id: pool.cc,v 1.3 2001/04/27 08:56:21 ejv Exp $


#include "pool.h"

Pool::Pool(unsigned sz, unsigned inc)
{
    el_size = sz < sizeof(Link*) ? sizeof(Link*) : sz;
    free_list = 0;
    chunck_list = 0;
    grow_size = inc;
}

Pool::~Pool()
{
    shrink();
}

void Pool::grow()
{
    const int overhead = 12;
    const int chunck_size = grow_size - overhead;
    const int nr_elem = (chunck_size - sizeof(Link*)) / el_size;

    char* mem = new char[chunck_size];
    char* first = mem + sizeof(Link*);
    char* last = first + (nr_elem - 1) * el_size;

    ((Link*)mem)->next = chunck_list;
    chunck_list = (Link*)mem;

    for (char* p = first; p < last; p += el_size) {
        ((Link*)p)->next = (Link*)(p + el_size);
    }

    ((Link*)last)->next = free_list;
    free_list = (Link*)first;
}

void Pool::shrink(void)
{
    Link* chunck = chunck_list;

    while (chunck) {
        Link* next = chunck->next;
        delete chunck;
        chunck = next;
    }

    free_list = 0;
    chunck_list = 0;
}
