// C++ interface to the bison generated parser.
//
// Copyright 2001, KUN
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

// $Id: parserinterface.h,v 1.8 2001/10/11 10:16:38 ejv Exp $


#ifndef parserinterface_h
#define parserinterface_h

#include <string>
#include <list>

#include "globals.h"
#include "id.h"

typedef list<Param*> MyParamList;

int get_line_nr();
int get_col_nr();
void reset_scanner_counters();
int yyparse();
extern FILE* yyin;
extern char* parser_error;
extern int error_occured;

Param* affterms_to_param(IDList* aff_terms);

IDList* aff_terml_new(string* a);
IDList* aff_terml_add(IDList* lst, string* str);

EntryList* nont_def(string* name, pParam pars, long count);

void set_module_name(char* name);

pParam build_params(MyParamList* paraml);

#endif /* parserinterface_h */
