// Lexicon Interface File parser class definition.
//
// Copyright 2001, KUN
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

// $Id: lifparser.h,v 1.7 2001/10/25 09:23:07 ejv Exp $


#ifndef lifparser_h
#define lifparser_h

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <fstream>
#include <string>

#include <stdio.h>

#include "paramtab.h"

class LIFFile {
    private:
        FILE* lif_file;
        char* liffilebuf;
        int liffilebuflen;
        char* lifbufptr;

        bool is_column_seperator();
        void skip_column_seperator();
        bool end_of_line();
        void end_of_line_check();
        void read_next_line();

    public:
        LIFFile(string lif_name);
        ~LIFFile();

        unsigned get_number();
        string get_text();
        bool is_seperator_line();
};

class LifParser {
    private:
        LIFFile* lif;
        void read_parameters(int to_go, pParam& params);

    public:
        void parse_lif(string lif_name);
        bool no_lif_file(string lif_name);
};

#endif // lifparser_h
