// Lexicon nonterminal list class definition, as stored in the .blf file.
//
// Copyright 2001, KUN
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

// $Id: lexnontermlist.h,v 1.10 2001/05/09 10:02:12 ejv Exp $


#ifndef lexnontermlist_h
#define lexnontermlist_h

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <fstream.h>
#include <map>
#include <string>
#include <stdlib.h>
#include "paramtab.h"
#include "entry.h"
#include "lexfileio.h"

#include <lexicon.h>

typedef pair<string, unsigned> LexNontWithArity;
typedef pair<unsigned, pParam> LexNontInfo;
typedef map<LexNontWithArity, LexNontInfo> LexNontMap;

//------------------------------------------------------------------------------
// Class: LexNontermList
//
// Description:
//      The LexNontermList class stores information on the nonterminals as
//      read from the lif (lexicon interface file). Stored are the affixes
//      (top domain) that act as parameters and the rule number.
//------------------------------------------------------------------------------

class LexNontermList {
    private:
        LexNontMap nonterms;

    public:
        void add_nonterm(string name, pParam params, unsigned rule_nr);
        unsigned get_index(Entry e);
        int get_param_idx(Param p);
        unsigned get_max_idx();
        LexNontMap::iterator get_entry_by_idx(unsigned idx);
        bool is_defined(string nonterm, pParam params);

        bool has_changed(LEXICON* old_lex);
        bool has_changed(const Param par, string old_name);

        unsigned calculate_arity(pParam params);

        void dump();
        ofstream& print(ofstream& ofs);

        inline size_t size() { return nonterms.size(); };
};

ofstream& operator <<(ofstream& ofs, LexNontermList& l);

#endif // lexnontermlist_h
