// Lexicon INT affix list class definition, stored in the .blf file.
//
// Copyright 2001, KUN
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

// $Id: lexintaffixlist.h,v 1.4 2001/03/20 14:46:32 ejv Exp $


#ifndef lexintaffixlist_h
#define lexintaffixlist_h

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif // HAVE_CONFIG_H

#include <map>
#include <vector>
#include <fstream.h>
#include <iostream.h>
#include "lexfileio.h"

typedef map<long,unsigned> int_aff_t;
typedef vector<int_aff_t::iterator> int_aff_index_t;

class LexIntAffixList
{
    private:
        int_aff_t affixes;
        int_aff_index_t affixes_index;

    public:
        unsigned add_affix(long aff);
        unsigned get_index(long aff);
        long search_by_index(unsigned idx);

        void dump();

        inline size_t size() { return affixes.size(); };
};

ofstream& operator<<(ofstream& ofs, LexIntAffixList& l);

#endif // lexintaffixlist_h
