/* RTS utility function definitions
 *
 * Copyright 2000 KUN.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* $Id: rtsutil.h,v 1.5 2001/10/17 10:39:30 ejv Exp $ */

#ifndef rtsutil_h
#define rtsutil_h

#ifdef DEBUG
# define DEBUG_MEM
#endif
#ifdef DEBUG_MEM

#define	GetMem(size, txt)		Debug__GetMem(size, txt)
#define	ResizeMem(mem, size, txt)	Debug__ResizeMem(mem, size, txt)
#define	FreeMem(mem, txt)		Debug__FreeMem(mem, txt)

void*	Debug__GetMem(int, const char*);
void*	Debug__ResizeMem(void*, int, char*);
void	Debug__FreeMem(void*, const char*);

#else /* DEBUG_MEM */

#define	GetMem(size, txt)		__GetMem(size)
#define	ResizeMem(mem, size, txt)	__ResizeMem(mem, size)
#define	FreeMem(mem, txt)		__FreeMem(mem)

#endif /* DEBUG_MEM */

void*	__GetMem(int);
void*	__ResizeMem(void*, int);
void	__FreeMem(void*);

void Assert(int, char*, char*, ...);

#endif /* rtsutil_h */
