/* Utility functions for the runtime system.
 *
 * Copyright 2000 KUN.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* $Id: rtsutil.c,v 1.5 2001/10/17 10:39:30 ejv Exp $ */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /* HAVE_CONFIG_H */

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>

#ifdef PARIX
#include <epx/logerror.h>
#endif

#include "rtsutil.h"
#include "rtsio.h"

#ifdef DEBUG_MEM

void LogMem(char* fmt, ...)
{
  static FILE*	log_file = NULL;
  static char	log_fname[] = "memory.log";
  va_list	argp;

  if (log_file == NULL)
  {
    log_file = fopen(log_fname, "w");
    if (log_file == NULL)
      rtsAbort("LogMem", "cannot open file '%s'\n", log_fname);
  }
  va_start(argp, fmt);
  vfprintf(log_file, fmt, argp);
  va_end(argp);
}

void*   Debug__GetMem(int size, const char* txt)
{
  void* mem;

  if (size <= 0)
  {
    rtsBug("GetMem", "invalid request of %d bytes of memory by %s", size, txt);
    return NULL;	/* not reached */
  };
#if 0
  if (0
      || strcmp(txt, "buffer") == 0
      || strcmp(txt, "rtsio") == 0
      || strcmp(txt, "memos") == 0
      || strcmp(txt, "regexp") == 0
      || strcmp(txt, "state") == 0
      || strcmp(txt, "lexicon") == 0
      || strcmp(txt, "hash") == 0
      || strcmp(txt, "memhelp") == 0
      || strcmp(txt, "a_string") == 0
      || strcmp(txt, "string") == 0
      || strcmp(txt, "history") == 0
     )
     mem = __GetMem(size + 100);
  else
#endif
    mem = __GetMem(size);
  LogMem("%s: alloc %d 0x%x\n", txt, size, mem);
  return mem;
}

void*   Debug__ResizeMem(void* mem, int size, char* txt)
{
  void* resized_mem;

  resized_mem = __ResizeMem(mem, size);
  LogMem("%s: resize %d 0x%x\n", txt, size, mem);
  if (mem != resized_mem)
  {
    LogMem("%s: free 0x%x\n", txt, mem);
    LogMem("%s: alloc size 0x%x\n", txt, size, resized_mem);
  }
  return resized_mem;
}

void    Debug__FreeMem(void* mem, const char* txt)
{
  __FreeMem(mem);
  LogMem("%s: free 0x%x\n", txt, mem);
}

#endif /* DEBUG_MEM */

void *__GetMem(int size)
{
  void *mem;

  if (size <= 0)
  {
    rtsBug("GetMem", "invalid request of %d bytes of memory", size);
    return NULL;	/* not reached */
  };
  mem = malloc(size);
  if (mem == NULL)
  {
    rtsAbort("GetMem", "Out of memory (requested %d bytes)", size);
    return NULL;	/* not reached */
  };

  return mem;
}

void *__ResizeMem(void *mem, int size)
{
  void* resized_mem;

  resized_mem = realloc(mem, size);
  if (resized_mem == NULL)
    rtsAbort("ResizeMem", "Out of memory (requested %d bytes)", size);

  return resized_mem;
}

void __FreeMem(void *mem)
{
  free(mem);
}

void Assert(int bool, char *fName, char *fmt, ...)
{
  va_list argp;
#ifdef PARIX
  char buf[1024];
#endif

  if (bool)
    return;
  va_start(argp, fmt);
#ifdef PARIX
  vsprintf(buf, fmt, argp);
  LogError(EC_ERROR, fName, "ASSERT FAILED: %s", buf);
#else
  fprintf(stderr, "ABORT %s: ", fName);
  vfprintf(stderr, fmt, argp);
  fflush(stderr);
#endif
  va_end(argp);
#ifdef PARIX
  AbortServer(1);
#else
  exit(1);
#endif
}
