/*
 * Generated code interfacing routines.
 *
 * Copyright 2000 KUN.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* $Id: rtscode.c,v 1.18 2001/10/17 10:39:28 ejv Exp $ */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /* HAVE_CONFIG_H */

#ifdef HAVE_MALLOC_H
#include <malloc.h>
#endif /* HAVE_MALLOC_H */
#include <stdio.h>
#include <assert.h>
#include <glib.h>
#include <stdlib.h>
#include "rtscode.h"
#include "rtsio.h"
#include "rtsesc.h"

#ifdef DEBUG
#define DB(x) x
#else
#define DB(x)
#endif

/*
//------------------------------------------------------------------------------
// Function:
//	void print_set_affix(unsigned long val, long domain)
//
// Description:
//	Print textual set representation of affix with value val and domain.
//------------------------------------------------------------------------------
*/

void
print_set_affix(unsigned long val, long domain, gboolean in_transduction)
{
    long affix;
    long mask;
    long* weight;

    weight = affix_weights[domain];
    while (val != 0)
    {
        affix = *weight++;

        if(affix == -1) {
            rtsBug("print_set_affix", "invalid affix weight");
        } else {
            mask = affix_domains[affix];

            if ((val & mask) == mask) {
		char *escd;
		if (dupstr_escaped(affix_names[affix], &escd)) {
		    exit(2);	/* out of mem */
		}

                val ^= mask;

                if (in_transduction) {
                    current_parse_add_string(affix_names[affix]);
                    if (val != 0) {
                        current_parse_add_char('|');
                    }
                } else {
                    printf("%s", escd);
                    if (val != 0) {
                        printf("|");
                    }
		}
		free(escd);
            }
        }
    }
}

void
print_text_affix(const char* val, gboolean in_transduction)
{
    if (val == TOP_TEXT) {
        if (in_transduction) {
            current_parse_add_string("TEXT");
        } else {
            printf("TEXT");
        }
    } else {
	char *escd;
	if (dupstr_escaped(val, &escd)) {
	    exit(2);	/* out of mem */
	}

        if (in_transduction) {
            current_parse_add_string(val);
        } else {
            printf("\"%s\"", escd);
        }
	free(escd);
    }
}

void
print_integer_affix(int val, gboolean in_transduction)
{
    if (val == TOP_INT) {
        if (in_transduction) {
            current_parse_add_string("INT");
        } else {
            printf("INT");
        }
    } else {
        if (in_transduction) {
            current_parse_add_int(val);
        } else {
            printf("%d",val);
        }
    }
}

void
current_parse_add_terminal(long termnr)
{
    char *escd;
    if (dupstr_escaped(term_names[termnr], &escd)) {
	exit(2);	/* out of mem */
    }

    printf("%s", escd);
    free(escd);
}

void
current_parse_add_match_regexp(long termnr)
{
#if 0
    char *escd;
    if (dupstr_escaped(match_regexp_names[termnr], &escd)) {
	exit(2);	/* out of mem */
    }

    printf("%s", escd);
    free(escd);
#else
    /* generator now stores REs without removing backslashes (as it should) */
    printf("%s", match_regexp_names[termnr]);
#endif
}

void
current_parse_add_skip_regexp(long termnr)
{
#if 0
    char *escd;
    if (dupstr_escaped(skip_regexp_names[termnr], &escd)) {
	exit(2);	/* out of mem */
    }

    printf("%s", escd);
    free(escd);
#else
    /* generator now stores REs without removing backslashes (as it should) */
    printf("%s", skip_regexp_names[termnr]);
#endif
}

#if 0
/* We should have access to a list of (grammar & lexicon) nonterminal names.
// For now, rtslex gets the name from the lexicon through rtslint.
// This function intended for later use.
*/
void current_parse_add_nonterminal(long nontnr)
{
  current_parse_add_string(nont_names[nontnr]);
}
#endif

inline long affix_get_top(unsigned nont_nr, unsigned affix_nr)
{
  long* arg_array = nont_domains[nont_nr];
  long affix_type = arg_array[affix_nr];
  if(affix_type == INT_TYPE)
  {
    return (long) TOP_INT;
  }
  else if(affix_type == TEXT_TYPE)
  {
    return (long) TOP_TEXT;
  }
  else if(affix_type >= 0)
  {
    return affix_domains[affix_type];
  }
  else
  {
    assert((affix_type >=0)||(affix_type==TEXT_TYPE)||(affix_type==INT_TYPE));
    return 0; /* impossible to reach */
  }
}

extern long get_nr_choices() { return nr_choices; }
