%{
// Scanner for the old-style .dat files
//
// Copyright 2001, KUN.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

// $Id: scanner.ll,v 1.2 2001/06/18 09:20:13 ejv Exp $


#include <iostream.h>
#include <errno.h>
#include "scanner.h"

%}

%option c++
%option yylineno
%option noyywrap

LAYOUT			[ \t\n\015\032]+
COMMENT			#.*\n
NUMBER			0|[1-9][0-9]*
STR_CHARS		((\\.)|[ !#-\[\]-~\177-\377])+
STRING			\"{STR_CHARS}\"
ORNAMENT		[\+\-\?@\^~_]
LETTER			[a-zA-Z\177-\377]
LETMENTS		({LETTER}|{ORNAMENT})*{LETTER}({LETTER}|{ORNAMENT})*
IDENTIFIER		{LETMENTS}([ ]+{LETMENTS})*

%s lexemes

%%
{LAYOUT}		{ /* skip layout */ }
{COMMENT}		{ /* skip comment */ }
MODULE/.*		{ return Scanner::MODULE; }
ROOT/.*			{ return Scanner::ROOT; }
DEFINES/.*		{ return Scanner::DEFINES; }
USES/.*			{ return Scanner::USES; }
\$PENALTY		{ return Scanner::PENALTY; }
\$SKIP			{ return Scanner::SKIP; }
\$MATCH			{ return Scanner::MATCH; }
\$PREV			{ return Scanner::PREV; }
\$AHEAD			{ return Scanner::AHEAD; }
\$PROMPT		{ return Scanner::PROMPT; }
TEXT			{ return Scanner::TEXT; }
INT			{ return Scanner::INT; }
{NUMBER}		{ return Scanner::NUMBER; }
{IDENTIFIER}		{ return Scanner::ID; }
<INITIAL>{STRING}	{ return Scanner::STRING; }
<lexemes>{STRING}	{ return Scanner::LEXEME; }
::			{ return Scanner::DOUBLE_COLON; }
:			{ BEGIN(lexemes);
			  return ':'; }
\.			{ BEGIN(INITIAL);
			  return '.'; }
.			{ return yytext[0]; }
%%

void Scanner::syntax_error(char* error)
{
    if (ahead == ERROR) {
        return;
    }

    ahead = ERROR;

    if (fname) {
        cerr << fname << ": ";
    }

    cerr << "syntax error (line " << yylineno
        << ", before `" << yytext << "'): " << error << endl;

    if (++err_cnt == MAX_SYNTAX_ERRORS) {
        exit(1);
    }
}


