// Program to convert old-style dat files to new-style dat files.
//
// Copyright 2001, KUN.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

// $Id: datconvert.cc,v 1.1 2001/03/08 16:22:34 ejv Exp $


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif // HAVE_CONFIG_H

#include <iostream.h>
#include <fstream.h>

#include "parser.h"

void show_version()
{
    cout << "datconvert, part of " << PACKAGE << " version " << VERSION << endl;
}

void show_usage()
{
    show_version();
    cerr << "This program converts pre-2.0 AGFL .dat files to the 2.0 syntax."
         << endl
         << "Note: all comments will be removed!" << endl
         << endl
         << "Usage: datconvert <option>" << endl
         << "   or: datconvert <infile> <outfile>" << endl
         << endl
         << "Options:" << endl
         << "        -h          shows this help message" << endl
         << "        -V          shows version" << endl;
}

int main(int argc, char* argv[])
{
    if (argc == 2) {
        if (!strcmp(argv[1], "-V")) {
            show_version();
            return 0;
        } else {
            show_usage();
            if (!strcmp(argv[1], "-h")) {
                return 0;
            } else {
                return 1;
            }
        }
    } else if (argc != 3) {
        show_usage();
        return 1;
    }

    char* infile = argv[1];
    char* outfile = argv[2];

    ifstream is(infile);
    if (!is) {
        cerr << "Error: cannot open input file \"" << infile << "\"" << endl;
        exit(3);
    }

    ofstream os(outfile);
    if (!os) {
        cerr << "Error: cannot open output file \"" << outfile << "\"" << endl;
        exit(3);
    }

    Parser* parser = new Parser(is, infile);
    unsigned nr_errors = parser->convert(os);
    delete parser;

    is.close();
    os.close();

    if (nr_errors) {
        cerr << infile << ": " << nr_errors << " errors found." << endl;
        return 2;
    } else {
        return 0;
    }
}

