// Memory pool class definition.
//
// Copyright 2001, KUN
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

// $Id: pool.h,v 1.2 2001/03/20 14:46:33 ejv Exp $

#ifndef POOL_H
#define POOL_H

class Pool
{
        struct Link { Link* next; };

        Link*		free_list;
        Link*		chunck_list;
        unsigned	el_size;
        unsigned	grow_size;

        Pool(Pool&);			// copy protection
        void operator = (Pool&);	// copy protection

    public:
        Pool(unsigned, unsigned = 512 * 1024);
        ~Pool(void);

        void* alloc();
        void  free(void*);
        void	grow();
        void	shrink();
};

inline void* Pool::alloc()
{
    if (free_list == 0) {
        grow();
    }

    Link* free = free_list;
    free_list = free->next;

    return free;
}

inline void Pool::free(void* mem)
{
    Link* free = (Link*)mem;
    free->next = free_list;
    free_list = free;
}

#endif // POOL_H
