// C++ interface to the bison generated parser.
//
// Copyright 2001, KUN
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

// $Id: parserinterface.cc,v 1.9 2001/10/11 10:14:15 ejv Exp $


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif // HAVE_CONFIG_H

#include <stdlib.h>
#ifdef HAVE_MALLOC_H
#include <malloc.h>
#endif // HAVE_MALLOC_H

#include <str_util.h>

#include "parserinterface.h"

char* parser_error;
int error_occured = 0;

double frequency_sum = 0.0;
string current_module_name;

string file_err_pos()
{
    return current_module_name + ".dat:" + dec(get_line_nr(), 0) + ":"
           + dec(get_col_nr(), 0) + ": error: ";
}

void unknown_affix_error(string aff_name)
{
    cerr << file_err_pos() << "unknown affix \"" << aff_name << "\""
         << " (ignoring further occurences)" << endl;
    error_occured = 1;
}

void enter_terminal(char* name, EntryList* entries)
{
    rule_table.enter(name, *entries);

    delete entries;
    free(name);
}

static ID text_id = unknown_id;
static ID int_id = unknown_id;

Param* affterms_to_param(IDList* aff_terms)
{
    if (text_id == unknown_id) {
        string str_text = "TEXT";
        text_id = idtable.add(str_text);
        string str_int = "INT";
        int_id = idtable.add(str_int);
    }

    if (aff_terms->size() == 1) {
        ID param_id = *(aff_terms->begin());

        if (param_id == text_id) {
            delete aff_terms;
            return new Param(AnyText);
        } else if (param_id == int_id) {
            delete aff_terms;
            return new Param(AnyInt);
        } else {
            delete aff_terms;
            return new Param(IdType, param_id);
        }
    } else {
        unsigned set_sz = 0;
        AffixID set_ids[MaxSetSz];

        for (IDList::iterator i = aff_terms->begin(); i != aff_terms->end();
             ++i) {
            if (*i == text_id) {
                cerr << dec(get_line_nr(), 0)
                     << ": TEXT in affix set expression" << endl;
            } else if (*i == int_id) {
                cerr << dec(get_line_nr(), 0)
                     << ": INT in affix set expression" << endl;
            } else {
                set_ids[set_sz++] = *i;
            }
            if (set_sz >= MaxSetSz) {
                cerr << "nr of params exceeds max set size" << endl;
            }
        }

        pAffixSet set = affix_table.enter(set_ids, set_sz);
        delete aff_terms;
        return new Param(set);
    }
}

IDList* aff_terml_new(string* str)
{
    IDList* l = new IDList;
    ID id = idtable.to_id(*str);
    if (id == unknown_id) {
        id = idtable.add(*str);
        unknown_affix_error(*str);
    }

    l->push_back(id);
    delete str;

    return l;
}

IDList* aff_terml_add(IDList* lst, string* str)
{
    ID id = idtable.to_id(*str);
    if (id == unknown_id) {
        id = idtable.add(*str);
        unknown_affix_error(*str);
    }

    lst->push_back(id);
    delete str;

    return lst;
}

pParam build_params(MyParamList* pl)
{
    pParam params = 0;

    for (MyParamList::iterator i = pl->begin(); i != pl->end(); ++i) {
        params = param_table.enter(**i, params);
        delete (*i);
    }

    delete pl;

    return params;
}

EntryList* nont_def(string* name, pParam pars, long count)
{
    if (!is_syntax_nonterminal_id((char*) (name->c_str()))) {
        cerr << file_err_pos() << "\"" << *name
             << "\" is not a syntax nonterminal (ignoring further occurences)"
             << endl;
        error_occured = 1;
    }

    ID nont_id = idtable.to_id(*name);

    if (nont_id == unknown_id) {
        cerr << file_err_pos()
             << "syntax nonterminal not defined in .lex file: \"" << *name
             << "\"" << endl;
        error_occured = 1;
        nont_id = idtable.add(*name);
    }

    delete name;

    EntryList* l = new EntryList;

    l->enter(Entry(nonterm_table.enter(nont_id, pars), get_line_nr(), count));
    frequency_sum += count;

    return l;
}

void set_module_name(char* name)
{
    current_module_name = string(name);
}

