// Options class is used for (commandline) option parsing.
//
// Copyright 2001, KUN.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

// $Id: options.h,v 1.8 2001/05/09 09:58:20 ejv Exp $

#ifndef options_h
#define options_h

#include <sys/types.h>
#include <vector>
#include <string>

#include "globals.h"

class Options
{
    private:
        bool force_compile;
        bool verbose_option;
        string outfile;
        string lex_interface_file;
        vector<string> infiles;

        void show_synopsis();
        void show_help();
        void say_hello();
        void show_version();
        string substitute_extension(string str, string ext1, string ext2);

    public:
        Options(int argc, char* const argv[]);

        bool force_compilation() const;
        bool verbose() const;
        string get_output_filename() const;
        string get_lifname() const;
        size_t get_nr_input_files() const;
        void add_input_filename(const string name);
        string get_input_filename(off_t idx) const;
};

inline bool Options::force_compilation() const
{
    return force_compile;
}

inline bool Options::verbose() const
{
    return verbose_option;
}

inline string Options::get_output_filename() const
{
    return outfile;
}

inline string Options::get_lifname() const
{
    return lex_interface_file;
}

inline size_t Options::get_nr_input_files() const
{
    return infiles.size();
}

inline string Options::get_input_filename(off_t idx) const
{
    return infiles[idx];
}

inline void Options::add_input_filename(const string name)
{
    infiles.push_back(name);
}

#endif // options_h
