// Class definition of the LexTextAffixList, stored in the .blf file.
//
// Copyright 2001, KUN
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

// $Id: lextextaffixlist.h,v 1.5 2001/03/20 14:46:32 ejv Exp $


#ifndef lextextaffixlist_h
#define lextextaffixlist_h

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif // HAVE_CONFIG_H

#include <map>
#include <vector>
#include <string>
#include <iostream.h>

#include "lexfileio.h"
#include "paramtab.h"

typedef map<string,unsigned> text_aff_t;
typedef vector<text_aff_t::iterator> text_aff_index_t;

class LexTextAffixList
{
    private:
        text_aff_t affixes;
        text_aff_index_t affixes_index;

    public:
        unsigned add_affix(string aff);
        unsigned get_index(string aff);
        unsigned get_index(ParamID id);

        void dump();

        inline size_t size() { return affixes.size(); };
        string search_by_index(unsigned idx);
};

ofstream& operator <<(ofstream &ofs, LexTextAffixList &l);

inline unsigned
LexTextAffixList::get_index(ParamID id)
{
    return get_index(idtable.to_string(id));
}


#endif // lextextaffixlist_h
