// Lexicon file writing routines.
//
// Copyright 2001, KUN
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

// $Id: lexfileio.h,v 1.6 2001/03/20 14:46:32 ejv Exp $


#ifndef lexfileio_h
#define lexfileio_h

#include <sys/types.h>
#include <fstream.h>
#include <string>

typedef unsigned long SET;


inline void
write_lex_long(ofstream &ofs, long l)
{
    ofs.write((char*)&l, sizeof(long));
}

inline void
write_lex_set(ofstream &ofs, SET l)
{
    write_lex_long(ofs, (long)l);
}

inline void
write_lex_byte(ofstream &ofs, char l)
{
    ofs.write(&l, sizeof(char));
}

inline void
write_lex_word(ofstream &ofs, long w)
{
    char high = (w >> 8) & 0xff;
    char low = w & 0xff;

    write_lex_byte(ofs, high);
    write_lex_byte(ofs, low);
}

inline void
write_lex_string(ofstream &ofs, const char* s)
{
    ofs.write(s, strlen(s) + 1);
}

inline void
write_lex_string(ofstream &ofs, string s)
{
    write_lex_string(ofs, s.c_str());
}

inline void
write_lex_index(ofstream &ofs, off_t index)
{
    ofs.write((char*)&index, sizeof(off_t));
}

inline void
write_lex_size(ofstream &ofs, size_t size)
{
    ofs.write((char*)&size, sizeof(size_t));
}

inline void
write_lex_bool(ofstream &ofs, bool b)
{
    char val;

    if (b) {
        val = 'T';
    } else {
        val = 'F';
    }

    write_lex_byte(ofs, val);
}

#endif // lexfileio_h
