// Lexicon EntryList index routines
//
// Copyright 2001, KUN.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

// $Id: lexentrylistidx.cc,v 1.4 2001/03/20 14:46:32 ejv Exp $

#include "lexentrylistidx.h"
#include <stdlib.h>
#include "lexfileio.h"

LexEntryListIdx::LexEntryListIdx() {
    next_free_idx = 0;
}

void
LexEntryListIdx::dump() {
    unsigned ptr = 0;

    cout << "---- LexEntryListIdx::dump" << endl;
    for (unsigned i = 0; i < list_index.size(); ++i) {
        LexEntryList_t::iterator iter = list_index[i];
        ptr = iter->second.second;
        
        for (unsigned j = 0; j < iter->second.first.size(); ++j) {
            cout << "\t" << ptr << ": ";
            cout << "(" << lex_entry_list.get_index((iter->second.first)[j]);
            cout << ", ";

            if (j + 1 == iter->second.first.size()) {
                cout << "-1)";
            } else {
                cout << ptr + 1 << ")";
            }

//            cout << "\t" << (list[i].first)[j];
            cout << endl;

            ptr++;
        }
    }
    cout << "----" << endl;
}

ofstream&
operator <<(ofstream& ofs, LexEntryListIdx& l) {
    write_lex_size(ofs, l.size());

    for (unsigned i = 0; i < l.size(); ++i) {
        pair<unsigned,int> p = l.get_idx_and_ptr_by_index(i);
        unsigned idx = p.first;
        unsigned ptr = p.second;

        write_lex_index(ofs, idx);
        write_lex_index(ofs, ptr);
    }

    return ofs;
}

pair<unsigned,int>
LexEntryListIdx::get_idx_and_ptr_by_index(unsigned idx) {
    if (idx >= next_free_idx) {
        cerr << "Internal error in LexEntryListIdx::get_idx_and_ptr_by_index: unknown index " << idx << endl;
        exit(1);
    }

    unsigned ptr = 0;

    for (unsigned i = 0; i < list_index.size(); ++i) {
        LexEntryList_t::iterator iter = list_index[i];

        for (unsigned j = 0; j < iter->second.first.size(); ++j) {
            if (ptr == idx) {
                unsigned a = lex_entry_list.get_index((iter->second.first)[j]);
                int b;

                if (j + 1 == iter->second.first.size()) {
                    b = -1;
                } else {
                    b = ptr + 1;
                }
                return pair<unsigned,int>(a,b);
            }

            ptr++;
        }
    }

    // This can't happen
    cerr << "Internal error in LexEntryListIdx::get_idx_and_ptr_by_index: index " << idx << " not found" << endl;
    exit(1);
}

