// Class definition for the lexicon entry list, stored in the .blf file.
//
// Copyright 2001, KUN
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

// $Id: lexentrylist.h,v 1.5 2001/10/09 11:59:17 ejv Exp $


#ifndef lexentrylist_h
#define lexentrylist_h

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif // HAVE_CONFIG_H

#include <fstream.h>
#include <vector>
#include <map>
#include "entry.h"
#include "lexfileio.h"

typedef vector<unsigned> LenArray;

typedef struct
{
    long nont_idx;
    PENALTY penalty;
    LenArray par_list;
} LexEntryEl;

typedef pair<Entry,unsigned> entry_idx_pair_t;
typedef map<string,entry_idx_pair_t> entries_t;
typedef vector<entries_t::iterator> entries_index_t;

class LexEntryList
{
    private:
        entries_t entries;
        entries_index_t entries_index;

        vector<LexEntryEl> entrytable;
        Entry search_index(unsigned idx);
        LenArray generate_param_indexes(Entry e);
        entries_t::iterator get_from_entries_by_idx(unsigned idx);

    public:
        int get_index(Entry &e);
        void add_entry(Entry& e);
        void add_entrylist(EntryList &l);

        void generate_table();
        void dump();
        inline unsigned size() { return entrytable.size(); };
        inline LexEntryEl search_lexentryel_by_index(unsigned idx)
        {
            return entrytable[idx];
        };
};

inline int
LexEntryList::get_index(Entry &e)
{
    entries_t::iterator i = entries.find(e.to_string());
    if (i != entries.end()) {
        return i->second.second;
    } else {
        return -1;
    }
}

inline entries_t::iterator LexEntryList::get_from_entries_by_idx(unsigned idx)
{
    return entries_index[idx];
}

inline void
LexEntryList::add_entry(Entry& e)
{
    int index = get_index(e);
    
    if (index == -1) {
        index = entries.size();
        entries_index.push_back(entries.insert(entries.begin(),
                                make_pair(e.to_string(),
                                          entry_idx_pair_t(e, index))));
    }
}

inline void
LexEntryList::add_entrylist(EntryList &l)
{
    for (unsigned i = 0; i < l.size(); ++i) {
        add_entry(l[i]);
    }
}

ofstream& operator <<(ofstream& ofs, LexEntryList& l);

#endif // lexentrylist_h
