// Global definitions for the lexicon system.
//
// Copyright 2001, KUN
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

// $Id: globals.h,v 1.9 2001/10/11 10:16:38 ejv Exp $


#ifndef globals_h
#define globals_h

#include <stream.h> // for dec(long)
#include <string>
#include <stdio.h>

#include "avltrie.h"
#include "paramtab.h"
#include "affixtab.h"
#include "nonttab.h"
#include "entry.h"
#include "lexentrylistidx.h"
#include "lexnontermlist.h"
#include "lexaffixnamelist.h"
#include "lexentrylist.h"
#include "lextextaffixlist.h"
#include "lexintaffixlist.h"

#define MaxSetSz 32

extern const string prog_name;
extern const string version;
extern const string dat_ext;
extern const string lex_ext;
extern const string lif_ext;

extern AffixTable affix_table;          // for stroing affix sets
extern ParamTable param_table;          // for storing parameter lists
extern NontermTable nonterm_table;	// for storing nonterminals
extern AvlTrie rule_table;              // for storing lexemes with entries

extern LexEntryListIdx lex_entry_list_idx; // list of offset to entry list
extern LexNontermList lex_nonterm_list;
extern LexAffixNameList lex_affixname_list;
extern LexEntryList lex_entry_list;
extern LexTextAffixList lex_textaffix_list;
extern LexIntAffixList lex_intaffix_list;
extern vector<string> lex_modules;

extern double frequency_sum;

#endif // globals_h
