// Entry class implementation
//
// Copyright 2001, KUN.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

// $Id: entry.cc,v 1.9 2001/10/11 12:34:17 ejv Exp $

#include <iostream.h>

#include "entry.h"

void
Entry::print(ostream& os) const {
    os << line_nr << '\t' << freqpen.freq << '\t' << *nonterm;
}

ostream&
operator <<(ostream& os, const Entry& entry) {
    entry.print(os);
    return os;
}

void
EntryList::print(ostream& os) const {
    ostream_iterator<Entry> out(os, "\n");
    copy(begin(), end(), out);
}

ostream&
operator <<(ostream& os, const EntryList& entries) {
    entries.print(os);
    return os;
}

string
EntryList::to_string()
{
    string res;
    iterator first = begin();
    iterator last = end();

    for (iterator iter = first; iter != last; iter++) {
        res = res + iter->to_string() + ",";
    }

    return res;
}

EntryList::iterator
EntryList::already_stored(iterator el)
{
    for (iterator i = begin(); i != end(); ++i) {
        if (*(el->nonterm) == *(i->nonterm)) {
            return i;
        }
    }

    return NULL;
}

void
EntryList::append(EntryList& entries)
{
    for (EntryList::iterator i = entries.begin(); i != entries.end(); ++i) {
        EntryList::iterator el = already_stored(i);
        if (!el) {
            push_back(*i);
        } else {
            el->freqpen.freq += i->freqpen.freq;
        }
    }
}

