// .dat file parser wrapper
//
// Copyright 2001, KUN.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

// $Id: datparser.cc,v 1.8 2001/05/09 09:56:35 ejv Exp $

#include <errno.h>
#include <stdlib.h>
#include "datparser.h"

// Hack:
extern string current_module_name;

DatParser::DatParser(string f_name):
    filename(f_name)
{
    current_module_name = filename;
    filename += dat_ext;
    yyin = fopen(filename.c_str(), "r");
    reset_scanner_counters();
    parser_error = NULL;
}

bool
DatParser::parse()
{
    if (!yyin) {
        cerr << "Error opening \"" << filename << "\": " << strerror(errno) << endl;
        return false;
    }

    int ret = yyparse();

    if (ret != 0) {
        cerr << filename << ":" << get_line_nr() << ":" << get_col_nr()
             << ": " << parser_error << endl;
    }

    return (ret == 0) && (error_occured == 0);
}
