/*
 * This file contains the definitions of the input/output functions.
 *
 * Copyright 2000 KUN.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* $Id: rtsio.h,v 1.16 2002/01/12 16:48:27 ejv Exp $ */

#ifndef rtsio_h
#define rtsio_h

#include "rtslex.h"

#define MAXINPUT 8192

void InitIO();
void EndIO();

int output_is_redirected();
int output_is_buffered();

/*
 * All parsings are buffered. One can only access the current parsing.
 */
void parse_results_start_new();
unsigned parse_results_get_nr_parses();
long parse_results_get_max_penalty();
void current_parse_set_prio_and_add(long prio,
                                    StateIndicator pos,
                                    unsigned length);
void current_parse_add_string(const char *);
void current_parse_add_space(const int);
void current_parse_add_char(const char);
void current_parse_add_int(const int);
void current_parse_printf(const char* fmt, ...);
void parse_results_dump();
void parse_results_destroy();
void parse_results_init();
StateIndicator get_statenode_from_first_parse();
unsigned get_length_from_first_parse();

/*
 * ...
 */
int read_input_line();
int read_input_block(char lf_subst);
const char* get_input_text();

void maybe_output_sync();

void rtsMessage(char *, ...);
void rtsBug(char *, char *, ...);
void rtsAbort(char *, char *, ...);
void rtsFatal(char *, ...);
void rtsError(char *, ...);
void rtsWarning(char *, ...);
void rtsExit(int);


#ifdef GEN_RTS
/*
**------------------------------------------------------------------------------
** Output handling for generative grammars:
**------------------------------------------------------------------------------
*/

void gen_output_init(unsigned line_nr);
void gen_output_add_token(const char* txt);
void gen_output_remove_token();
void gen_output_show();
void gen_output_free();

#endif /* GEN_RTS */

#endif /* rtsio_h */
