/* machdep.dos -- DOS specific part of machdep.h for GNU assembler
 *
 * Copyright 2001, KUN.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* "$Id: machdep.dos,v 1.3 2001/10/17 09:30:13 ejv Exp $" */

#define LONG_MAX				2147483647
#define GLOBAL(name)				.globl	name
#define	LONG(nr)				.long	nr
#define BYTE(nr)				.byte	nr
#define	TEXT(string)				.asciz	string
#define ALIGN					.align	8
#define	STARTCODE				.data 
#define	ENDCODE					.long	0
#define INSTR					.long
/* machdep.common -- machine independent part of machdep.h
 *
 * Copyright 2001, KUN.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* $Id: machdep.common,v 1.25 2001/10/17 09:30:13 ejv Exp $ */

/* Generic nonterminal routine instructions: */
#define	CREATE(nr_formals,nr_locals,nr_sons)	INSTR	1,nr_formals,nr_locals,nr_sons
#define CONT(routine1,routine2)			INSTR	2,routine1,routine2
#define	FAIL					INSTR	3

/* Instructions to call rules: */
#define CALL(rulenr,ptr,fail)			INSTR	4,rulenr,ptr,fail
#define UCALL(nr)				INSTR	5,nr

/* Instructions concerning affixes: */
#define	INIT_I(local,val)			INSTR	6,local,val
#define INIT_S(local,val)			INSTR	7,local,val
#define	INIT_T(local,val)			INSTR	8,local,val
#define INIT_V(a,b)				INSTR	9,a,b

#define ADJUST_I(local,param,fail)		INSTR	10,local,param,fail
#define ADJUST_S(local,param,fail)		INSTR	11,local,param,fail
#define ADJUST_T(local,param,fail)		INSTR	12,local,param,fail
#define ADJUST_V(local,param,fail)		INSTR	13,local,param,fail

#define	UADJUST_I(local,param)			INSTR	14,local,param
#define	UADJUST_S(local,param)			INSTR	15,local,param
#define	UADJUST_T(local,param)			INSTR	16,local,param
#define UADJUST_V(local,param)			INSTR	17,local,param

#define	RESTRICT_I(local,val,fail)		INSTR	18,local,val,fail
#define	RESTRICT_S(local,val,fail)		INSTR	19,local,val,fail
#define	RESTRICT_T(local,val,fail)		INSTR	20,local,val,fail
#define RESTRICT_V(local,val,fail)		INSTR	21,local,val,fail

#define	URESTRICT_I(local)			INSTR	22,local
#define	URESTRICT_S(local)			INSTR	23,local
#define	URESTRICT_T(local)			INSTR	24,local
#define URESTRICT_V(local)			INSTR	25,local

/* matching */
#define MATCH(termnr,local,fail)		INSTR	26,termnr,local,fail
#define UMATCH					INSTR	27
#define SKIP_RE(termnr,local,fail)		INSTR	28,termnr,local,fail
#define MATCH_RE(termnr,local,fail)		INSTR	29,termnr,local,fail
#define UMATCH_RE				INSTR	30

#define LEX_MATCH(nontnr,fail)			INSTR	31,nontnr,fail
#define LEX_UMATCH(nontnr)			INSTR	32,nontnr

/* penalties */
#define PENALTY(nr,fail)			INSTR	33,nr,fail
#define UPENALTY(nr)				INSTR	34,nr

/* commit */
#define COMMIT(fail)				INSTR	35,fail

/* blurb */
#define SUCCESS(fail)				INSTR	36,fail
#define USUCCESS				INSTR	37
#define END(no1,no2)				INSTR	38,no1,no2
#define PASS2(trans,tree)			INSTR	39,trans,tree

/* second pass */
#define RETRN					INSTR	40
#define PUSH_F(nr)				INSTR	41,nr
#define PUSH_L(nr)				INSTR	42,nr
#define PRINT_SON(nr)				INSTR	43,nr

#define PRINT_ABEG(ptr)				INSTR	44,ptr
#define PRINT_AEND				INSTR	45
#define PRINT_PBEG				INSTR	46
#define PRINT_PSEP				INSTR	47
#define PRINT_PEND				INSTR	48

#define PRINT_VAL(ptr)				INSTR	49,ptr
#define PRINT_TERM(nr)				INSTR	50,nr
#define PRINT_LEX(nr)				INSTR	51,nr
#define PRINT_RE(nr)				INSTR	52,nr

#define PRINT_PEN(nr)				INSTR	53,nr

#define PRINT_N(ptr)				INSTR	54,ptr
#define PRINT_IL(nr)				INSTR	55,nr
#define PRINT_SL(aff_val,aff_dom)		INSTR	56,aff_val,aff_dom
#define PRINT_TL(nr)				INSTR	57,nr
#define PRINT_VL				INSTR	58
#define PRINT_IF(nr)				INSTR	59,nr
#define PRINT_SF(aff_val,aff_dom)		INSTR	60,aff_val,aff_dom
#define PRINT_TF(nr)				INSTR	61,nr
#define PRINT_VF				INSTR	62

/* Optimization instructions: */
#define TMEMO(nr,fail)				INSTR	63,nr,fail
#define TSMEMO(nr,fail)				INSTR	64,nr,fail
#define SMEMO_S(nr)				INSTR	65,nr

/* Generating instructions: */
#define CHOICE(choice_nr,nr_alts)		INSTR	66,choice_nr,nr_alts
#define UCHOICE(choice_nr)			INSTR	67,choice_nr
#define ALT_MARKER(next_alt)			INSTR	68,next_alt
#define UALT_MARKER				INSTR	69

/* Positive memo instruction: */
#define ROOT_CALL(rulenr,ptr,fail)		INSTR	70,rulenr,ptr,fail
#define	ROOT_CREATE(nr_formals,nr_locals,nr_sons) INSTR	71,nr_formals,nr_locals,nr_sons

/* Left Recursion markers: */
#define NO_LREC_MARKER(next_alt)		INSTR	72,next_alt
#define LREC_MARKER(next_alt)			INSTR	73,next_alt

/* Trace instruction: */
#define TRACE(data)                             INSTR   74,data
