/*
   File: lxcn_voc_iterator.h
   Defines an iterator over a Vocabulary.
   
   Copyright 2009 Radboud University of Nijmegen
 
   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: $Id$
  
   Typical use:
  
    void
    dump_trie(Vocabulary voc)
    {
	struct VocStack *stack;
	char *key;
	int *info;
	int more;

	stack = lxcn_start_iteration(voc);
	more = lxcn_first_iteration(stack, &key, &info);
	while (more) {
	    fprintf(stderr, "%s -> %d\n", key, *info);
	    abs_free(key, "key");
	    more = lxcn_next_iteration(stack, &key, &info);
	}
	lxcn_end_iteration(stack);
    }
*/

struct VocStack;

struct VocStack *lxcn_start_iteration(Vocabulary t);
void lxcn_end_iteration(struct VocStack *stack);
int lxcn_first_iteration(struct VocStack *stack, char **search_key, int **info);
int lxcn_next_iteration(struct VocStack *stack, char **search_key, int **info);

struct VocBinIter;

struct VocBinIter *lxcn_bin_start_iteration(char *path);
void lxcn_bin_end_iteration(struct VocBinIter *vi);
int lxcn_bin_next_iteration(struct VocBinIter *vi, char **search_key, int *info);
