/*
   File: abase_warshall.c
   Implements Warshalls algorithm
  
   Copyright 2009 Radboud University of Nijmegen

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id$"
*/

/* general includes */
#include <stdio.h>

/* local includes */
#include "abase_memalloc.h"
#include "abase_warshall.h"

char *abs_warshall (int n, char *rel)
	{ /* Allocate array for result relation */
	  char *result = (char *) abs_calloc (n*n, sizeof (char), "abs_warshall");
	  int i,j,k;

	  /* Copy the original relation into the result */
	  for (i=0; i<n; i++)
	     for (j=0; j<n; j++) result[i * n + j] = rel[i * n + j];

	  /* Take closure */
	  for (k=0; k<n; k++)
	     for (i=0; i<n; i++)
		for (j=0; j<n; j++)
		   result[i * n + j] = result[i * n + j] ||
			(result[i * n + k] && result [k * n + j]);

	  return (result);
	};
