/*
   File: abase_pool_alloc.h
   Defines pooled memory allocation routines

   Copyright 2009 Radboud University of Nijmegen

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id$"
*/
#ifndef IncAbasePoolAlloc
#define IncAbasePoolAlloc

#ifdef __cplusplus
extern "C" {
#endif

#include <stdlib.h>

/* General allocation routines */
typedef struct abs_pool *Pool;
Pool  abs_pool_init             (size_t basesize, size_t increment);
void *abs_pool_malloc           (Pool, size_t size, const char *place);
void *abs_pool_malloc_unaligned (Pool, size_t size, const char *place);
void *abs_pool_calloc           (Pool, const size_t nr, const size_t size, const char *place);
char *abs_pool_new_string       (Pool, const char *old, const char *place);
char *abs_pool_new_fmtd_string  (Pool, const char *place, const char *format, ...);
void  abs_pool_free  (Pool, const char *place);
void  abs_pool_stats (Pool, const char *place);

#ifdef __cplusplus
}
#endif
#endif /* IncAbasePoolAalloc */
