/*
   File: abase_error.c
   Defines routines for diagnostic messages

   Copyright 2009 Radboud University of Nijmegen

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id$"
*/

/* standard includes */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /* HAVE_CONFIG_H */

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

/* local includes */
#include "abase_porting.h"
#include "abase_error.h"

/* Various modes of failure */
void abs_exit (int error)
	{ exit (error);
	};

void abs_fatal (char *format, ...)
	{ va_list argp;

	  fprintf (stderr, "Fatal error: ");
	  va_start (argp, format);
	  vfprintf (stderr, format, argp);
	  va_end (argp);

	  fprintf (stderr, "\n");
	  abs_exit (1);
	};

void abs_abort (char *location, char *format, ...)
	{ va_list argp;

	  fprintf (stderr, "Abort (%s): ", location);
	  va_start (argp, format);
	  vfprintf (stderr, format, argp);
	  va_end (argp);

	  fprintf (stderr, "\n");
	  abs_exit (1);
	};

void abs_bug (char *location, char *format, ...)
	{ va_list argp;

	  fprintf (stderr, "Abort (%s): ", location);
	  va_start (argp, format);
	  vfprintf (stderr, format, argp);
	  va_end (argp);

	  fprintf (stderr, "\nPlease contact agfl@cs.ru.nl\n");
	  abs_exit (1);
	};

void abs_error (char *format, ...)
	{ va_list argp;

	  fprintf (stderr, "Error: ");
	  va_start (argp, format);
	  vfprintf (stderr, format, argp);
	  va_end (argp);

	  fprintf (stderr, "\n");
	};

void abs_warning (char *format, ...)
	{ va_list argp;

	  fprintf (stderr, "Warning: ");
	  va_start (argp, format);
	  vfprintf (stderr, format, argp);
	  va_end (argp);

	  fprintf (stderr, "\n");
	};

void abs_message (char *format, ...)
	{ va_list argp;

	  va_start (argp, format);
	  vfprintf (stderr, format, argp);
	  va_end (argp);
	  fprintf (stderr, "\n");
	};

void abs_printf (char *format, ...)
	{ va_list argp;

	  va_start (argp, format);
	  vfprintf (stderr, format, argp);
	  va_end (argp);
	};

void abs_vprintf (char *format, va_list ap) 
	{ 
	  vfprintf (stderr, format, ap);
	};
