/*
   File: lexer.h
   Lexical analyzer for Lexicon, Fact, Triple and Lexicon Interface files

   Copyright 2009 Radboud University of Nijmegen

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id$"
*/
#ifndef IncLexer
#define IncLexer

/* Libabase includes */
#include <abase_repr.h>

/* Define the kind of files we can lex */
#define MAX_LEX_LINE_LEN 1023

#define TERMINAL_PLACEHOLDER	-1

typedef enum file_kind_tag { lexicon, fact, triple, lexicon_interface, relators } file_kind;
char *suffix_from_file_kind (file_kind kind);

/* Exported actions */
void parse_error (char *format, ...);
void parse_warning (char *format,...);
int try_open_lexer_file (char *base_name, file_kind kind);
void close_lexer_file ();

/* Lexing actions */
void lexer_read_line ();
void may_skip_white_space ();
int is_eof ();
int is_end ();
void should_be_eof ();
int is_eoln ();
void should_be_eoln ();
void skip_eoln ();
int is_char (char ch);
void should_be_char (char ch);

int is_comment ();
int is_lif_column_separator ();
void should_be_lif_column_separator ();
int is_lif_section_separator ();
int is_unsigned_number (int *ret_nr);
void should_be_unsigned_number (int *ret_nr);
int is_signed_number (int *ret_nr);
void may_be_signed_number (int *ret_nr);
int is_name (char *dest_buffer);
void should_be_name (char *dest_buffer);
int is_nonterminal_name (char *dest_buffer);
void should_be_nonterminal_name (char *dest_buffer);
int is_relation (char *dest_buffer);
void should_be_relation (char *dest_buffer);
int is_string (char *dest_buffer);
void should_be_string (char *dest_buffer);
int is_string_with_expansion (char *dest_buffer);
void should_be_string_with_expansion (char *dest_buffer);
int should_be_string_up_to (char *dest_buffer, char terminator);
int is_bitset (Bitset64 *ret_val);
void should_be_bitset (Bitset64 *ret_val);
int is_lhs_or_rhs (int *ret_val);
void should_be_lhs_or_rhs (int *ret_val);
int is_word_form (char *dest_buffer, int *ret_marker);
void should_be_word_form (char *dest_buffer, int *ret_marker);
int is_placeholder_terminal (char *dest_buffer, int *ret_marker);

#endif /* IncLexer */
