/*
   File: abase_porting.h
   Defines macros to generate code compilable for WIN32, MINGW and GNU

   Copyright 2009 Radboud University of Nijmegen

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id$"
*/
#ifndef IncAbasePorting
#define IncAbasePorting

/*
   Include generated config.h if we have it
*/
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*
   Define the 64 bit ints and constants
*/
#if defined(WIN32) && !defined(MINGW)

/* WIN32 with Visual C++ */
typedef unsigned char uint8_t;
typedef unsigned short uint16_t;
typedef int int32;
typedef unsigned int u_int32;
typedef __int64 int64;
typedef unsigned __int64 u_int64;

#define u_int64_const(x) (x##ui64)
#define int64_const(x) (x##i64)
#include <limits.h>
#include <sys/types.h>
#include <windows.h>
#include <io.h>

/* Define macros to indicate to VC what to do */
#define STDC_HEADERS
#define HAVE_STRING_H
#define REGEX_MALLOC

/* Define maximum path length */
#define MAXPATHLEN 255

/* Define strcasecmp (BSD 4.4) in other terms */
#define strcasecmp(a,b) stricmp(a,b)

/* Define directory separator */
#define DIRSEP '\\'

#else
/* MINGW with gcc */
/* Unix with gcc */
#include <stdint.h>
#include <limits.h>
#include <sys/types.h>
#include <sys/param.h>
#include <unistd.h>

typedef int32_t int32;
typedef uint32_t u_int32;
typedef uint64_t u_int64;
typedef int64_t int64;

#define u_int64_const(x) (x##ULL)
#define int64_const(x) (x##LL)

#ifdef MINGW
#include <windows.h>
#define DIRSEP '\\'
#else
#define DIRSEP '/'
#endif /* NoMINGW */
#endif /* WIN32 && !MINGW */

/* Define the maximum string length */
#define MAXSTRLEN 65536

#if !HAVE_VSNPRINTF
#define __restrict	/* empty, as long as there is no configure check */
/*
 * If we don't have vsnprintf(3), implement it using vsprintf(3),
 * and check for buffer overflow. If detected, abort(3).
 * Not perfect, but at least you're warned where it happens.
 */
int vsnprintf(char * __restrict str, size_t size, const char * __restrict format, va_list ap);
#endif /* !HAVE_VSNPRINTF */

#endif /* IncAbasePorting */
