/*
   File: abase_mm_alloc.h
   Defines managed memory allocation routines

   Copyright 2009 Radboud University of Nijmegen

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id$"
*/
#ifndef IncAbaseMmAlloc
#define IncAbaseMmAlloc

#ifdef __cplusplus
extern "C" {
#endif

#include <stdlib.h>

/* General allocation routines */
void abs_mm_init ();
void *abs_mm_malloc (const size_t size, const char *place);
void *abs_mm_calloc (const size_t nr, const size_t size, const char *place);
char *abs_mm_new_string (const char *old, const char *place);
char *abs_mm_new_fmtd_string (const char *place, const char *format, ...);
void abs_mm_intermediate_free (const char *place);
void abs_mm_final (const char *place);

#ifdef __cplusplus
}
#endif
#endif /* IncAbaseMmAalloc */
