/*
   File: abase_debug.h
   Defines routines for debugging purposes

   Copyright 2009 Radboud University of Nijmegen
 
   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id$
*/
#ifndef IncAbaseDebug
#define IncAbaseDebug

#ifdef __cplusplus
extern "C" {
#endif

#ifdef DEBUG

#ifndef DEBUG_LEVEL
#define DEBUG_LEVEL 0
#endif

#include <assert.h>
#include <stdio.h>
#include "abase_error.h"
#define DB(x)   x
#define DB_IF(c) if (c < DEBUG_LEVEL) { 
#define DB_ELSE  } else {
#define DB_END   }

#else /* DEBUG */

#define DB(x)
#define DB_IF(c)
#define DB_ELSE
#define DB_END

#endif /* DEBUG */

#ifdef __cplusplus
}
#endif
#endif /* IncAbaseDebug */
