/*
   File: util.c
   Defines utility functions for agflcoder
 
   Copyright 2009-2010 Radboud University of Nijmegen

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id$"
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /* HAVE_CONFIG_H */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#ifndef WIN32
#include <sys/time.h>
#include <sys/times.h>
#endif

/* Libabase includes */
#include <abase_error.h>
#include <abase_version.h>

/* Include CDL3 types */
#ifdef MCDL
#include <mrts_mcdl.h>
#include <mrts_stdtypes.h>
#else 
#include <cdl3rts.h>
#endif /* MCDL */

#include "util.h"

#ifdef DEBUG_GEN
#define DB(x) x
#else
#define DB(x)
#endif

/*------------------------------------------------------------------------------
// Cdl3 support
//----------------------------------------------------------------------------*/

/*------------------------------------------------------------------------------
// FUNCTION watch (INT>)
//
// Description:
//	Return time elapsed since previous call of watch();
//	INT:	elapsed time in deci-seconds.
//
// Side effects:
//	Watch stores the current time as local state.
//
// TODO: Timer for WIN32 always returns 0.
//----------------------------------------------------------------------------*/
void E216_watch_INT (value *ret_int)
{
#ifndef WIN32
#ifdef MCDL
  *ret_int = Create_INT (0L);
#else /* Old CDL3 compiler */
  *ret_int = C_INT(0);
#endif /* MCDL */
  static struct timeval old;
  struct timeval new;
  gettimeofday(&new,NULL);
#ifdef MCDL
  *ret_int = Create_INT ((new.tv_sec-old.tv_sec)*10+(new.tv_usec-old.tv_usec)/100000);
#else /* Old CDL3 compiler */
  *ret_int = C_INT((new.tv_sec-old.tv_sec)*10+(new.tv_usec-old.tv_usec)/100000);
#endif /* MCDL */
  old.tv_sec=new.tv_sec;
  old.tv_usec=new.tv_usec;
#endif /* WIN32 */
}

/*------------------------------------------------------------------------------
// FUNCTION get config version (TEXT>)
//
// Description: Returns current version of AGFL environment
//----------------------------------------------------------------------------*/
void E300_get_config_version_TEXT (value *ret_text)
{
#ifdef MCDL
  *ret_text = Create_TEXT (AGFL_VERSION);
#else /* Old CDL3 compiler */
  *ret_text = C_TEXT (AGFL_VERSION);
#endif /* MCDL */
}


/*------------------------------------------------------------------------------
// ACTION show memory usage */
//
// Description: Reports current memory usage
// Note for MCDL: directly calls abs_report_meminfo
//----------------------------------------------------------------------------*/
#ifndef MCDL
void E301_show_memory_usage ()
{ abs_report_meminfo ();
}
#endif /* MCDL */
