/*
   File: arts_tracer.h
   Defines the tracer of the grammar.

   Copyright 2010 Radboud University of Nijmegen
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

*/

void clear_parse_stack();
void push_parse_call(int ruleno);
void pop_parse_call();
void save_parse_call_stack();
void print_parse_call_stack (State si);
void print_saved_parse_call_stack();

#define ENABLE_INTERACTIVE_TRACER	0

#if ENABLE_INTERACTIVE_TRACER
int tracer_start_alt(int altnr, DATA *fp, Trellis t, State i_state);
void tracer_end_alt(int altnr, DATA *fp, Trellis t, State i_state);
#endif /* ENABLE_INTERACTIVE_TRACER */
