/*
   File: arts_timers.h
   RTS timing routines definitions.

   Copyright 2009 Radboud University of Nijmegen

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id$"
*/
#ifndef IncArtsTimers
#define IncArtsTimers

typedef double Time;	/* time in seconds */

void reset_timers ();
void restart_parse_time ();

void set_time_out (int max);
int have_time_out ();

void start_scan_time ();
void stop_scan_time ();
Time get_scan_time ();
Time get_total_scan_time ();

void start_parse_time ();
void stop_parse_time ();
Time get_parse_time ();
Time get_total_parse_time ();

void start_print_time ();
void stop_print_time ();
Time get_print_time ();
Time get_total_print_time ();
Time get_current_time ();

#endif /* IncArtsTimers */
