/*
   File: arts_io.h
   This file contains the definitions of the input/output functions.
   Copyright 2009-2010 Radboud University of Nijmegen

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id$"
*/
#ifndef IncArtsIO
#define IncArtsIO

#include "arts_ds.h"
#define MAXINPUT 8192

void init_io (void);
void end_io (void);

/* For printing of affixes */
char *conv_mm_set_affix (Bitset64 val, int domain);
void print_set_affix (Bitset64 val, int domain, int in_transduction);
void print_text_affix (char* val, int in_transduction, int quoted);
void print_integer_affix (int val, int in_transduction);
void print_affix (Value val, int domain);

/* All parsings are buffered. One can only access the current parsing.  */
void parse_results_start_new (void);
unsigned parse_results_get_nr_parses (void);
int current_parse_is_acceptable (Penalty penalty, int length);

void current_parse_set_prio_and_add (Penalty prio, State pos, int length);
void current_parse_finish (void);
void current_parse_add_lexeme (char *s);
void current_parse_add_string (char *s);
void current_parse_add_nstring (int, char *s);
void current_parse_add_space (int);
void current_parse_add_char (char);
void current_parse_add_int (int);
void current_parse_printf (char* format, ...);
void may_be_current_parse_add_space (void);
void parse_results_dump (void);
void parse_results_destroy (void);
void parse_results_init (void);

State get_next_state_from_first_parse (void);
unsigned get_length_from_first_parse (void);

/* Maybe in, maybe out */
int read_input_line (void);
int read_input_block (void);
char* get_input_text (void);
int get_input_linenumber (void);
int get_input_position (void);
void maybe_output_sync (int force);
void profile_printf (char *, ...);

#ifdef GEN_RTS
/*------------------------------------------------------------------------------
// Output handling for generative grammars:
//----------------------------------------------------------------------------*/
void gen_output_init (unsigned line_nr);
void gen_output_add_token (char* txt);
void gen_output_remove_token (void);
void gen_output_show (void);
void gen_output_free (void);

#endif /* GEN_RTS */
#endif /* IncArtsIO */
