#!/usr/local/bin/perl -w
#-------------------------------------------------------------------------------
# Synopsis:
#	mk_as_instr.pl [-v] < instr.template
#
# Description:
#	Generates the enumeration type of all opcodes
#	Generates the assembler's recognition table
#	Generates the interpreter's recognition table
#
# Basic assumption:
#	Opcode 0 denotes the nop
#
# CVS ID: "$Id$"
#
# Copyright 2009 Radboud University of Nijmegen
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# CVS ID: "$Id$"
#
#-------------------------------------------------------------------------------
use strict;

# Parse arguments
my $verbose = 0;
while (@ARGV>0)
  { if ($ARGV[0] eq "-v")
      { $verbose = 1;
        shift;
      }
    else
      { usage ("unrecognized parameter"); }
  }

# Keep track of the number of opcodes
my $basename = "opcode";
my $line_nr = 0;
my $opcode_nr = 0;
my $opcode = "";

#
# While parsing we generate the typedef for all opcodes
# as well as the recognition tables
#
open (HDR, ">$basename.h") || die ("could not open header file $basename.h");
open (TAB, ">$basename.tab") || die ("could not open table file $basename.tab");
open (EXE, ">$basename.exc") || die ("could not open exec table file $basename.exc");

#
# Generate headers of respective files
#
print HDR "/*\n";
print HDR "   File: opcode.h\n";
print HDR "*/\n";
print HDR "#ifndef IncOpcode\n";
print HDR "#define IncOpcode\n";
print HDR "typedef enum {\n";

print TAB "/*\n";
print TAB "   File: opcode.tab\n";
print TAB "*/\n";
print TAB "#include \"opcode.h\"\n";
print TAB "struct opcode_table_rec {\n";
print TAB "  char *opcode_name;\n";
print TAB "  int nr_opnds;\n";
print TAB "};\n";
print TAB "static struct opcode_table_rec all_opcodes[] = {\n";

print EXE "/*\n";
print EXE "   File: opcode.exc\n";
print EXE "*/\n";
print EXE "#include <opcode.h>\n";
print EXE "struct exec_table_rec {\n";
print EXE "  char *opcode_name;\n";
print EXE "  int nr_opnds;\n";
print EXE "  exec_proc opcode_exec;\n";
print EXE "};\n";
print EXE "static struct exec_table_rec all_opcode_execs[] = {\n";

#
# Parse the template file
#
while (<>)
  { $line_nr++;

    # lines with a comment sign are ignored
    if (/^#.*$/)
      { next;
      }

    # lines with only white space are also ignored
    elsif (/^\s*$/)
      { next;
      }

    #
    # a line with only letters, digits or underscores,
    # followed by the number of operands
    #
    elsif (/^([a-zA-Z]\w*),\s*(\d+)\s*$/)
      { print HDR "opc_$1,\n";
        print TAB "{ \"",$1,"\", ", $2, " },\n";
	print EXE "{ \"",$1,"\", ", $2, ", exec_", $1, " },\n";
	$opcode_nr++;
      }
    else
      { print STDERR "Unrecognizable instruction name: $_ on line $line_nr"
      }
  }

#
# Generate trailers of files
#
print HDR "} opcode;\n\n";
print HDR "#define nr_of_opcodes $opcode_nr\n";
print HDR "#endif /* IncOpcode */\n";
print TAB "};\n\n";
print EXE "};\n\n";

