/*
   File: lexer.h
   Does lexical analysis of Agfl assembler
  
   Copyright 2009 Radboud University of Nijmegen

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id$"
*/
#ifndef IncLexer
#define IncLexer

/* Libabase includes */
#include <abase_porting.h>

/* Define the tokens, to begin with undefined */
typedef enum { UNDEFINED,

/* General categories */
SYMBOL, NUMBER, SIGNED_NUMBER, STRING,

/* Punctuation marks */
COLON, COMMA, PERIOD,
LEFTPARENTHESIS, RIGHTPARENTHESIS,
EOLN,

/* End of file */
EOFSYMBOL } token;

/* Exported lexer variables */
extern token curr_token;
extern int curr_line;
extern int curr_column;
extern char *curr_sval;
extern u_int64 curr_uval;
extern int64 curr_nval;

/* Error count */
extern int lexer_errors;

/* Exported code */
void init_lexer (FILE *fd, char *fname);
char *get_current_line_buffer ();
void reinit_lexer ();
void read_token ();
void dump_token ();

#endif /* IncLexer */
