/*
   File: lxcn_vocabulary.h
   Stores a vocabulary (by which we mean the datastructure through which
   words can be entered with their appropriate information) for later
   retrieval. Since the number of words in the vocabulary may easily be
   of the order of one million, words are stored in a trie structure.

   Copyright 2009 Radboud University of Nijmegen
 
   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id$"
*/
#ifndef IncLxcnVocabularyImpl
#define IncLxcnVocabularyImpl

#ifdef __cplusplus
extern "C" {
#endif

/* libabase includes */
#include "abase_pool_alloc.h"
#include "lxcn_vocabulary.h"

/*
   Define the structure of a vocabulary
*/
typedef struct voc_index_tree_rec *VocIndexTree;
typedef struct voc_trie_rec *VocTrie;
typedef int VocInfo;

struct voc_rec
	{ VocTrie trie;			/* the actual trie */
	  Pool pool;			/* administation of all used memory */
	};

struct voc_trie_rec
	{ VocIndexTree tails;		/* Balanced tree of subtries */
	  char *search_key;		/* Orig search key */
	  int rem_offset;		/* Tail index in search key */
	  VocInfo info;			/* Associated info: index in feature space */
	};

struct voc_index_tree_rec
	{ VocIndexTree left;		/* Left subtree */
	  VocIndexTree right;		/* Right subtree */
	  VocTrie sub_trie;		/* Associated subtrie */
	  unsigned char key;		/* Search key in index tree */
	  signed char balfac;		/* Balance factor */
	};

/* Introduce nil pointers */
#define voc_index_tree_nil ((VocIndexTree) NULL)
#define voc_trie_nil ((VocTrie) NULL)

#ifdef __cplusplus
}
#endif
#endif /* IncLxcnVocabularyImpl */
