/*
   File: lxcn_vocabulary.h
   Stores a vocabulary (by which we mean the datastructure through which
   words can be entered with their appropriate information) for later
   retrieval. Since the number of words in the vocabulary may easily be
   of the order of one million, words are stored in a trie structure.

   Copyright 2009 Radboud University of Nijmegen
 
   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id$"
*/
#ifndef IncLxcnVocabulary
#define IncLxcnVocabulary

#ifdef __cplusplus
extern "C" {
#endif

/* libabase includes */
#include <abase_fileutil.h>

/*
   Export Vocabulary as opaque struct pointer with access routines
*/
typedef struct voc_rec *Vocabulary;
#define vocabulary_nil ((Vocabulary) NULL)

extern char vocabulary_version[];

/* exported routines */
int *lxcn_enter_into_vocabulary (Vocabulary *voc, char *pattern);
int *lxcn_lookup_in_vocabulary (Vocabulary voc, char *pattern);
void lxcn_dump_vocabulary (Vocabulary voc);
void lxcn_bin_save_trie (BinFile bf, Vocabulary voc);
int lxcn_bin_save_vocabulary (char *path, Vocabulary voc);
struct abs_pool;
void lxcn_bin_pool_load_trie (struct abs_pool *, BinFile bf, Vocabulary *voc);
void lxcn_bin_load_trie (BinFile bf, Vocabulary *voc);
int lxcn_bin_load_vocabulary (char *path, Vocabulary *voc);
void lxcn_free_vocabulary (Vocabulary voc);

/* exported iterator */
typedef void (*VocIterProc)(void *arg, char *key, int info);
void lxcn_iterate_over_vocabulary (Vocabulary voc, VocIterProc vip, void *arg);

#ifdef __cplusplus
}
#endif
#endif /* IncLxcnVocabulary */
