/*
   File: globals.h
   Defines the global variables

   Copyright 2009 Radboud University of Nijmegen

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id$"
*/
#ifndef IncGlobals
#define IncGlobals

/* Liblexicon includes */
#include <lxcn_vocabulary.h>

/* Local include */
#include "dyn_array.h"

/* exported lexicons to be read */
#define DAT_SUFFIX "dat"
#define FCT_SUFFIX "fct"
extern text_array lexicon_names;
extern text_array fact_table_names;
extern text_array triples_database_names;

/* All lexicon markers and vocabularies */
extern int_array all_lexeme_markers;
extern ptr_array all_vocabularies;

/* All fact tables + associated critical text trie */
extern Vocabulary all_critical_texts;
extern int *all_hash_sizes;
extern hash_container *all_fact_tables;

/* Just for reporting, not actually necessary */
extern text_array crit_text_vector;

#endif /* IncGlobals */
