/*
   File: dyn_array.h
   Maintains variable sized arrays of integers, texts and pointers
   Maybe this code should move to libabase.

   Copyright 2009 Radboud University of Nijmegen

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id$"
*/
#ifndef IncDynArray
#define IncDynArray

/* libabase includes */
#include <abase_fileutil.h>

/* Introduce dynamic array types */
typedef struct int_array_rec *int_array;
typedef struct text_array_rec *text_array;
typedef struct ptr_array_rec *ptr_array;

/* Introduce dynamic array nils */
#define int_array_nil ((int_array) NULL)
#define text_array_nil ((text_array) NULL)
#define ptr_array_nil ((ptr_array) NULL)

/* Introduce structure of dynamic arrays */
struct int_array_rec
{ int size;
  int room;
  int *array;
};

struct text_array_rec
{ int size;
  int room;
  char **array;
};

struct ptr_array_rec
{ int size;
  int room;
  void **array;
};

/* Introduce enlargement routines */
void room_int_array  (int_array arr,  int room);
void room_text_array (text_array arr, int room);
void room_ptr_array  (ptr_array arr,  int room);

/* Introduce array allocation + shorthands */
int_array  init_int_array  (int room);
text_array init_text_array (int room);
ptr_array  init_ptr_array  (int room);
#define new_int_array()	 init_int_array(2)
#define new_text_array() init_text_array(2)
#define new_ptr_array()  init_ptr_array(2)

/* Introduce array append */
void app_int_array  (int_array arr,  int el);
void app_text_array (text_array arr, char *el);
void app_ptr_array  (ptr_array arr,  void *el);

/* Introduce searching in arrays */
int is_in_int_array  (int_array arr, int el);
int is_in_text_array (text_array arr, char *el);
int equal_int_array (int_array arr1, int_array arr2);

/* Introduce unique addition to arrays */
void app_sorted_int_array (int_array arr, int el);
void app_uniq_int_array   (int_array arr, int el);
void app_uniq_text_array  (text_array arr, char *el);

/* Introduce some extra typing and nils for hashing */
typedef int_array hash_list;
typedef int_array *hash_container;
#define new_hash_list() init_int_array(4)
#define app_hash_list app_int_array

/* Introduce saving of int and text arrays */
void bin_save_int_array (BinFile bf, int_array arr);
void bin_save_text_array (BinFile bf, text_array arr);
int bin_cmp_int_array (BinFile bf, int_array arr);
int bin_cmp_text_array (BinFile bf, text_array arr);

#endif /* IncDynArray */
