/*
   File: arts_posmemo.h
   Routine definitions for positive memoisation

   Copyright 2009-2010 Radboud University of Nijmegen

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id$"
*/
#ifndef IncArtsPosmemo
#define IncArtsPosmemo

#include <assert.h>

/* Include Arts datastructures */
#include "arts_ds.h"

/* Allocation */
void posmemo_init ();
void posmemo_done ();
void posmemo_dump_table (Trellis trellis);
void posmemo_init_table_entry (PosMemo* entry);
void posmemo_detach_list (PosMemo* entry);
void reset_shared_pos_memos (PosMemo *pos_memos);
void posmemo_print_tree (PosMemo pm_prod);
void detach_posmemo (PosMemo memo, char *comment);

/* Access functions */
int posmemo_is_unknown (StateExtension input_state, int nont_nr);
int posmemo_is_known (StateExtension input_state, int nont_nr);
int posmemo_is_blocked (StateExtension input_state, int nont_nr);
int posmemo_is_unblocked (StateExtension input_state, int nont_nr);
void posmemo_set_blocked (StateExtension input_state, int nont_nr);
void posmemo_update (StateExtension input_state, int nont_nr);

/* Posmemo handling */
PosMemo posmemo_add_production (State input_state, int nont_nr, Penalty penalty,
				int nr_formals, int nr_variables, int nr_sons,
				Value *variables, State target_state, void *pass2,
				hyb_anchor anchor);
void* posmemo_get_pass2 (PosMemo prod);
void* posmemo_get_formal_ptr (PosMemo state);
Value posmemo_get_variable (PosMemo state, int nr);
Value posmemo_get_local (PosMemo state, int nr);
PosMemo posmemo_get_son (PosMemo state, int nr);
Transition posmemo_get_son_transition (PosMemo state, int nr);
Penalty posmemo_get_penalty (PosMemo state);
PosMemo posmemo_get_next_prod (PosMemo curr);
State posmemo_get_next_input_state (PosMemo memo, State here);
int posmemo_is_acceptable (PosMemo curr);
PosMemo posmemo_get_prod_ptr (StateExtension input_state, int nont_nr);
void posmemo_rdump_pmprod (PosMemo pm_prod, int indent);

/* Statistics */
extern int posmemo_known_count;
extern int posmemo_unknown_count;
extern int posmemo_blocked_count;

#endif /* IncArtsPosmemo */
