/*
   File: arts_interpreter.h
   Defines the abstract machine code interpreter
   Runtime system interpreter routines.

   Copyright 2009 Radboud University of Nijmegen

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id$"
*/

#ifndef IncArtsInterpreter
#define IncArtsInterpreter

/* local include */
#include "arts_ds.h"

void arts_init_parser (void);
void arts_end_parser (void);
State parse_trellis (Trellis trellis, State start_node);

int **get_profile_exec (void);
int **get_profile_succ (void);
int **get_profile_parse (void);

void push_ambi_stack (PosMemo prime);
int try_lookup_sibling_in_ambi_stack (PosMemo pmptr, PosMemo *sibling);

#endif /* IncArtsInterpreter */
