/*
   File: arts_ds.c
   Holds the central datastructure of the abstract machine

   CVS ID: "$Id$"
*/

/* Standard includes */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /* HAVE_CONFIG_H */

/* libarts includes */
#include "arts_ds.h"

/* Publicly export the interface structure */
struct interface_rec arts_ifd;

void arts_init_ds ()
{ /* Initialize the grammar and filenames */
  arts_ifd.grammar_name = NULL;
  arts_ifd.input_fname = NULL;
  arts_ifd.output_fname = NULL;
  arts_ifd.input_pos_fname = NULL;

  /* The size of the code, data and rotext segment */
  arts_ifd.code_size = 0;
  arts_ifd.data_size = 0;
  arts_ifd.rotext_size = 0;

  /* The three segments */
  arts_ifd.code = NULL;
  arts_ifd.data = NULL;
  arts_ifd.rotext = NULL;

  /* The lexicon */
  arts_ifd.lexicon = NULL;

  /* Interface section */
  arts_ifd.gra_version = 0;
  arts_ifd.nr_lexicon_nonterminals = 0;
  arts_ifd.nr_terminals = 0;
  arts_ifd.nr_match_regexps = 0;
  arts_ifd.nr_skip_regexps = 0;
  arts_ifd.nr_syntax_nonterminals = 0;
  arts_ifd.nr_lrec_nests = 0;
  arts_ifd.nr_neg_memos = 0;
  arts_ifd.nr_choices = 0;
  arts_ifd.nr_positions = 0;
  arts_ifd.eos_terminal = 0;

  /* Run time options */
  arts_ifd.neg_memo_option = 0;
  arts_ifd.directors_option = 0;
  arts_ifd.hybrid_parsing_option = 0;
  arts_ifd.closed_triple_db_option = 0;
  arts_ifd.no_tdb_option = 0;
  arts_ifd.counters_option = 0;
  arts_ifd.profile_option = 0;
  arts_ifd.trace_option = 0;
  arts_ifd.transduce_option = 0;
  arts_ifd.identity_transduction = 0;
  arts_ifd.label_bracket = 0;
  arts_ifd.no_output = 0;
  arts_ifd.generate_option = 0;
  arts_ifd.graph_option = 0;
  arts_ifd.segment_mode = 0;
  arts_ifd.paragraph_mode = 0;
  arts_ifd.alphabet_fname = "";			/* Default translation */
  arts_ifd.triple_translate = 0;
  arts_ifd.hash_production = 0;
   
  /* Auxilary fields for lexer */
  arts_ifd.white_space_chars = NULL;
  arts_ifd.separator_chars = NULL;
  arts_ifd.radix_pragmat = NULL;
  arts_ifd.translate_src = NULL;
  arts_ifd.translate_dst = NULL;
  arts_ifd.translate_penalties = NULL;

  /* Desirable runtime options */
  arts_ifd.max_parses = INT_MAX;
  arts_ifd.max_posmemo_queue_length = INT_MAX;
  arts_ifd.max_terminal_parses = 1;

  /* Command line options */
  arts_ifd.parsing_stats_option = 0;
  arts_ifd.research_stats_option = 0;
  arts_ifd.lexer_stats_option = 0;
  arts_ifd.total_stats_option = 0;
  arts_ifd.transduce_option = 0;
  arts_ifd.best_parsings_option = 0;
  arts_ifd.lcsdoc_sync_option = 0;
  arts_ifd.max_parsetime = INT_MAX;
  arts_ifd.max_edit_distance = 0;
  arts_ifd.transition_penalties_option = 1;
  arts_ifd.show_posmemo_option = 0;
  arts_ifd.show_triple_lookups_option = 0;
  arts_ifd.triple_stats_option = 0;
  arts_ifd.free_mem_option = 0;
  arts_ifd.kees_option = 0;
  arts_ifd.suppress_identical_transductions = 0;
  arts_ifd.directors_set_posmemos = 1;
  arts_ifd.absorb_equivalents = 0;
  arts_ifd.radix.lexicon_frequency  = 10;
  arts_ifd.radix.tripledb_frequency  = 10;
  arts_ifd.radix.fact_frequency  = 10;
  arts_ifd.radix.penalty = 1;
  arts_ifd.max_penalty = MAX_PENALTY;
  arts_ifd.print_autopos = 1;

  /* Interface to tables */
  arts_ifd.affix_masks = NULL;
  arts_ifd.affix_weights = NULL;
  arts_ifd.nont_formals_domains = NULL;
  arts_ifd.term_negmemo_dir = NULL;
  arts_ifd.match_negmemo_dir = NULL;
  arts_ifd.skip_negmemo_dir = NULL;
  arts_ifd.lex_negmemo_dir = NULL;
  arts_ifd.lrec_nests_table = NULL;
  arts_ifd.lex_nont_nrs_table = NULL;
  arts_ifd.affix_names = NULL;
  arts_ifd.term_names = NULL;
  arts_ifd.nonterm_names = NULL;
  arts_ifd.match_regexp_names = NULL;
  arts_ifd.skip_regexp_names = NULL;
  arts_ifd.term_posmemo_dir = NULL;
  arts_ifd.match_posmemo_dir = NULL;
  arts_ifd.skip_posmemo_dir = NULL;
  arts_ifd.lex_posmemo_dir = NULL;
  arts_ifd.other_posmemo_dir = NULL;

  /* Statistics collection part */
  arts_ifd.nonterminal_profile_table = NULL;
  arts_ifd.alternatives_profile_table = NULL;
  arts_ifd.nr_match_agains = 0;
  arts_ifd.nr_lex_match_agains = 0;
  arts_ifd.nr_fact_match_agains = 0;
};
