/*
   File: abase_repr.h
   Defines the representation of affix values, penalties

   Copyright 2009 Radboud University of Nijmegen

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id$"
*/
#ifndef IncAbaseRepr
#define IncAbaseRepr

/* Local includes */
#include <abase_porting.h>

#ifdef  __cplusplus
extern "C" {
#endif

/*
   Define the representation of affix values
   Note that this representation is to change when affixes
   become represented by a pointer to a tagged structure.
*/
typedef int64 Bitset64;		/* The new type for Bitset */
#define EmptyBitset (int64_const(0))

typedef char *Text;
typedef union
	{ Bitset64 set_par;
	  char *text_par;
	  void *ptr_par;
	  int int_par;
	} Value;

typedef int32 Penalty;

#ifdef  __cplusplus
}
#endif
#endif /* IncAbaseRepr */
