/*
   File: abase_dstring.h
   Handles dynamic strings needed in the runtime system

   Copyright 2009 Radboud University of Nijmegen

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id$"
*/
#ifndef IncAbaseDstring
#define IncAbaseDstring

#ifdef __cplusplus
extern "C" {
#endif

typedef struct dstring_rec
	{ size_t room;
	  size_t len;
	  char *s;
	} *dstring;

dstring abs_init_dstring (size_t room);
void abs_free_dstring (dstring ds);
void abs_append_dstring_c (dstring ds, char v);
void abs_append_dstring (dstring ds, const char *s);
void abs_append_dstring_n (dstring ds, const char *s, size_t n);
void abs_sprintfa_dstring (dstring ds, char *format, ...);
char *abs_finish_dstring (dstring ds);
char *abs_mm_finish_dstring (dstring ds);

#define abs_dstring_has_no_trailing_space(ds) ((ds -> len) && ((ds) -> s[(ds) -> len - 1] != ' '))

#ifdef __cplusplus
}
#endif
#endif /* IncAbaseDstring */
