/*
   File: warshall.h
   Specifies Warshalling routines for agflcoder
  
   Copyright 2009 Radboud University of Nijmegen

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id$"
*/
#ifndef IncWarshall
#define IncWarshall

#ifdef MCDL

/* Include MCDL mrts */
#include <mrts_mcdl.h>
#else

/* Include CDL3 types */
#include <cdl3rts.h>
#endif

/*
   ACTION initialize matrix (>INT)
   TEST matrix test (>INT1, >INT2)
   TEST matrix set (>INT,>INT1)
   ACTION warshall matrix
*/
void E208_initialize_matrix_INT (value nr_affixes);
int E210_matrix_test_INT_INT (value affix1, value affix2);
void E211_matrix_set_INT_INT (value vint1, value vint2);
void E209_warshall_matrix ();

#endif /* IncWarshall */
