/*
   File: arts_lexer.h
   Interface to lexical analysis module.

   Copyright 2009-2010 Radboud University of Nijmegen

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id$"
*/
#ifndef IncArtsLexer
#define IncArtsLexer

/* libabase includes */
#include <abase_porting.h>
#include <abase_repr.h>

/* liblexicon includes */
#include <lxcn_input.h>

/* libtrellis includes */
#include <trel_input.h>

/* Exported functions */
Trellis initialize_trellis (char *input, int linenr, int colnr);
void print_trellis (Trellis trellis);
void delete_trellis (Trellis trellis);
Transition init_fact_transition (Trellis trellis, int *entries, int idx, State i_state);
int init_or_find_fact_transition (Trellis trellis, int *entries, int idx,
				  State i_state, Transition *where);
State get_shortest_transition (Trellis trellis, State istate);
State get_next_whitespace_or_eos (Trellis trellis, State istate, int skip);
void reset_trellis_pos_memos (Trellis trellis);
void print_state_transitions (Trellis t, State state);
void print_transition (Transition trans);
void init_lexer ();
void end_lexer ();
int bonus_from_frequency (int freq, int radix);

TransitionExtension alloc_transition_extension();

#endif /* IncArtsLexer */
